/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.format;

import com.exceptionfactory.jagged.FileKey;
import com.exceptionfactory.jagged.RecipientStanza;
import com.exceptionfactory.jagged.RecipientStanzaReader;
import com.exceptionfactory.jagged.framework.crypto.HeaderKeyProducer;
import com.exceptionfactory.jagged.framework.crypto.HeaderKeyProducerFactory;
import com.exceptionfactory.jagged.framework.crypto.MacKey;
import com.exceptionfactory.jagged.framework.crypto.MessageAuthenticationCodeProducer;
import com.exceptionfactory.jagged.framework.crypto.MessageAuthenticationCodeProducerFactory;
import com.exceptionfactory.jagged.framework.format.FileHeader;
import com.exceptionfactory.jagged.framework.format.FileHeaderReader;
import com.exceptionfactory.jagged.framework.format.FileKeyReader;
import com.exceptionfactory.jagged.framework.format.StandardFileHeaderReader;
import com.exceptionfactory.jagged.framework.format.StandardFileHeaderWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.SignatureException;
import java.util.Objects;

class StandardFileKeyReader
implements FileKeyReader {
    private static final FileHeaderReader FILE_HEADER_READER = new StandardFileHeaderReader();
    private static final HeaderKeyProducer HEADER_KEY_PRODUCER = HeaderKeyProducerFactory.newHeaderKeyProducer();

    StandardFileKeyReader() {
    }

    @Override
    public FileKey readFileKey(ByteBuffer buffer, RecipientStanzaReader recipientStanzaReader) throws GeneralSecurityException, IOException {
        Objects.requireNonNull(buffer, "Buffer required");
        Objects.requireNonNull(recipientStanzaReader, "Recipient Stanza Reader required");
        FileHeader fileHeader = FILE_HEADER_READER.getFileHeader(buffer);
        Iterable<RecipientStanza> recipientStanzas = fileHeader.getRecipientStanzas();
        FileKey fileKey = recipientStanzaReader.getFileKey(recipientStanzas);
        if (fileKey == null) {
            throw new InvalidKeyException("Recipient Stanza Reader returned null File Key");
        }
        if (this.isHeaderVerified(fileHeader, fileKey)) {
            return fileKey;
        }
        throw new SignatureException("Header Message Authentication Code not verified");
    }

    private boolean isHeaderVerified(FileHeader fileHeader, FileKey fileKey) throws GeneralSecurityException, IOException {
        StandardFileHeaderWriter fileHeaderWriter = new StandardFileHeaderWriter();
        Iterable<RecipientStanza> recipientStanzas = fileHeader.getRecipientStanzas();
        ByteBuffer fileHeaderBuffer = fileHeaderWriter.writeRecipientStanzas(recipientStanzas);
        MacKey headerKey = HEADER_KEY_PRODUCER.getHeaderKey(fileKey);
        MessageAuthenticationCodeProducer producer = MessageAuthenticationCodeProducerFactory.newMessageAuthenticationCodeProducer(headerKey);
        byte[] messageAuthenticationCode = producer.getMessageAuthenticationCode(fileHeaderBuffer);
        return MessageDigest.isEqual(messageAuthenticationCode, fileHeader.getMessageAuthenticationCode());
    }
}

