/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.format;

import com.exceptionfactory.jagged.FileKey;
import com.exceptionfactory.jagged.PayloadException;
import com.exceptionfactory.jagged.RecipientStanza;
import com.exceptionfactory.jagged.RecipientStanzaWriter;
import com.exceptionfactory.jagged.framework.crypto.CipherKey;
import com.exceptionfactory.jagged.framework.crypto.HeaderKeyProducer;
import com.exceptionfactory.jagged.framework.crypto.HeaderKeyProducerFactory;
import com.exceptionfactory.jagged.framework.crypto.MacKey;
import com.exceptionfactory.jagged.framework.crypto.MessageAuthenticationCodeProducer;
import com.exceptionfactory.jagged.framework.crypto.MessageAuthenticationCodeProducerFactory;
import com.exceptionfactory.jagged.framework.crypto.PayloadKeyProducer;
import com.exceptionfactory.jagged.framework.crypto.PayloadKeyProducerFactory;
import com.exceptionfactory.jagged.framework.crypto.PayloadNonceKey;
import com.exceptionfactory.jagged.framework.format.AuthenticatedStandardFileHeaderWriter;
import com.exceptionfactory.jagged.framework.format.FileHeaderWriter;
import com.exceptionfactory.jagged.framework.format.PayloadKeyWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class StandardPayloadKeyWriter
implements PayloadKeyWriter {
    @Override
    public CipherKey writeFileHeader(ByteBuffer buffer, Iterable<RecipientStanzaWriter> recipientStanzaWriters) throws GeneralSecurityException, IOException {
        Objects.requireNonNull(buffer, "Buffer required");
        Objects.requireNonNull(recipientStanzaWriters, "Recipient Stanza Writers required");
        FileKey fileKey = new FileKey();
        List<RecipientStanza> recipientStanzas = this.writeRecipientStanzas(recipientStanzaWriters, fileKey);
        ByteBuffer fileHeader = this.writeFileHeader(recipientStanzas, fileKey);
        if (buffer.remaining() < fileHeader.remaining()) {
            String message = String.format("Buffer bytes remaining [%d] less than required File Header bytes [%d]", buffer.remaining(), fileHeader.remaining());
            throw new PayloadException(message);
        }
        buffer.put(fileHeader);
        PayloadNonceKey payloadNonceKey = new PayloadNonceKey();
        byte[] payloadNonceKeyEncoded = payloadNonceKey.getEncoded();
        if (buffer.remaining() < payloadNonceKeyEncoded.length) {
            String message = String.format("Buffer bytes remaining [%d] less than required Payload Nonce bytes [%d]", buffer.remaining(), payloadNonceKeyEncoded.length);
            throw new PayloadException(message);
        }
        buffer.put(payloadNonceKeyEncoded);
        PayloadKeyProducer payloadKeyProducer = PayloadKeyProducerFactory.newPayloadKeyProducer();
        CipherKey payloadKey = payloadKeyProducer.getPayloadKey(fileKey, payloadNonceKey);
        fileKey.destroy();
        return payloadKey;
    }

    private List<RecipientStanza> writeRecipientStanzas(Iterable<RecipientStanzaWriter> recipientStanzaWriters, FileKey fileKey) throws GeneralSecurityException {
        ArrayList<RecipientStanza> collectedRecipientStanzas = new ArrayList<RecipientStanza>();
        for (RecipientStanzaWriter recipientStanzaWriter : recipientStanzaWriters) {
            Iterable recipientStanzas = recipientStanzaWriter.getRecipientStanzas(fileKey);
            recipientStanzas.forEach(collectedRecipientStanzas::add);
        }
        return collectedRecipientStanzas;
    }

    private ByteBuffer writeFileHeader(List<RecipientStanza> recipientStanzas, FileKey fileKey) throws GeneralSecurityException, IOException {
        FileHeaderWriter fileHeaderWriter = this.getFileHeaderWriter(fileKey);
        return fileHeaderWriter.writeRecipientStanzas(recipientStanzas);
    }

    private FileHeaderWriter getFileHeaderWriter(FileKey fileKey) throws GeneralSecurityException {
        HeaderKeyProducer headerKeyProducer = HeaderKeyProducerFactory.newHeaderKeyProducer();
        MacKey headerKey = headerKeyProducer.getHeaderKey(fileKey);
        MessageAuthenticationCodeProducer messageAuthenticationCodeProducer = MessageAuthenticationCodeProducerFactory.newMessageAuthenticationCodeProducer(headerKey);
        return new AuthenticatedStandardFileHeaderWriter(messageAuthenticationCodeProducer);
    }
}

