/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.stream;

import com.exceptionfactory.jagged.PayloadException;
import com.exceptionfactory.jagged.RecipientStanzaWriter;
import com.exceptionfactory.jagged.framework.crypto.ByteBufferCipherFactory;
import com.exceptionfactory.jagged.framework.crypto.ByteBufferEncryptor;
import com.exceptionfactory.jagged.framework.crypto.CipherKey;
import com.exceptionfactory.jagged.framework.crypto.PayloadIvParameterSpec;
import com.exceptionfactory.jagged.framework.format.PayloadKeyWriter;
import com.exceptionfactory.jagged.framework.stream.ChunkSize;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Objects;

final class EncryptingChannel
implements WritableByteChannel {
    private final ByteBuffer inputBuffer = ByteBuffer.allocate(ChunkSize.PLAIN.getSize());
    private final ByteBuffer outputBuffer = ByteBuffer.allocate(ChunkSize.ENCRYPTED.getSize());
    private final PayloadIvParameterSpec payloadIvParameterSpec = new PayloadIvParameterSpec();
    private final WritableByteChannel outputChannel;
    private final CipherKey payloadKey;
    private final ByteBufferCipherFactory byteBufferCipherFactory;

    EncryptingChannel(WritableByteChannel outputChannel, Iterable<RecipientStanzaWriter> recipientStanzaWriters, PayloadKeyWriter payloadKeyWriter, ByteBufferCipherFactory byteBufferCipherFactory) throws GeneralSecurityException, IOException {
        this.outputChannel = Objects.requireNonNull(outputChannel, "Output Channel required");
        Objects.requireNonNull(recipientStanzaWriters, "Recipient Stanza Writers required");
        Objects.requireNonNull(payloadKeyWriter, "Payload Key Writer required");
        this.byteBufferCipherFactory = Objects.requireNonNull(byteBufferCipherFactory, "Byte Buffer Cipher Factory required");
        this.payloadKey = payloadKeyWriter.writeFileHeader(this.outputBuffer, recipientStanzaWriters);
        this.flushOutputBuffer();
    }

    @Override
    public int write(ByteBuffer sourceBuffer) throws IOException {
        Objects.requireNonNull(sourceBuffer, "Source Buffer required");
        int sourceBufferLimit = sourceBuffer.limit();
        int sourceBufferStartPosition = sourceBuffer.position();
        while (sourceBuffer.hasRemaining()) {
            if (this.inputBuffer.remaining() == 0) {
                this.flushInputBuffer();
            }
            int inputBufferRemaining = this.inputBuffer.remaining();
            int sourceBufferRemaining = sourceBuffer.remaining();
            if (sourceBufferRemaining > inputBufferRemaining) {
                int sourceBufferInputLimit = sourceBuffer.position() + inputBufferRemaining;
                sourceBuffer.limit(sourceBufferInputLimit);
            }
            this.inputBuffer.put(sourceBuffer);
            sourceBuffer.limit(sourceBufferLimit);
        }
        return sourceBuffer.position() - sourceBufferStartPosition;
    }

    @Override
    public boolean isOpen() {
        return this.outputChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.outputChannel.isOpen()) {
            this.payloadIvParameterSpec.setLastChunkFlag();
            this.flushInputBuffer();
            this.outputChannel.close();
            this.payloadKey.destroy();
        }
    }

    private void flushInputBuffer() throws IOException {
        this.inputBuffer.flip();
        try {
            ByteBufferEncryptor byteBufferEncryptor = this.byteBufferCipherFactory.newByteBufferEncryptor(this.payloadKey, this.payloadIvParameterSpec);
            byteBufferEncryptor.encrypt(this.inputBuffer, this.outputBuffer);
        }
        catch (GeneralSecurityException e) {
            String message = String.format("Write chunk failed: counter %s", Arrays.toString(this.payloadIvParameterSpec.getIV()));
            throw new PayloadException(message, (Throwable)e);
        }
        this.flushOutputBuffer();
        this.inputBuffer.clear();
        this.payloadIvParameterSpec.incrementInitializationVector();
    }

    private void flushOutputBuffer() throws IOException {
        this.outputBuffer.flip();
        while (this.outputBuffer.hasRemaining()) {
            this.outputChannel.write(this.outputBuffer);
        }
        this.outputBuffer.clear();
    }
}

