/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.stream;

import com.exceptionfactory.jagged.EncryptingChannelFactory;
import com.exceptionfactory.jagged.RecipientStanzaWriter;
import com.exceptionfactory.jagged.framework.crypto.ByteBufferCipherFactory;
import com.exceptionfactory.jagged.framework.crypto.StandardByteBufferCipherFactory;
import com.exceptionfactory.jagged.framework.format.StandardPayloadKeyWriter;
import com.exceptionfactory.jagged.framework.stream.EncryptingChannel;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.util.Objects;

public class StandardEncryptingChannelFactory
implements EncryptingChannelFactory {
    private final ByteBufferCipherFactory byteBufferCipherFactory;

    public StandardEncryptingChannelFactory() {
        this.byteBufferCipherFactory = new StandardByteBufferCipherFactory();
    }

    public StandardEncryptingChannelFactory(Provider provider) {
        Objects.requireNonNull(provider, "Provider required");
        this.byteBufferCipherFactory = new StandardByteBufferCipherFactory(provider);
    }

    public WritableByteChannel newEncryptingChannel(WritableByteChannel outputChannel, Iterable<RecipientStanzaWriter> recipientStanzaWriters) throws GeneralSecurityException, IOException {
        Objects.requireNonNull(outputChannel, "Output Channel required");
        Objects.requireNonNull(recipientStanzaWriters, "Recipient Stanza Writers required");
        if (outputChannel.isOpen()) {
            StandardPayloadKeyWriter payloadKeyWriter = new StandardPayloadKeyWriter();
            return new EncryptingChannel(outputChannel, recipientStanzaWriters, payloadKeyWriter, this.byteBufferCipherFactory);
        }
        throw new ClosedChannelException();
    }
}

