/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.armor;

import com.exceptionfactory.jagged.framework.armor.ArmoredIndicator;
import com.exceptionfactory.jagged.framework.armor.ArmoredSeparator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Base64;
import java.util.Objects;

final class ArmoredWritableByteChannel
implements WritableByteChannel {
    private static final int HEADER_BUFFER_LENGTH = 36;
    private static final int FOOTER_BUFFER_LENGTH = 34;
    private static final int MAXIMUM_SOURCE_LINE_LENGTH = 48;
    private static final int MAXIMUM_ENCODED_LINE_LENGTH = 64;
    private static final int CHUNK_LENGTH = 66560;
    private static final int START_POSITION = 0;
    private static final byte LINE_FEED = ArmoredSeparator.LINE_FEED.getCode();
    private static final byte[] LINE_FEED_BYTES = new byte[]{LINE_FEED};
    private static final Base64.Encoder ENCODER = Base64.getEncoder();
    private final ByteBuffer lineFeedBuffer = ByteBuffer.wrap(LINE_FEED_BYTES);
    private final ByteBuffer lineBuffer = ByteBuffer.allocate(48);
    private final ByteBuffer chunkBuffer = ByteBuffer.allocate(66560);
    private final WritableByteChannel outputChannel;

    ArmoredWritableByteChannel(WritableByteChannel outputChannel) throws IOException {
        this.outputChannel = Objects.requireNonNull(outputChannel, "Output Channel required");
        this.writeHeader();
    }

    @Override
    public int write(ByteBuffer sourceBuffer) throws IOException {
        Objects.requireNonNull(sourceBuffer, "Source Buffer required");
        int sourceBufferLimit = sourceBuffer.limit();
        this.putLineBuffer(sourceBuffer);
        if (this.lineBuffer.position() == 0) {
            int sourceBufferRemaining = sourceBuffer.remaining();
            int sourceBufferLineModulus = sourceBufferRemaining % 48;
            if (sourceBufferLineModulus > 0) {
                int sourceBufferLimitAdjusted = sourceBufferLimit - sourceBufferLineModulus;
                sourceBuffer.limit(sourceBufferLimitAdjusted);
            }
            ByteBuffer encodedSourceBuffer = ENCODER.encode(sourceBuffer);
            this.writeEncodedBuffer(encodedSourceBuffer);
            sourceBuffer.limit(sourceBufferLimit);
            this.putLineBuffer(sourceBuffer);
        }
        return sourceBufferLimit;
    }

    @Override
    public boolean isOpen() {
        return this.outputChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.outputChannel.isOpen()) {
            if (this.lineBuffer.position() > 0) {
                this.writeLineBuffer();
            }
            this.writeFooter();
            this.outputChannel.close();
        }
    }

    private void writeHeader() throws IOException {
        ByteBuffer headerBuffer = ByteBuffer.allocate(36);
        headerBuffer.put(ArmoredIndicator.HEADER.getIndicator());
        headerBuffer.put(LINE_FEED);
        headerBuffer.flip();
        this.writeBuffer(headerBuffer);
    }

    private void writeFooter() throws IOException {
        ByteBuffer footerBuffer = ByteBuffer.allocate(34);
        footerBuffer.put(ArmoredIndicator.FOOTER.getIndicator());
        footerBuffer.put(LINE_FEED);
        footerBuffer.flip();
        this.writeBuffer(footerBuffer);
    }

    private void writeEncodedBuffer(ByteBuffer encodedBuffer) throws IOException {
        int encodedBufferLimit = encodedBuffer.limit();
        while (encodedBuffer.hasRemaining()) {
            while (this.chunkBuffer.hasRemaining()) {
                int limit = encodedBuffer.position() + 64;
                encodedBuffer.limit(limit);
                this.chunkBuffer.put(encodedBuffer);
                encodedBuffer.limit(encodedBufferLimit);
                this.chunkBuffer.put(this.lineFeedBuffer);
                this.lineFeedBuffer.position(0);
                if (encodedBuffer.remaining() != 0) continue;
                break;
            }
            this.chunkBuffer.flip();
            this.writeBuffer(this.chunkBuffer);
            this.chunkBuffer.clear();
            encodedBuffer.limit(encodedBufferLimit);
        }
    }

    private void writeLineBuffer() throws IOException {
        this.lineBuffer.flip();
        ByteBuffer encodedLineBuffer = ENCODER.encode(this.lineBuffer);
        this.writeBuffer(encodedLineBuffer);
        this.writeBuffer(this.lineFeedBuffer);
        this.lineFeedBuffer.position(0);
    }

    private void writeBuffer(ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            this.outputChannel.write(buffer);
        }
    }

    private void putLineBuffer(ByteBuffer sourceBuffer) throws IOException {
        int lineBufferRemaining = this.lineBuffer.remaining();
        if (lineBufferRemaining > sourceBuffer.remaining()) {
            this.lineBuffer.put(sourceBuffer);
        } else if (this.lineBuffer.position() > 0) {
            int sourceBufferLimit = sourceBuffer.limit();
            if (sourceBuffer.remaining() > lineBufferRemaining) {
                int sourceBufferLimitAdjusted = sourceBuffer.position() + lineBufferRemaining;
                sourceBuffer.limit(sourceBufferLimitAdjusted);
            }
            this.lineBuffer.put(sourceBuffer);
            sourceBuffer.limit(sourceBufferLimit);
        }
        if (this.lineBuffer.position() == 48) {
            this.writeLineBuffer();
            this.lineBuffer.clear();
        }
    }
}

