/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.codec;

import com.exceptionfactory.jagged.framework.codec.CanonicalBase64;
import java.util.Arrays;
import java.util.Base64;

class CanonicalBase64Decoder
implements CanonicalBase64.Decoder {
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private static final Base64.Encoder ENCODER_WITHOUT_PADDING = Base64.getEncoder().withoutPadding();

    CanonicalBase64Decoder() {
    }

    @Override
    public byte[] decode(byte[] encoded) {
        this.requireValidated(encoded);
        byte[] decoded = DECODER.decode(encoded);
        byte[] canonicalEncoded = ENCODER_WITHOUT_PADDING.encode(decoded);
        if (Arrays.equals(canonicalEncoded, encoded)) {
            return decoded;
        }
        throw new IllegalArgumentException("Encoded Base64 padding not allowed");
    }

    private void requireValidated(byte[] encoded) {
        if (encoded == null) {
            throw new IllegalArgumentException("Encoded Base64 required");
        }
        for (byte encodedCodePoint : encoded) {
            if (!Character.isWhitespace(encodedCodePoint)) continue;
            throw new IllegalArgumentException("Encoded Base64 whitespace not allowed");
        }
    }
}

