/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.codec;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Objects;

public class CanonicalBase64OutputStream
extends FilterOutputStream {
    private static final int LINE_FEED = 10;
    private static final int MAXIMUM_LINE_LENGTH = 64;
    private static final int EMPTY_LINE_LENGTH = 0;
    private static final Base64.Encoder ENCODER = Base64.getEncoder().withoutPadding();

    public CanonicalBase64OutputStream(OutputStream outputStream) {
        super(ENCODER.wrap(new LineEncodingOutputStream(Objects.requireNonNull(outputStream, "Output Stream required"))));
    }

    private static final class LineEncodingOutputStream
    extends FilterOutputStream {
        private int lineLength = 0;

        private LineEncodingOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        @Override
        public void write(int code) throws IOException {
            super.write(code);
            ++this.lineLength;
            if (this.lineLength == 64) {
                super.write(10);
                this.lineLength = 0;
            }
        }
    }
}

