/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.crypto;

import com.exceptionfactory.jagged.framework.crypto.CryptographicAlgorithm;
import com.exceptionfactory.jagged.framework.crypto.CryptographicKeyDescription;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.SecretKey;

class CryptographicAlgorithmKey
implements SecretKey {
    private static final String FORMAT = "RAW";
    private static final byte ZERO = 0;
    private final AtomicBoolean destroyed = new AtomicBoolean();
    private final byte[] key;
    private final CryptographicAlgorithm cryptographicAlgorithm;

    CryptographicAlgorithmKey(byte[] key, CryptographicKeyDescription cryptographicKeyDescription, CryptographicAlgorithm cryptographicAlgorithm) {
        this(CryptographicAlgorithmKey.getValidatedKey(key, cryptographicKeyDescription), cryptographicAlgorithm);
    }

    private CryptographicAlgorithmKey(byte[] validatedKey, CryptographicAlgorithm cryptographicAlgorithm) {
        this.key = validatedKey;
        this.cryptographicAlgorithm = Objects.requireNonNull(cryptographicAlgorithm, "Algorithm required");
    }

    @Override
    public String getAlgorithm() {
        return this.cryptographicAlgorithm.getAlgorithm();
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    @Override
    public void destroy() {
        Arrays.fill(this.key, (byte)0);
        this.destroyed.set(true);
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    private static byte[] getValidatedKey(byte[] key, CryptographicKeyDescription cryptographicKeyDescription) {
        Objects.requireNonNull(key, "Symmetric Key required");
        Objects.requireNonNull(cryptographicKeyDescription, "Cryptographic Key Description required");
        int cryptographicKeyLength = cryptographicKeyDescription.getKeyLength();
        if (cryptographicKeyLength == key.length) {
            return key;
        }
        String message = String.format("Symmetric Key Length [%d] not equal to required length [%d]", key.length, cryptographicKeyLength);
        throw new IllegalArgumentException(message);
    }
}

