/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.crypto;

import com.exceptionfactory.jagged.framework.crypto.CryptographicKeyType;
import com.exceptionfactory.jagged.framework.crypto.MacKey;
import com.exceptionfactory.jagged.framework.crypto.MessageAuthenticationCodeProducer;
import com.exceptionfactory.jagged.framework.crypto.MessageAuthenticationCodeProducerFactory;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import javax.crypto.SecretKey;

public class HashedDerivedKeyProducer {
    private static final byte FIRST_ITERATION = 1;

    protected byte[] getDerivedKey(SecretKey inputKey, MacKey saltKey, byte[] info) throws GeneralSecurityException {
        MacKey extractedKey = this.getExtractedKey(inputKey, saltKey);
        return this.getExpandedKey(extractedKey, info);
    }

    private MacKey getExtractedKey(SecretKey inputKey, MacKey saltKey) throws GeneralSecurityException {
        MessageAuthenticationCodeProducer producer = MessageAuthenticationCodeProducerFactory.newMessageAuthenticationCodeProducer(saltKey);
        ByteBuffer inputKeyEncoded = ByteBuffer.wrap(inputKey.getEncoded());
        byte[] extracted = producer.getMessageAuthenticationCode(inputKeyEncoded);
        return new MacKey(extracted, CryptographicKeyType.EXTRACTED_KEY);
    }

    private byte[] getExpandedKey(MacKey extractedKey, byte[] info) throws GeneralSecurityException {
        MessageAuthenticationCodeProducer producer = MessageAuthenticationCodeProducerFactory.newMessageAuthenticationCodeProducer(extractedKey);
        ByteBuffer infoFirstIterationEncoded = this.getInfoFirstIterationEncoded(info);
        return producer.getMessageAuthenticationCode(infoFirstIterationEncoded);
    }

    private ByteBuffer getInfoFirstIterationEncoded(byte[] info) {
        int encodedLength = info.length + 1;
        ByteBuffer encoded = ByteBuffer.allocate(encodedLength);
        encoded.put(info);
        encoded.put((byte)1);
        encoded.flip();
        return encoded;
    }
}

