/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.crypto;

import javax.crypto.spec.IvParameterSpec;

public final class PayloadIvParameterSpec
extends IvParameterSpec {
    private static final int LAST_INITIALIZATION_VECTOR_COUNTER_INDEX = 10;
    private static final int LAST_CHUNK_FLAG_INDEX = 11;
    private static final int LAST_CHUNK_FLAG = 1;
    private static final int INITIALIZATION_VECTOR_LENGTH = 12;
    private final byte[] initializationVector;

    public PayloadIvParameterSpec() {
        this(new byte[12]);
    }

    PayloadIvParameterSpec(byte[] initializationVector) {
        super(PayloadIvParameterSpec.getValidatedInitializationVector(initializationVector));
        this.initializationVector = initializationVector;
    }

    @Override
    public byte[] getIV() {
        return (byte[])this.initializationVector.clone();
    }

    public void incrementInitializationVector() {
        boolean incrementRequired = true;
        int i = 10;
        while (incrementRequired) {
            int n = i;
            this.initializationVector[n] = (byte)(this.initializationVector[n] + 1);
            if (this.initializationVector[i] != 0) {
                incrementRequired = false;
            } else if (i == 0) {
                throw new IllegalStateException("Maximum counter size exceeded");
            }
            --i;
        }
    }

    public void setLastChunkFlag() {
        this.initializationVector[11] = 1;
    }

    public boolean isNotFirstChunk() {
        boolean notFirstChunk = false;
        for (int i = 0; i < 11; ++i) {
            byte counter = this.initializationVector[i];
            if (counter == 0) continue;
            notFirstChunk = true;
            break;
        }
        return notFirstChunk;
    }

    private static byte[] getValidatedInitializationVector(byte[] initializationVector) {
        if (initializationVector == null) {
            throw new IllegalArgumentException("Initialization Vector required");
        }
        if (initializationVector.length != 12) {
            String message = String.format("Initialization Vector length [%d] not required length [%d]", initializationVector.length, 12);
            throw new IllegalArgumentException(message);
        }
        byte[] validatedInitializationVector = initializationVector;
        return validatedInitializationVector;
    }
}

