/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.crypto;

import com.exceptionfactory.jagged.framework.crypto.ByteBufferCipherFactory;
import com.exceptionfactory.jagged.framework.crypto.ByteBufferDecryptor;
import com.exceptionfactory.jagged.framework.crypto.ByteBufferEncryptor;
import com.exceptionfactory.jagged.framework.crypto.CipherFactory;
import com.exceptionfactory.jagged.framework.crypto.CipherKey;
import com.exceptionfactory.jagged.framework.crypto.StandardByteBufferDecryptor;
import com.exceptionfactory.jagged.framework.crypto.StandardByteBufferEncryptor;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.util.Objects;
import javax.crypto.spec.IvParameterSpec;

public final class StandardByteBufferCipherFactory
implements ByteBufferCipherFactory {
    private final CipherFactory cipherFactory;

    public StandardByteBufferCipherFactory() {
        this.cipherFactory = new CipherFactory();
    }

    public StandardByteBufferCipherFactory(Provider provider) {
        Objects.requireNonNull(provider, "Provider required");
        this.cipherFactory = new CipherFactory(provider);
    }

    @Override
    public ByteBufferDecryptor newByteBufferDecryptor(CipherKey cipherKey, IvParameterSpec parameterSpec) throws GeneralSecurityException {
        return new StandardByteBufferDecryptor(this.cipherFactory, cipherKey, parameterSpec);
    }

    @Override
    public ByteBufferEncryptor newByteBufferEncryptor(CipherKey cipherKey, IvParameterSpec parameterSpec) throws GeneralSecurityException {
        return new StandardByteBufferEncryptor(this.cipherFactory, cipherKey, parameterSpec);
    }
}

