/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.crypto;

import com.exceptionfactory.jagged.FileKey;
import com.exceptionfactory.jagged.framework.crypto.CipherFactory;
import com.exceptionfactory.jagged.framework.crypto.CipherKey;
import com.exceptionfactory.jagged.framework.crypto.EncryptedFileKey;
import com.exceptionfactory.jagged.framework.crypto.FileKeyDecryptor;
import com.exceptionfactory.jagged.framework.crypto.FileKeyIvParameterSpec;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.util.Objects;
import javax.crypto.Cipher;

class StandardFileKeyDecryptor
implements FileKeyDecryptor {
    private final CipherFactory cipherFactory;

    StandardFileKeyDecryptor() {
        this.cipherFactory = new CipherFactory();
    }

    StandardFileKeyDecryptor(Provider provider) {
        this.cipherFactory = new CipherFactory(provider);
    }

    @Override
    public FileKey getFileKey(EncryptedFileKey encryptedFileKey, CipherKey cipherKey) throws GeneralSecurityException {
        Objects.requireNonNull(encryptedFileKey, "Encrypted File Key required");
        Objects.requireNonNull(cipherKey, "Cipher Key required");
        FileKeyIvParameterSpec parameterSpec = new FileKeyIvParameterSpec();
        Cipher cipher = this.cipherFactory.getInitializedCipher(CipherFactory.CipherMode.DECRYPT, cipherKey, parameterSpec);
        byte[] encryptedFileKeyEncoded = encryptedFileKey.getEncoded();
        byte[] fileKeyEncoded = cipher.doFinal(encryptedFileKeyEncoded);
        return new FileKey(fileKeyEncoded);
    }
}

