/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.crypto;

import com.exceptionfactory.jagged.framework.crypto.MacKey;
import com.exceptionfactory.jagged.framework.crypto.MessageAuthenticationCodeProducer;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Objects;
import javax.crypto.Mac;

final class StandardMessageAuthenticationCodeProducer
implements MessageAuthenticationCodeProducer {
    private final Mac mac;

    StandardMessageAuthenticationCodeProducer(MacKey macKey) throws GeneralSecurityException {
        this.mac = Mac.getInstance(macKey.getAlgorithm());
        this.mac.init(macKey);
    }

    @Override
    public byte[] getMessageAuthenticationCode(ByteBuffer inputBuffer) {
        Objects.requireNonNull(inputBuffer, "Input Buffer required");
        this.mac.update(inputBuffer);
        return this.mac.doFinal();
    }
}

