/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.crypto;

import com.exceptionfactory.jagged.FileKey;
import com.exceptionfactory.jagged.framework.crypto.CipherKey;
import com.exceptionfactory.jagged.framework.crypto.HashedDerivedKeyProducer;
import com.exceptionfactory.jagged.framework.crypto.PayloadKeyProducer;
import com.exceptionfactory.jagged.framework.crypto.PayloadNonceKey;
import java.security.GeneralSecurityException;
import java.util.Objects;
import javax.crypto.SecretKey;

class StandardPayloadKeyProducer
extends HashedDerivedKeyProducer
implements PayloadKeyProducer {
    private static final byte[] PAYLOAD_INFO = new byte[]{112, 97, 121, 108, 111, 97, 100};

    StandardPayloadKeyProducer() {
    }

    @Override
    public CipherKey getPayloadKey(FileKey fileKey, PayloadNonceKey payloadNonceKey) throws GeneralSecurityException {
        Objects.requireNonNull(fileKey, "File Key required");
        Objects.requireNonNull(payloadNonceKey, "Payload Nonce Key required");
        byte[] payloadKey = this.getDerivedKey((SecretKey)fileKey, payloadNonceKey, PAYLOAD_INFO);
        return new CipherKey(payloadKey);
    }
}

