/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.format;

import com.exceptionfactory.jagged.RecipientStanza;
import com.exceptionfactory.jagged.framework.codec.CanonicalBase64;
import com.exceptionfactory.jagged.framework.crypto.MessageAuthenticationCodeProducer;
import com.exceptionfactory.jagged.framework.format.StandardFileHeaderWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Objects;

class AuthenticatedStandardFileHeaderWriter
extends StandardFileHeaderWriter {
    private static final int MESSAGE_AUTHENTICATION_CODE_FOOTER_LENGTH = 45;
    private static final byte SPACE_SEPARATOR = 32;
    private static final byte LINE_FEED = 10;
    private static final CanonicalBase64.Encoder ENCODER = CanonicalBase64.getEncoder();
    private final MessageAuthenticationCodeProducer messageAuthenticationCodeProducer;

    AuthenticatedStandardFileHeaderWriter(MessageAuthenticationCodeProducer messageAuthenticationCodeProducer) {
        this.messageAuthenticationCodeProducer = Objects.requireNonNull(messageAuthenticationCodeProducer, "Authentication Code Producer required");
    }

    @Override
    public ByteBuffer writeRecipientStanzas(Iterable<RecipientStanza> recipientStanzas) throws GeneralSecurityException, IOException {
        Objects.requireNonNull(recipientStanzas, "Recipient Stanzas required");
        ByteBuffer serialized = super.writeRecipientStanzas(recipientStanzas);
        byte[] messageAuthenticationCode = this.messageAuthenticationCodeProducer.getMessageAuthenticationCode(serialized);
        serialized.rewind();
        int capacity = serialized.capacity() + 45;
        ByteBuffer authenticated = ByteBuffer.allocate(capacity);
        authenticated.put(serialized);
        authenticated.put((byte)32);
        byte[] messageAuthenticationCodeEncoded = ENCODER.encode(messageAuthenticationCode);
        authenticated.put(messageAuthenticationCodeEncoded);
        authenticated.put((byte)10);
        authenticated.flip();
        return authenticated;
    }
}

