/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.format;

import com.exceptionfactory.jagged.RecipientStanza;
import com.exceptionfactory.jagged.framework.codec.CanonicalBase64OutputStream;
import com.exceptionfactory.jagged.framework.format.FileHeaderWriter;
import com.exceptionfactory.jagged.framework.format.SectionIndicator;
import com.exceptionfactory.jagged.framework.format.SectionSeparator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Objects;

class StandardFileHeaderWriter
implements FileHeaderWriter {
    private static final int INITIAL_BUFFER_SIZE = 128;
    private static final Charset STANDARD_CHARACTER_SET = StandardCharsets.UTF_8;

    StandardFileHeaderWriter() {
    }

    @Override
    public ByteBuffer writeRecipientStanzas(Iterable<RecipientStanza> recipientStanzas) throws GeneralSecurityException, IOException {
        Objects.requireNonNull(recipientStanzas, "Recipient Stanzas required");
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(128);){
            this.writeRecipientStanzas(outputStream, recipientStanzas);
            byte[] serialized = outputStream.toByteArray();
            ByteBuffer byteBuffer = ByteBuffer.wrap(serialized);
            return byteBuffer;
        }
    }

    private void writeRecipientStanzas(ByteArrayOutputStream outputStream, Iterable<RecipientStanza> recipientStanzas) throws IOException {
        outputStream.write(SectionIndicator.VERSION.getIndicator());
        outputStream.write(SectionSeparator.LINE_FEED.getCode());
        for (RecipientStanza recipientStanza : recipientStanzas) {
            this.writeRecipientStanza(outputStream, recipientStanza);
        }
        outputStream.write(SectionIndicator.END.getIndicator());
    }

    private void writeRecipientStanza(ByteArrayOutputStream outputStream, RecipientStanza recipientStanza) throws IOException {
        outputStream.write(SectionIndicator.STANZA.getIndicator());
        byte[] typeBytes = recipientStanza.getType().getBytes(STANDARD_CHARACTER_SET);
        outputStream.write(typeBytes);
        for (String argument : recipientStanza.getArguments()) {
            outputStream.write(SectionSeparator.SPACE.getCode());
            byte[] argumentBytes = argument.getBytes(STANDARD_CHARACTER_SET);
            outputStream.write(argumentBytes);
        }
        outputStream.write(SectionSeparator.LINE_FEED.getCode());
        try (CanonicalBase64OutputStream encodingOutputStream = new CanonicalBase64OutputStream(outputStream);){
            byte[] body = recipientStanza.getBody();
            encodingOutputStream.write(body);
        }
        outputStream.write(SectionSeparator.LINE_FEED.getCode());
    }
}

