/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.format;

import com.exceptionfactory.jagged.FileKey;
import com.exceptionfactory.jagged.RecipientStanzaReader;
import com.exceptionfactory.jagged.UnsupportedRecipientStanzaException;
import com.exceptionfactory.jagged.framework.crypto.CipherKey;
import com.exceptionfactory.jagged.framework.crypto.PayloadKeyProducer;
import com.exceptionfactory.jagged.framework.crypto.PayloadKeyProducerFactory;
import com.exceptionfactory.jagged.framework.crypto.PayloadNonceKey;
import com.exceptionfactory.jagged.framework.format.FileKeyReader;
import com.exceptionfactory.jagged.framework.format.PayloadKeyReader;
import com.exceptionfactory.jagged.framework.format.StandardFileKeyReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Objects;

public class StandardPayloadKeyReader
implements PayloadKeyReader {
    private static final int NONCE_LENGTH = 16;
    private final FileKeyReader fileKeyReader;
    private final PayloadKeyProducer payloadKeyProducer = PayloadKeyProducerFactory.newPayloadKeyProducer();

    public StandardPayloadKeyReader() {
        this(new StandardFileKeyReader());
    }

    StandardPayloadKeyReader(FileKeyReader fileKeyReader) {
        this.fileKeyReader = fileKeyReader;
    }

    @Override
    public CipherKey getPayloadKey(ByteBuffer buffer, Iterable<RecipientStanzaReader> recipientStanzaReaders) throws GeneralSecurityException, IOException {
        Objects.requireNonNull(buffer, "Buffer required");
        Objects.requireNonNull(recipientStanzaReaders, "Recipient Stanza Readers required");
        FileKey fileKey = this.readFileKey(buffer, recipientStanzaReaders);
        PayloadNonceKey payloadNonceKey = this.readPayloadNonceKey(buffer);
        CipherKey payloadKey = this.payloadKeyProducer.getPayloadKey(fileKey, payloadNonceKey);
        fileKey.destroy();
        return payloadKey;
    }

    private FileKey readFileKey(ByteBuffer buffer, Iterable<RecipientStanzaReader> recipientStanzaReaders) throws GeneralSecurityException, IOException {
        ArrayList<GeneralSecurityException> exceptions = new ArrayList<GeneralSecurityException>();
        FileKey fileKey = null;
        buffer.mark();
        for (RecipientStanzaReader recipientStanzaReader : recipientStanzaReaders) {
            try {
                fileKey = this.fileKeyReader.readFileKey(buffer, recipientStanzaReader);
                break;
            }
            catch (GeneralSecurityException e) {
                exceptions.add(e);
                buffer.reset();
            }
        }
        if (fileKey == null) {
            if (exceptions.size() == 1) {
                throw (GeneralSecurityException)exceptions.get(0);
            }
            UnsupportedRecipientStanzaException exception = new UnsupportedRecipientStanzaException("Supported Recipient Stanza not found");
            exceptions.forEach(arg_0 -> exception.addSuppressed(arg_0));
            throw exception;
        }
        return fileKey;
    }

    private PayloadNonceKey readPayloadNonceKey(ByteBuffer buffer) throws InvalidParameterSpecException {
        if (buffer.remaining() < 16) {
            throw new InvalidParameterSpecException("Payload Nonce not found");
        }
        byte[] nonce = new byte[16];
        buffer.get(nonce);
        return new PayloadNonceKey(nonce);
    }
}

