/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.stream;

import com.exceptionfactory.jagged.PayloadException;
import com.exceptionfactory.jagged.RecipientStanzaReader;
import com.exceptionfactory.jagged.framework.crypto.ByteBufferCipherFactory;
import com.exceptionfactory.jagged.framework.crypto.ByteBufferDecryptor;
import com.exceptionfactory.jagged.framework.crypto.CipherKey;
import com.exceptionfactory.jagged.framework.crypto.PayloadIvParameterSpec;
import com.exceptionfactory.jagged.framework.format.PayloadKeyReader;
import com.exceptionfactory.jagged.framework.stream.ChunkSize;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.IllegalBlockSizeException;

final class DecryptingChannel
implements ReadableByteChannel {
    private static final int END_OF_FILE = -1;
    private final ByteBuffer inputBuffer = ByteBuffer.allocate(ChunkSize.ENCRYPTED.getSize());
    private final ByteBuffer nextByteInputBuffer = ByteBuffer.allocate(1);
    private final ByteBuffer plainBuffer = ByteBuffer.allocate(ChunkSize.PLAIN.getSize());
    private final PayloadIvParameterSpec payloadIvParameterSpec = new PayloadIvParameterSpec();
    private final ReadableByteChannel inputChannel;
    private final CipherKey payloadKey;
    private final ByteBufferCipherFactory byteBufferCipherFactory;

    DecryptingChannel(ReadableByteChannel inputChannel, Iterable<RecipientStanzaReader> recipientStanzaReaders, PayloadKeyReader payloadKeyReader, ByteBufferCipherFactory byteBufferCipherFactory) throws GeneralSecurityException, IOException {
        this.inputChannel = Objects.requireNonNull(inputChannel, "Input Channel required");
        this.byteBufferCipherFactory = Objects.requireNonNull(byteBufferCipherFactory, "Byte Buffer Cipher Factory required");
        this.readInputChannel();
        this.payloadKey = payloadKeyReader.getPayloadKey(this.inputBuffer, recipientStanzaReaders);
        if (this.inputBuffer.limit() == ChunkSize.ENCRYPTED.getSize()) {
            this.inputBuffer.compact();
            this.readInputChannel();
        } else if (this.inputBuffer.position() == this.inputBuffer.limit()) {
            throw new PayloadException(String.format("Payload not found after reading File Header [%d bytes]", this.inputBuffer.position()));
        }
        this.plainBuffer.flip();
    }

    @Override
    public int read(ByteBuffer outputBuffer) throws IOException {
        Objects.requireNonNull(outputBuffer, "Output Buffer required");
        int read = 0;
        while (outputBuffer.hasRemaining()) {
            int plainBufferRead;
            if (this.plainBuffer.remaining() == 0) {
                try {
                    this.readChunk();
                    this.inputBuffer.clear();
                    this.readInputChannel();
                }
                catch (GeneralSecurityException e) {
                    String message = String.format("Read chunk failed: counter %s", Arrays.toString(this.payloadIvParameterSpec.getIV()));
                    throw new PayloadException(message, (Throwable)e);
                }
            }
            if (-1 == (plainBufferRead = this.readPlainBuffer(outputBuffer))) {
                if (read != 0) break;
                read = -1;
                break;
            }
            read += plainBufferRead;
        }
        return read;
    }

    @Override
    public boolean isOpen() {
        return this.inputChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.payloadKey.destroy();
        this.plainBuffer.clear();
        this.inputBuffer.clear();
        this.nextByteInputBuffer.clear();
        this.inputChannel.close();
    }

    private void readInputChannel() throws IOException {
        if (this.inputBuffer.hasRemaining()) {
            this.nextByteInputBuffer.flip();
            this.inputBuffer.put(this.nextByteInputBuffer);
            this.nextByteInputBuffer.clear();
        }
        if (this.inputBuffer.hasRemaining()) {
            this.readInputChannel(this.inputBuffer);
            this.readInputChannel(this.nextByteInputBuffer);
        }
        this.inputBuffer.flip();
    }

    private void readInputChannel(ByteBuffer buffer) throws IOException {
        int read = this.inputChannel.read(buffer);
        while (buffer.hasRemaining()) {
            if (-1 == read) {
                this.payloadIvParameterSpec.setLastChunkFlag();
                break;
            }
            read = this.inputChannel.read(buffer);
        }
    }

    private int readPlainBuffer(ByteBuffer outputBuffer) {
        int read = -1;
        if (this.plainBuffer.hasRemaining()) {
            ++read;
        }
        int plainBufferLimit = this.plainBuffer.limit();
        while (this.plainBuffer.hasRemaining() && outputBuffer.hasRemaining()) {
            int outputBufferRemaining = outputBuffer.remaining();
            int plainBufferRemaining = this.plainBuffer.remaining();
            if (plainBufferRemaining > outputBufferRemaining) {
                int plainBufferInputLimit = this.plainBuffer.position() + outputBufferRemaining;
                this.plainBuffer.limit(plainBufferInputLimit);
            }
            int plainBufferStartPosition = this.plainBuffer.position();
            outputBuffer.put(this.plainBuffer);
            this.plainBuffer.limit(plainBufferLimit);
            int plainBufferRead = this.plainBuffer.position() - plainBufferStartPosition;
            read += plainBufferRead;
        }
        return read;
    }

    private void readChunk() throws GeneralSecurityException {
        if (this.inputBuffer.hasRemaining()) {
            this.plainBuffer.clear();
            ByteBufferDecryptor byteBufferDecryptor = this.byteBufferCipherFactory.newByteBufferDecryptor(this.payloadKey, this.payloadIvParameterSpec);
            byteBufferDecryptor.decrypt(this.inputBuffer, this.plainBuffer);
            if (this.plainBuffer.position() == 0 && this.payloadIvParameterSpec.isNotFirstChunk()) {
                throw new IllegalBlockSizeException("Last Payload chunk not found");
            }
            this.payloadIvParameterSpec.incrementInitializationVector();
            this.plainBuffer.flip();
        }
    }
}

