/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.framework.stream;

import com.exceptionfactory.jagged.DecryptingChannelFactory;
import com.exceptionfactory.jagged.RecipientStanzaReader;
import com.exceptionfactory.jagged.framework.crypto.ByteBufferCipherFactory;
import com.exceptionfactory.jagged.framework.crypto.StandardByteBufferCipherFactory;
import com.exceptionfactory.jagged.framework.format.StandardPayloadKeyReader;
import com.exceptionfactory.jagged.framework.stream.DecryptingChannel;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.util.Objects;

public class StandardDecryptingChannelFactory
implements DecryptingChannelFactory {
    private final ByteBufferCipherFactory byteBufferCipherFactory;

    public StandardDecryptingChannelFactory() {
        this.byteBufferCipherFactory = new StandardByteBufferCipherFactory();
    }

    public StandardDecryptingChannelFactory(Provider provider) {
        Objects.requireNonNull(provider, "Provider required");
        this.byteBufferCipherFactory = new StandardByteBufferCipherFactory(provider);
    }

    public ReadableByteChannel newDecryptingChannel(ReadableByteChannel inputChannel, Iterable<RecipientStanzaReader> recipientStanzaReaders) throws GeneralSecurityException, IOException {
        Objects.requireNonNull(inputChannel, "Input Channel required");
        Objects.requireNonNull(recipientStanzaReaders, "Recipient Stanza Readers required");
        if (inputChannel.isOpen()) {
            StandardPayloadKeyReader payloadKeyReader = new StandardPayloadKeyReader();
            return new DecryptingChannel(inputChannel, recipientStanzaReaders, payloadKeyReader, this.byteBufferCipherFactory);
        }
        throw new ClosedChannelException();
    }
}

