/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.x25519;

import com.exceptionfactory.jagged.bech32.Bech32;
import com.exceptionfactory.jagged.bech32.Bech32Address;
import com.exceptionfactory.jagged.framework.crypto.SharedSecretKey;
import com.exceptionfactory.jagged.x25519.BasePointPublicKey;
import com.exceptionfactory.jagged.x25519.IdentityIndicator;
import com.exceptionfactory.jagged.x25519.KeyAgreementFactory;
import com.exceptionfactory.jagged.x25519.RecipientIndicator;
import com.exceptionfactory.jagged.x25519.RecipientKeyFactory;
import com.exceptionfactory.jagged.x25519.X25519PublicKey;
import com.exceptionfactory.jagged.x25519.X25519SharedSecretKeyProducer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Objects;
import javax.crypto.spec.SecretKeySpec;

class X25519KeyFactorySpi
extends KeyFactorySpi {
    private static final Charset ENCODING_CHARACTER_SET = StandardCharsets.US_ASCII;
    private static final BasePointPublicKey BASE_POINT_PUBLIC_KEY = new BasePointPublicKey();
    private static final Bech32.Encoder ENCODER = Bech32.getEncoder();
    private static final Bech32.Decoder DECODER = Bech32.getDecoder();
    private final KeyAgreementFactory keyAgreementFactory;
    private final RecipientKeyFactory recipientKeyFactory;

    X25519KeyFactorySpi(KeyAgreementFactory keyAgreementFactory, RecipientKeyFactory recipientKeyFactory) {
        this.keyAgreementFactory = Objects.requireNonNull(keyAgreementFactory, "Key Agreement Factory required");
        this.recipientKeyFactory = Objects.requireNonNull(recipientKeyFactory, "Recipient Key Factory required");
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        throw new InvalidKeySpecException("Generate Public Key not supported");
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        throw new InvalidKeySpecException("Generate Private Key not supported");
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        throw new InvalidKeySpecException("Get Key Specification not supported");
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        Objects.requireNonNull(key, "Key required");
        if (key instanceof SecretKeySpec) {
            SecretKeySpec secretKeySpec = (SecretKeySpec)key;
            try {
                return this.getPublicKey(secretKeySpec);
            }
            catch (GeneralSecurityException e) {
                throw new InvalidKeyException("Secret Key conversion failed", e);
            }
        }
        String message = String.format("Key not supported [%s]", key.getClass());
        throw new InvalidKeyException(message);
    }

    private PublicKey getPublicKey(SecretKeySpec secretKeySpec) throws GeneralSecurityException {
        ByteBuffer encoded = ByteBuffer.wrap(secretKeySpec.getEncoded());
        CharBuffer characters = ENCODING_CHARACTER_SET.decode(encoded);
        Bech32Address address = DECODER.decode((CharSequence)characters);
        CharSequence humanReadablePart = address.getHumanReadablePart();
        if (IdentityIndicator.PRIVATE_KEY_HUMAN_READABLE_PART.getIndicator().contentEquals(humanReadablePart)) {
            byte[] privateKeyEncoded = address.getData();
            SharedSecretKey sharedSecretKey = this.getSharedSecretKey(privateKeyEncoded);
            return this.getPublicKey(sharedSecretKey);
        }
        String message = String.format("Private Key Human-Readable Part not matched [%s]", humanReadablePart);
        throw new InvalidKeySpecException(message);
    }

    private SharedSecretKey getSharedSecretKey(byte[] privateKeyEncoded) throws GeneralSecurityException {
        PrivateKey privateKey = this.recipientKeyFactory.getPrivateKey(privateKeyEncoded);
        X25519SharedSecretKeyProducer sharedSecretKeyProducer = new X25519SharedSecretKeyProducer(privateKey, this.keyAgreementFactory);
        PublicKey basePointPublicKey = this.recipientKeyFactory.getPublicKey(BASE_POINT_PUBLIC_KEY.getEncoded());
        return sharedSecretKeyProducer.getSharedSecretKey(basePointPublicKey);
    }

    private X25519PublicKey getPublicKey(SharedSecretKey sharedSecretKey) {
        byte[] coordinateEncoded = sharedSecretKey.getEncoded();
        CharSequence publicKeyEncoded = ENCODER.encode((CharSequence)RecipientIndicator.PUBLIC_KEY_HUMAN_READABLE_PART.getIndicator(), coordinateEncoded);
        byte[] encoded = this.getEncoded(publicKeyEncoded);
        return new X25519PublicKey(encoded);
    }

    private byte[] getEncoded(CharSequence keyEncoded) {
        CharBuffer keyBuffer = CharBuffer.wrap(keyEncoded);
        ByteBuffer buffer = ENCODING_CHARACTER_SET.encode(keyBuffer);
        return buffer.array();
    }
}

