/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.x25519;

import com.exceptionfactory.jagged.x25519.RecipientIndicator;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

class X25519PrivateKey
implements PrivateKey {
    private static final byte ZERO = 0;
    private final AtomicBoolean destroyed = new AtomicBoolean();
    private final byte[] encoded;

    X25519PrivateKey(byte[] encoded) {
        this.encoded = Objects.requireNonNull(encoded, "Encoded Key required");
    }

    @Override
    public String getAlgorithm() {
        return RecipientIndicator.KEY_ALGORITHM.getIndicator();
    }

    @Override
    public String getFormat() {
        return RecipientIndicator.KEY_INFORMATION.getIndicator();
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    public String toString() {
        return new String(this.encoded, StandardCharsets.US_ASCII);
    }

    @Override
    public void destroy() {
        Arrays.fill(this.encoded, (byte)0);
        this.destroyed.set(true);
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed.get();
    }
}

