/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.x25519;

import com.exceptionfactory.jagged.x25519.RecipientIndicator;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.util.Objects;

class X25519PublicKey
implements PublicKey {
    private final byte[] encoded;

    X25519PublicKey(byte[] encoded) {
        this.encoded = Objects.requireNonNull(encoded, "Encoded Key required");
    }

    @Override
    public String getAlgorithm() {
        return RecipientIndicator.KEY_ALGORITHM.getIndicator();
    }

    @Override
    public String getFormat() {
        return RecipientIndicator.KEY_INFORMATION.getIndicator();
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    public String toString() {
        return new String(this.encoded, StandardCharsets.US_ASCII);
    }
}

