/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.x25519;

import com.exceptionfactory.jagged.bech32.Bech32;
import com.exceptionfactory.jagged.x25519.IdentityIndicator;
import com.exceptionfactory.jagged.x25519.KeyPairGeneratorFactory;
import com.exceptionfactory.jagged.x25519.RecipientIndicator;
import com.exceptionfactory.jagged.x25519.RecipientKeyType;
import com.exceptionfactory.jagged.x25519.X25519PrivateKey;
import com.exceptionfactory.jagged.x25519.X25519PublicKey;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Objects;

public final class X25519KeyPairGenerator
extends KeyPairGenerator {
    private static final Charset ENCODING_CHARACTER_SET = StandardCharsets.US_ASCII;
    private static final String ALGORITHM = RecipientIndicator.KEY_ALGORITHM.getIndicator();
    private static final int PRIVATE_KEY_START_INDEX = 16;
    private static final int PRIVATE_KEY_END_INDEX = 48;
    private static final Bech32.Encoder ENCODER = Bech32.getEncoder();
    private final KeyPairGenerator keyPairGenerator;

    public X25519KeyPairGenerator() throws NoSuchAlgorithmException {
        super(ALGORITHM);
        KeyPairGeneratorFactory keyPairGeneratorFactory = new KeyPairGeneratorFactory();
        this.keyPairGenerator = keyPairGeneratorFactory.getKeyPairGenerator();
    }

    public X25519KeyPairGenerator(Provider provider) throws NoSuchAlgorithmException {
        super(ALGORITHM);
        Objects.requireNonNull(provider, "Provider required");
        KeyPairGeneratorFactory keyPairGeneratorFactory = new KeyPairGeneratorFactory(provider);
        this.keyPairGenerator = keyPairGeneratorFactory.getKeyPairGenerator();
    }

    @Override
    public KeyPair generateKeyPair() {
        KeyPair keyPair = this.keyPairGenerator.generateKeyPair();
        X25519PublicKey publicKey = this.getPublicKey(keyPair.getPublic());
        X25519PrivateKey privateKey = this.getPrivateKey(keyPair.getPrivate());
        return new KeyPair(publicKey, privateKey);
    }

    private X25519PublicKey getPublicKey(PublicKey publicKey) {
        byte[] coordinate = this.getPublicKeyCoordinate(publicKey);
        CharSequence publicKeyEncoded = ENCODER.encode((CharSequence)RecipientIndicator.PUBLIC_KEY_HUMAN_READABLE_PART.getIndicator(), coordinate);
        byte[] encoded = this.getEncoded(publicKeyEncoded);
        return new X25519PublicKey(encoded);
    }

    private X25519PrivateKey getPrivateKey(PrivateKey privateKey) {
        byte[] coordinate = this.getPrivateKeyCoordinate(privateKey);
        CharSequence privateKeyEncoded = ENCODER.encode((CharSequence)IdentityIndicator.PRIVATE_KEY_HUMAN_READABLE_PART.getIndicator(), coordinate);
        byte[] encoded = this.getEncoded(privateKeyEncoded);
        return new X25519PrivateKey(encoded);
    }

    private byte[] getEncoded(CharSequence keyEncoded) {
        CharBuffer keyBuffer = CharBuffer.wrap(keyEncoded);
        ByteBuffer buffer = ENCODING_CHARACTER_SET.encode(keyBuffer);
        return buffer.array();
    }

    private byte[] getPrivateKeyCoordinate(PrivateKey privateKey) {
        byte[] encoded = privateKey.getEncoded();
        return Arrays.copyOfRange(encoded, 16, 48);
    }

    private byte[] getPublicKeyCoordinate(PublicKey publicKey) {
        byte[] encoded = publicKey.getEncoded();
        int coordinateStartIndex = encoded.length - RecipientKeyType.X25519.getKeyLength();
        return Arrays.copyOfRange(encoded, coordinateStartIndex, encoded.length);
    }
}

