/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.x25519;

import com.exceptionfactory.jagged.FileKey;
import com.exceptionfactory.jagged.RecipientStanza;
import com.exceptionfactory.jagged.RecipientStanzaWriter;
import com.exceptionfactory.jagged.framework.codec.CanonicalBase64;
import com.exceptionfactory.jagged.framework.crypto.CipherKey;
import com.exceptionfactory.jagged.framework.crypto.EncryptedFileKey;
import com.exceptionfactory.jagged.framework.crypto.FileKeyEncryptor;
import com.exceptionfactory.jagged.framework.crypto.SharedSecretKey;
import com.exceptionfactory.jagged.x25519.BasePointPublicKey;
import com.exceptionfactory.jagged.x25519.KeyAgreementFactory;
import com.exceptionfactory.jagged.x25519.RecipientKeyFactory;
import com.exceptionfactory.jagged.x25519.RecipientKeyType;
import com.exceptionfactory.jagged.x25519.SharedSecretKeyProducer;
import com.exceptionfactory.jagged.x25519.SharedWrapKeyProducer;
import com.exceptionfactory.jagged.x25519.X25519RecipientStanza;
import com.exceptionfactory.jagged.x25519.X25519SharedSecretKeyProducer;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Objects;

class X25519RecipientStanzaWriter
implements RecipientStanzaWriter {
    private static final int EPHEMERAL_PRIVATE_KEY_LENGTH = RecipientKeyType.X25519.getKeyLength();
    private static final BasePointPublicKey BASE_POINT_PUBLIC_KEY = new BasePointPublicKey();
    private static final CanonicalBase64.Encoder ENCODER = CanonicalBase64.getEncoder();
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private final PublicKey recipientPublicKey;
    private final RecipientKeyFactory recipientKeyFactory;
    private final SharedWrapKeyProducer sharedWrapKeyProducer;
    private final FileKeyEncryptor fileKeyEncryptor;
    private final KeyAgreementFactory keyAgreementFactory;

    X25519RecipientStanzaWriter(PublicKey recipientPublicKey, RecipientKeyFactory recipientKeyFactory, SharedWrapKeyProducer sharedWrapKeyProducer, FileKeyEncryptor fileKeyEncryptor, KeyAgreementFactory keyAgreementFactory) {
        this.recipientPublicKey = Objects.requireNonNull(recipientPublicKey, "Recipient Public Key required");
        this.recipientKeyFactory = Objects.requireNonNull(recipientKeyFactory, "Recipient Key Factory required");
        this.sharedWrapKeyProducer = Objects.requireNonNull(sharedWrapKeyProducer, "Wrap Key Producer required");
        this.fileKeyEncryptor = Objects.requireNonNull(fileKeyEncryptor, "File Key Encryptor required");
        this.keyAgreementFactory = Objects.requireNonNull(keyAgreementFactory, "Key Agreement Factory required");
    }

    public Iterable<RecipientStanza> getRecipientStanzas(FileKey fileKey) throws GeneralSecurityException {
        Objects.requireNonNull(fileKey, "File Key required");
        SharedSecretKeyProducer sharedSecretKeyProducer = this.getSharedSecretKeyProducer();
        SharedSecretKey ephemeralSharedSecretKey = this.getEphemeralSharedSecretKey(sharedSecretKeyProducer);
        CipherKey wrapKey = this.getWrapKey(sharedSecretKeyProducer, ephemeralSharedSecretKey);
        EncryptedFileKey encryptedFileKey = this.fileKeyEncryptor.getEncryptedFileKey(fileKey, wrapKey);
        byte[] encryptedFileKeyEncoded = encryptedFileKey.getEncoded();
        String ephemeralShareEncoded = ENCODER.encodeToString(ephemeralSharedSecretKey.getEncoded());
        X25519RecipientStanza recipientStanza = new X25519RecipientStanza(ephemeralShareEncoded, encryptedFileKeyEncoded);
        return Collections.singletonList(recipientStanza);
    }

    private SharedSecretKeyProducer getSharedSecretKeyProducer() throws GeneralSecurityException {
        byte[] ephemeralPrivateKeyEncoded = this.getEphemeralPrivateKeyEncoded();
        PrivateKey ephemeralPrivateKey = this.recipientKeyFactory.getPrivateKey(ephemeralPrivateKeyEncoded);
        return new X25519SharedSecretKeyProducer(ephemeralPrivateKey, this.keyAgreementFactory);
    }

    private byte[] getEphemeralPrivateKeyEncoded() {
        byte[] ephemeralPrivateKeyEncoded = new byte[EPHEMERAL_PRIVATE_KEY_LENGTH];
        SECURE_RANDOM.nextBytes(ephemeralPrivateKeyEncoded);
        return ephemeralPrivateKeyEncoded;
    }

    private SharedSecretKey getEphemeralSharedSecretKey(SharedSecretKeyProducer sharedSecretKeyProducer) throws GeneralSecurityException {
        PublicKey basePointPublicKey = this.recipientKeyFactory.getPublicKey(BASE_POINT_PUBLIC_KEY.getEncoded());
        return sharedSecretKeyProducer.getSharedSecretKey(basePointPublicKey);
    }

    private CipherKey getWrapKey(SharedSecretKeyProducer sharedSecretKeyProducer, SharedSecretKey ephemeralSharedSecretKey) throws GeneralSecurityException {
        SharedSecretKey recipientSharedSecretKey = sharedSecretKeyProducer.getSharedSecretKey(this.recipientPublicKey);
        PublicKey ephemeralPublicKey = this.recipientKeyFactory.getPublicKey(ephemeralSharedSecretKey.getEncoded());
        return this.sharedWrapKeyProducer.getWrapKey(recipientSharedSecretKey, ephemeralPublicKey);
    }
}

