/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.x25519;

import com.exceptionfactory.jagged.RecipientStanzaWriter;
import com.exceptionfactory.jagged.bech32.Bech32;
import com.exceptionfactory.jagged.bech32.Bech32Address;
import com.exceptionfactory.jagged.framework.crypto.FileKeyEncryptor;
import com.exceptionfactory.jagged.framework.crypto.FileKeyEncryptorFactory;
import com.exceptionfactory.jagged.x25519.KeyAgreementFactory;
import com.exceptionfactory.jagged.x25519.KeyPairGeneratorFactory;
import com.exceptionfactory.jagged.x25519.RecipientIndicator;
import com.exceptionfactory.jagged.x25519.StandardRecipientKeyFactory;
import com.exceptionfactory.jagged.x25519.X25519RecipientStanzaWriter;
import com.exceptionfactory.jagged.x25519.X25519SharedWrapKeyProducer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.PublicKey;
import java.util.Objects;

public final class X25519RecipientStanzaWriterFactory {
    private X25519RecipientStanzaWriterFactory() {
    }

    public static RecipientStanzaWriter newRecipientStanzaWriter(CharSequence encodedPublicKey) throws GeneralSecurityException {
        FileKeyEncryptorFactory fileKeyEncryptorFactory = new FileKeyEncryptorFactory();
        KeyAgreementFactory keyAgreementFactory = new KeyAgreementFactory();
        KeyPairGeneratorFactory keyPairGeneratorFactory = new KeyPairGeneratorFactory();
        return X25519RecipientStanzaWriterFactory.newRecipientStanzaWriter(encodedPublicKey, fileKeyEncryptorFactory, keyAgreementFactory, keyPairGeneratorFactory);
    }

    public static RecipientStanzaWriter newRecipientStanzaWriter(CharSequence encodedPublicKey, Provider provider) throws GeneralSecurityException {
        Objects.requireNonNull(provider, "Provider required");
        FileKeyEncryptorFactory fileKeyEncryptorFactory = new FileKeyEncryptorFactory(provider);
        KeyAgreementFactory keyAgreementFactory = new KeyAgreementFactory(provider);
        KeyPairGeneratorFactory keyPairGeneratorFactory = new KeyPairGeneratorFactory(provider);
        return X25519RecipientStanzaWriterFactory.newRecipientStanzaWriter(encodedPublicKey, fileKeyEncryptorFactory, keyAgreementFactory, keyPairGeneratorFactory);
    }

    private static RecipientStanzaWriter newRecipientStanzaWriter(CharSequence encodedPublicKey, FileKeyEncryptorFactory fileKeyEncryptorFactory, KeyAgreementFactory keyAgreementFactory, KeyPairGeneratorFactory keyPairGeneratorFactory) throws GeneralSecurityException {
        Objects.requireNonNull(encodedPublicKey, "Encoded Public Key required");
        Bech32.Decoder decoder = Bech32.getDecoder();
        Bech32Address address = decoder.decode(encodedPublicKey);
        CharSequence humanReadablePart = address.getHumanReadablePart();
        if (RecipientIndicator.PUBLIC_KEY_HUMAN_READABLE_PART.getIndicator().contentEquals(humanReadablePart)) {
            byte[] publicKeyEncoded = address.getData();
            StandardRecipientKeyFactory recipientKeyFactory = new StandardRecipientKeyFactory(keyPairGeneratorFactory);
            PublicKey recipientPublicKey = recipientKeyFactory.getPublicKey(publicKeyEncoded);
            X25519SharedWrapKeyProducer sharedWrapKeyProducer = new X25519SharedWrapKeyProducer(recipientPublicKey);
            FileKeyEncryptor fileKeyEncryptor = fileKeyEncryptorFactory.newFileKeyEncryptor();
            return new X25519RecipientStanzaWriter(recipientPublicKey, recipientKeyFactory, sharedWrapKeyProducer, fileKeyEncryptor, keyAgreementFactory);
        }
        String message = String.format("Public Key Human-Readable Part not matched [%s]", humanReadablePart);
        throw new InvalidKeyException(message);
    }
}

