/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.x25519;

import com.exceptionfactory.jagged.FileKey;
import com.exceptionfactory.jagged.RecipientStanza;
import com.exceptionfactory.jagged.RecipientStanzaReader;
import com.exceptionfactory.jagged.UnsupportedRecipientStanzaException;
import com.exceptionfactory.jagged.framework.codec.CanonicalBase64;
import com.exceptionfactory.jagged.framework.crypto.CipherKey;
import com.exceptionfactory.jagged.framework.crypto.EncryptedFileKey;
import com.exceptionfactory.jagged.framework.crypto.FileKeyDecryptor;
import com.exceptionfactory.jagged.framework.crypto.SharedSecretKey;
import com.exceptionfactory.jagged.x25519.RecipientIndicator;
import com.exceptionfactory.jagged.x25519.RecipientKeyFactory;
import com.exceptionfactory.jagged.x25519.SharedSecretKeyProducer;
import com.exceptionfactory.jagged.x25519.SharedWrapKeyProducer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;

class X25519RecipientStanzaReader
implements RecipientStanzaReader {
    private static final int EPHEMERAL_SHARE_ENCODED_LENGTH = 43;
    private static final int ENCRYPTED_FILE_KEY_LENGTH = 32;
    private static final CanonicalBase64.Decoder BASE64_DECODER = CanonicalBase64.getDecoder();
    private final RecipientKeyFactory recipientKeyFactory;
    private final SharedSecretKeyProducer sharedSecretKeyProducer;
    private final SharedWrapKeyProducer sharedWrapKeyProducer;
    private final FileKeyDecryptor fileKeyDecryptor;

    X25519RecipientStanzaReader(RecipientKeyFactory recipientKeyFactory, SharedSecretKeyProducer sharedSecretKeyProducer, SharedWrapKeyProducer sharedWrapKeyProducer, FileKeyDecryptor fileKeyDecryptor) {
        this.recipientKeyFactory = Objects.requireNonNull(recipientKeyFactory, "Recipient Key Factory required");
        this.sharedSecretKeyProducer = Objects.requireNonNull(sharedSecretKeyProducer, "Shared Secret Key Provider required");
        this.sharedWrapKeyProducer = Objects.requireNonNull(sharedWrapKeyProducer, "Wrap Key Producer required");
        this.fileKeyDecryptor = Objects.requireNonNull(fileKeyDecryptor, "File Key Decryptor required");
    }

    public FileKey getFileKey(Iterable<RecipientStanza> recipientStanzas) throws GeneralSecurityException {
        Objects.requireNonNull(recipientStanzas, "Recipient Stanzas required");
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (RecipientStanza recipientStanza : recipientStanzas) {
            String recipientStanzaType = recipientStanza.getType();
            if (!RecipientIndicator.STANZA_TYPE.getIndicator().equals(recipientStanzaType)) continue;
            try {
                return this.getFileKey(recipientStanza);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (exceptions.isEmpty()) {
            throw new UnsupportedRecipientStanzaException(String.format("%s Recipient Stanzas not found", RecipientIndicator.STANZA_TYPE.getIndicator()));
        }
        String message = String.format("%s Recipient Stanza not matched", RecipientIndicator.STANZA_TYPE.getIndicator());
        UnsupportedRecipientStanzaException exception = new UnsupportedRecipientStanzaException(message);
        exceptions.forEach(arg_0 -> exception.addSuppressed(arg_0));
        throw exception;
    }

    private FileKey getFileKey(RecipientStanza recipientStanza) throws GeneralSecurityException {
        Iterator<String> recipientStanzaArguments = recipientStanza.getArguments().iterator();
        byte[] ephemeralShare = this.getEphemeralShare(recipientStanzaArguments);
        PublicKey ephemeralPublicKey = this.recipientKeyFactory.getPublicKey(ephemeralShare);
        SharedSecretKey sharedSecretKey = this.sharedSecretKeyProducer.getSharedSecretKey(ephemeralPublicKey);
        CipherKey wrapKey = this.sharedWrapKeyProducer.getWrapKey(sharedSecretKey, ephemeralPublicKey);
        byte[] encryptedFileKeyEncoded = recipientStanza.getBody();
        int encryptedFileKeyLength = encryptedFileKeyEncoded.length;
        if (encryptedFileKeyLength == 32) {
            EncryptedFileKey encryptedFileKey = new EncryptedFileKey(encryptedFileKeyEncoded);
            return this.fileKeyDecryptor.getFileKey(encryptedFileKey, wrapKey);
        }
        String message = String.format("Recipient Stanza Body length [%d] not required length [%d]", encryptedFileKeyLength, 32);
        throw new UnsupportedRecipientStanzaException(message);
    }

    private byte[] getEphemeralShare(Iterator<String> recipientStanzaArguments) throws UnsupportedRecipientStanzaException {
        if (recipientStanzaArguments.hasNext()) {
            String ephemeralShareEncoded = recipientStanzaArguments.next();
            if (recipientStanzaArguments.hasNext()) {
                String message = String.format("%s Recipient Stanza extra argument not expected", RecipientIndicator.STANZA_TYPE.getIndicator());
                throw new UnsupportedRecipientStanzaException(message);
            }
            int encodedLength = ephemeralShareEncoded.length();
            if (43 == encodedLength) {
                byte[] ephemeralShareEncodedBytes = ephemeralShareEncoded.getBytes(StandardCharsets.US_ASCII);
                return BASE64_DECODER.decode(ephemeralShareEncodedBytes);
            }
            String message = String.format("%s ephemeral share length [%d] not expected", RecipientIndicator.STANZA_TYPE.getIndicator(), encodedLength);
            throw new UnsupportedRecipientStanzaException(message);
        }
        String message = String.format("%s ephemeral share argument not found", RecipientIndicator.STANZA_TYPE.getIndicator());
        throw new UnsupportedRecipientStanzaException(message);
    }
}

