/*
 * Decompiled with CFR 0.152.
 */
package com.exceptionfactory.jagged.x25519;

import com.exceptionfactory.jagged.framework.crypto.SharedSecretKey;
import com.exceptionfactory.jagged.x25519.KeyAgreementFactory;
import com.exceptionfactory.jagged.x25519.SharedSecretKeyProducer;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Objects;
import javax.crypto.KeyAgreement;

final class X25519SharedSecretKeyProducer
implements SharedSecretKeyProducer {
    private static final boolean LAST_PHASE = true;
    private final PrivateKey privateKey;
    private final KeyAgreementFactory keyAgreementFactory;

    X25519SharedSecretKeyProducer(PrivateKey privateKey, KeyAgreementFactory keyAgreementFactory) {
        this.privateKey = Objects.requireNonNull(privateKey, "Private Key required");
        this.keyAgreementFactory = Objects.requireNonNull(keyAgreementFactory, "Key Agreement Factory required");
    }

    @Override
    public SharedSecretKey getSharedSecretKey(PublicKey publicKey) throws GeneralSecurityException {
        Objects.requireNonNull(publicKey, "Public Key required");
        KeyAgreement keyAgreement = this.keyAgreementFactory.getInitializedKeyAgreement(this.privateKey);
        keyAgreement.doPhase(publicKey, true);
        byte[] secretKey = keyAgreement.generateSecret();
        return new SharedSecretKey(secretKey);
    }
}

