/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.base;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractBaseChart {
    public void setLine(int num, Document doc) throws DocumentException {
        for (int i = 0; i < num; ++i) {
            doc.add((Element)new Paragraph(" "));
        }
    }

    public void setLine(int num, float fontSize, Document doc) throws DocumentException {
        Font font = new Font(Font.FontFamily.COURIER, fontSize);
        for (int i = 0; i < num; ++i) {
            doc.add((Element)new Paragraph(" ", font));
        }
    }

    public void addCell(PdfPTable table, BaseFont pFont, float fontSize, int fontStyle, int fontColor, String str, BaseColor backgroundColor, int num, float height, boolean ... hasBorder) {
        PdfPCell pdfPCell = new PdfPCell((Phrase)new Paragraph(str, new Font(pFont, fontSize, fontStyle, new BaseColor(fontColor))));
        pdfPCell.setHorizontalAlignment(1);
        pdfPCell.setVerticalAlignment(5);
        pdfPCell.setBackgroundColor(backgroundColor);
        pdfPCell.setFixedHeight(height);
        if (hasBorder.length > 0 && !hasBorder[0]) {
            pdfPCell.setBorderWidth(0.0f);
        }
        pdfPCell.setRowspan(num);
        table.addCell(pdfPCell);
    }

    public void addCell(PdfPTable table, Font pFont, String str, BaseColor backgroundColor, int num, float height, boolean ... hasBorder) {
        PdfPCell pdfPCell = new PdfPCell((Phrase)new Paragraph(str, pFont));
        pdfPCell.setHorizontalAlignment(1);
        pdfPCell.setVerticalAlignment(5);
        pdfPCell.setBackgroundColor(backgroundColor);
        pdfPCell.setFixedHeight(height);
        if (hasBorder.length > 0 && !hasBorder[0]) {
            pdfPCell.setBorderWidth(0.0f);
        }
        pdfPCell.setRowspan(num);
        table.addCell(pdfPCell);
    }

    public void addBorderColorCell(PdfPTable table, Font pFont, String str, BaseColor backgroundColor, int num, float height, Integer align, boolean ... hasBorder) {
        PdfPCell pdfPCell = new PdfPCell((Phrase)new Paragraph(str, pFont));
        pdfPCell.setHorizontalAlignment(ObjectUtils.equals(null, (Object)align) ? 1 : align);
        pdfPCell.setVerticalAlignment(5);
        pdfPCell.setBackgroundColor(backgroundColor);
        pdfPCell.setFixedHeight(height);
        if (hasBorder.length > 0 && !hasBorder[0]) {
            pdfPCell.setBorderColor(backgroundColor);
        }
        pdfPCell.setRowspan(num);
        table.addCell(pdfPCell);
    }

    public PdfPCell addCell(Font pFont, String str, float height, float borderWidth, BaseColor backColor) {
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(str, pFont));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setBackgroundColor(backColor);
        cell.setPaddingTop(6.0f);
        cell.setPaddingBottom(6.0f);
        cell.setFixedHeight(height);
        cell.setBorderColor(BaseColor.BLACK);
        cell.setBorderWidth(borderWidth);
        return cell;
    }

    public void moveText(PdfContentByte cb, String text, float x1, float y1, int align, float rotation) {
        cb.beginText();
        cb.showTextAligned(align, text, x1, y1, rotation);
        cb.endText();
    }

    public void moveLine(PdfContentByte cb, float x1, float y1, float x2, float y2) {
        cb.moveTo(x1, y1);
        cb.lineTo(x2, y2);
        cb.stroke();
    }

    public void moveRect(PdfContentByte cb, float x1, float y1, float x2, float y2, int color, boolean ... hasBorder) {
        Rectangle rect = new Rectangle(x1, y1, x2, y2);
        if (hasBorder.length > 1 && hasBorder[0]) {
            rect.setBorder(1);
        }
        rect.setBackgroundColor(new BaseColor(color));
        cb.rectangle(rect);
    }

    public void moveRoundRect(PdfContentByte cb, float x, float y, float w, float h, boolean ... isFill) {
        cb.roundRectangle(x, y, w, h, h / 2.0f);
        if (isFill.length < 1 || isFill[0]) {
            cb.fillStroke();
        } else {
            cb.stroke();
        }
    }

    public void moveRoundRect(PdfContentByte cb, float x, float y, float w, float h, float radian, boolean ... isFill) {
        cb.roundRectangle(x, y, w, h, radian);
        if (isFill.length < 1 || isFill[0]) {
            cb.fillStroke();
        } else {
            cb.stroke();
        }
    }

    public void moveCircle(PdfContentByte cb, float x1, float y1, float r, boolean ... isFill) {
        cb.circle(x1, y1, r);
        if (isFill.length < 1 || isFill[0]) {
            cb.fillStroke();
        } else {
            cb.stroke();
        }
    }

    public float calTextWidth(float fontSize, String text) {
        float width = 0.0f;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            if (text.charAt(i) < '\u00ff') {
                width += fontSize / 2.0f;
                continue;
            }
            width += fontSize;
        }
        return width;
    }

    public void moveMultiLineText(PdfContentByte cb, String text, float fontSize, float width, float lineHeight, float x, float y, int rotation) {
        float textTotalWidth = this.calTextWidth(fontSize, text);
        int lines = (int)Math.ceil(textTotalWidth / width);
        int everyLength = text.length() / lines;
        String textTemp = null;
        float x0 = 0.0f;
        float y0 = y - (lineHeight - (float)lines * fontSize) / 2.0f - fontSize * 4.3f / 5.0f;
        for (int i = 0; i < lines; ++i) {
            textTemp = text.substring(i * everyLength, i != lines - 1 ? (i + 1) * everyLength : text.length());
            x0 = x + (width - this.calTextWidth(fontSize, textTemp)) / 2.0f;
            this.moveText(cb, textTemp, x0, y0, 0, rotation);
            y0 -= fontSize;
        }
    }

    public float calRealHeight(String text, float fontSize, float width, float lineHeight) {
        int everyLength = (int)(width / fontSize);
        int lines = (int)Math.ceil(text.length() / everyLength);
        lines = text.length() % everyLength == 0 ? lines : lines + 1;
        return (float)lines * fontSize + lineHeight;
    }

    public void moveMultiLineWText(PdfContentByte cb, String text, float fontSize, float width, float lineHeight, float x, float y, int rotation) {
        int everyLength = (int)(width / fontSize);
        int lines = (int)Math.ceil(text.length() / everyLength);
        lines = text.length() % everyLength == 0 ? lines : lines + 1;
        String textTemp = null;
        float x0 = 0.0f;
        float y0 = y - (lineHeight - (float)lines * fontSize) / 2.0f - fontSize * 4.3f / 5.0f;
        for (int i = 0; i < lines; ++i) {
            textTemp = text.substring(i * everyLength, i != lines - 1 ? (i + 1) * everyLength : text.length());
            x0 = x + (width - this.calTextWidth(fontSize, textTemp)) / 2.0f;
            this.moveText(cb, textTemp, x0, y0, 0, rotation);
            y0 -= fontSize;
        }
    }
}

