/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.base.unit;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.base.AbstractBaseChart;
import com.xianghy.itextpdf.tools.base.AbstractBaseUnitChart;
import com.xianghy.itextpdf.tools.base.TPoint;

public class ArrowGraph
extends AbstractBaseUnitChart {
    public static final int ARROW_UP = 1;
    public static final int ARROW_DOWN = 2;
    public static final int ARROW_RIGHT = 3;
    public static final int ARROW_LEFT = 4;
    private float height = 15.0f;
    private float width = 5.0f;
    private float arrowWidth = 5.0f;
    private int color;
    private int arrowDirection = 3;
    private float x;
    private float y;

    public ArrowGraph(AbstractBaseChart baseChart, PdfWriter writer, PdfContentByte contentByte, Document document) {
        super(baseChart, writer, contentByte, document);
    }

    public ArrowGraph(PdfWriter writer, PdfContentByte contentByte, Document document) {
        super(writer, contentByte, document);
    }

    @Override
    public void chart() {
        TPoint onePoint = new TPoint();
        TPoint anotherPoint = new TPoint();
        TPoint topPoint = new TPoint();
        switch (this.arrowDirection) {
            case 1: {
                onePoint.setX(this.x);
                onePoint.setY(this.y + this.width);
                anotherPoint.setX(this.x + this.height);
                anotherPoint.setY(this.y + this.width);
                topPoint.setX(this.x + this.height / 2.0f);
                topPoint.setY(this.y + this.width + this.arrowWidth);
                break;
            }
            case 2: {
                onePoint.setX(this.x);
                onePoint.setY(this.y - this.width);
                anotherPoint.setX(this.x + this.height);
                anotherPoint.setY(this.y - this.width);
                topPoint.setX(this.x + this.height / 2.0f);
                topPoint.setY(this.y - this.width - this.arrowWidth);
                break;
            }
            case 3: {
                onePoint.setX(this.x + this.width);
                onePoint.setY(this.y);
                anotherPoint.setX(this.x + this.width);
                anotherPoint.setY(this.y - this.height);
                topPoint.setX(this.x + this.width + this.arrowWidth);
                topPoint.setY(this.y - this.height / 2.0f);
                break;
            }
            case 4: {
                onePoint.setX(this.x - this.width);
                onePoint.setY(this.y);
                anotherPoint.setX(this.x - this.width);
                anotherPoint.setY(this.y - this.height);
                topPoint.setX(this.x - this.width - this.arrowWidth);
                topPoint.setY(this.y - this.height / 2.0f);
                break;
            }
        }
        this.getBaseChart().moveRect(this.contentByte, this.x, this.y, anotherPoint.getX(), anotherPoint.getY(), this.color, new boolean[0]);
        this.contentByte.setColorStroke(new BaseColor(this.color));
        float x0 = onePoint.getX();
        float y0 = onePoint.getY();
        while (true) {
            switch (this.arrowDirection) {
                case 1: 
                case 2: {
                    x0 += 0.1f;
                    break;
                }
                case 3: 
                case 4: {
                    y0 -= 0.1f;
                    break;
                }
            }
            if (x0 > anotherPoint.getX() || y0 < anotherPoint.getY()) break;
            this.getBaseChart().moveLine(this.contentByte, x0, y0, topPoint.getX(), topPoint.getY());
        }
    }

    public ArrowGraph setHeight(float height) {
        this.height = height;
        return this;
    }

    public ArrowGraph setWidth(float width) {
        this.width = width;
        return this;
    }

    public ArrowGraph setArrowWidth(float arrowWidth) {
        this.arrowWidth = arrowWidth;
        return this;
    }

    public ArrowGraph setX(float x) {
        this.x = x;
        return this;
    }

    public ArrowGraph setY(float y) {
        this.y = y;
        return this;
    }

    public ArrowGraph setColor(int color) {
        this.color = color;
        return this;
    }

    public ArrowGraph setArrowDirection(int arrowDirection) {
        this.arrowDirection = arrowDirection;
        return this;
    }
}

