/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.base.unit;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.base.AbstractBaseChart;
import com.xianghy.itextpdf.tools.base.AbstractBaseUnitChart;
import com.xianghy.itextpdf.tools.base.TPoint;
import org.apache.commons.lang3.ObjectUtils;

public class BalloonGraph
extends AbstractBaseUnitChart {
    private float ballR = 10.0f;
    private float x;
    private float y;
    private float lineHeight = 20.0f;
    private float lineWidth = 1.5f;
    private BaseColor color;
    private float balloonBorder = 2.0f;
    private float areaHeight = 8.0f;

    public BalloonGraph(AbstractBaseChart baseChart, PdfWriter writer, PdfContentByte contentByte, Document document) {
        super(baseChart, writer, contentByte, document);
    }

    public BalloonGraph(PdfWriter writer, PdfContentByte contentByte, Document document) {
        super(writer, contentByte, document);
    }

    @Override
    public void chart() {
        if (ObjectUtils.equals(null, (Object)this.color)) {
            this.color = new BaseColor(93348);
        }
        this.contentByte.setColorStroke(this.color);
        this.contentByte.setLineWidth(this.lineWidth);
        this.getBaseChart().moveLine(this.contentByte, this.x, this.y, this.x, this.y + this.lineHeight);
        TPoint leftPoint = new TPoint();
        TPoint rightPoint = new TPoint();
        leftPoint.setX(this.x - this.ballR);
        leftPoint.setY(this.y + this.lineHeight + this.ballR + this.areaHeight);
        rightPoint.setX(this.x + this.ballR);
        rightPoint.setY(this.y + this.lineHeight + this.ballR + this.areaHeight);
        this.getBaseChart().moveLine(this.contentByte, leftPoint.getX(), leftPoint.getY(), rightPoint.getX(), rightPoint.getY());
        for (float i = leftPoint.getX(); i <= rightPoint.getX(); i += 0.5f) {
            this.getBaseChart().moveLine(this.contentByte, i, leftPoint.getY(), this.x, this.y + this.lineHeight);
        }
        this.drawBalloon(this.x, this.y + this.lineHeight + this.ballR + this.areaHeight);
    }

    private void drawBalloon(float x1, float y1) {
        int i;
        float space;
        int sideNum = 720;
        float spaceSize = space = 360.0f / (float)sideNum;
        float x0 = 0.0f;
        float y0 = 0.0f;
        float max = 180.0f;
        this.contentByte.setColorStroke(this.color);
        float r = this.ballR;
        float minR = this.ballR - 1.5f;
        float sep = (this.ballR - minR) / 180.0f;
        boolean isAdd = true;
        for (i = 0; i < sideNum; ++i) {
            if (isAdd && r + sep > this.ballR) {
                isAdd = false;
            } else if (!isAdd && r - sep < minR) {
                isAdd = true;
            }
            r = isAdd ? r + sep : r - sep;
            x0 = x1 + (float)((double)r * Math.sin(Math.PI * (double)(space + 90.0f) / 180.0));
            y0 = y1 + (float)((double)r * Math.cos(Math.PI * (double)(space + 90.0f) / 180.0));
            this.getBaseChart().moveLine(this.contentByte, x1, y1, x0, y0);
            this.getBaseChart().moveLine(this.contentByte, this.x, this.y + this.lineHeight, x0, y0);
            space += spaceSize;
        }
        space = spaceSize;
        isAdd = true;
        this.contentByte.setColorStroke(BaseColor.WHITE);
        r = this.ballR - this.balloonBorder;
        minR = this.ballR - this.balloonBorder - 1.5f;
        for (i = 0; i < sideNum; ++i) {
            if (isAdd && r + sep > this.ballR - this.balloonBorder) {
                isAdd = false;
            } else if (!isAdd && r - sep < minR) {
                isAdd = true;
            }
            r = isAdd ? r + sep : r - sep;
            x0 = x1 + (float)((double)r * Math.sin(Math.PI * (double)(space + 90.0f) / 180.0));
            y0 = y1 + (float)((double)r * Math.cos(Math.PI * (double)(space + 90.0f) / 180.0));
            this.getBaseChart().moveLine(this.contentByte, x1, y1, x0, y0);
            space += spaceSize;
        }
    }

    public BalloonGraph setX(float x) {
        this.x = x;
        return this;
    }

    public BalloonGraph setBallR(float ballR) {
        this.ballR = ballR;
        return this;
    }

    public BalloonGraph setY(float y) {
        this.y = y;
        return this;
    }

    public BalloonGraph setLineHeight(float lineHeight) {
        this.lineHeight = lineHeight;
        return this;
    }

    public BalloonGraph setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public BalloonGraph setColor(BaseColor color) {
        this.color = color;
        return this;
    }

    public BalloonGraph setBalloonBorder(float balloonBorder) {
        this.balloonBorder = balloonBorder;
        return this;
    }

    public BalloonGraph setAreaHeight(float areaHeight) {
        this.areaHeight = areaHeight;
        return this;
    }
}

