/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.base.unit;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.base.AbstractBaseChart;
import com.xianghy.itextpdf.tools.base.AbstractBaseUnitChart;

public class CurveHasRadianGraph
extends AbstractBaseUnitChart {
    private float x;
    private float y;
    private float x0;
    private float y0;
    private int color;
    private boolean hasCircle = true;
    private float lineWidth = 1.0f;

    public CurveHasRadianGraph(AbstractBaseChart baseChart, PdfWriter writer, PdfContentByte contentByte, Document document) {
        super(baseChart, writer, contentByte, document);
    }

    public CurveHasRadianGraph(PdfWriter writer, PdfContentByte contentByte, Document document) {
        super(writer, contentByte, document);
    }

    @Override
    public void chart() {
        float defaultY = 30.0f;
        float defaultX = 59.0f;
        float subX = 170.0f;
        float nowX = defaultY / Math.abs(this.y - this.y0) * defaultX;
        float nowSubX = Math.abs(this.x - this.x0) * defaultX / subX;
        nowX = Math.abs(this.x - this.x0) > subX ? nowX : nowSubX;
        this.contentByte.setColorStroke(new BaseColor(this.color));
        this.contentByte.setLineDash(1.0f, this.lineWidth);
        this.contentByte.moveTo(this.x, this.y);
        this.contentByte.curveTo(this.x + nowX, this.y, this.x0 - nowX, this.y0, this.x0, this.y0);
        this.contentByte.stroke();
        if (this.hasCircle) {
            this.contentByte.setColorFill(BaseColor.WHITE);
            this.getBaseChart().moveCircle(this.contentByte, this.x, this.y, 2.0f, true);
            this.getBaseChart().moveCircle(this.contentByte, this.x0, this.y0, 2.0f, true);
            this.contentByte.setLineDash(this.lineWidth);
            this.contentByte.circle(this.x, this.y, 2.0f);
            this.contentByte.circle(this.x0, this.y0, 2.0f);
            this.contentByte.stroke();
        }
    }

    public CurveHasRadianGraph setX(float x) {
        this.x = x;
        return this;
    }

    public CurveHasRadianGraph setY(float y) {
        this.y = y;
        return this;
    }

    public CurveHasRadianGraph setX0(float x0) {
        this.x0 = x0;
        return this;
    }

    public CurveHasRadianGraph setY0(float y0) {
        this.y0 = y0;
        return this;
    }

    public CurveHasRadianGraph setColor(int color) {
        this.color = color;
        return this;
    }

    public CurveHasRadianGraph setHasCircle(boolean hasCircle) {
        this.hasCircle = hasCircle;
        return this;
    }

    public CurveHasRadianGraph setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }
}

