/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.base.unit;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.base.AbstractBaseChart;
import com.xianghy.itextpdf.tools.base.AbstractBaseUnitChart;
import com.xianghy.itextpdf.tools.base.TPoint;
import java.util.ArrayList;
import org.apache.commons.lang3.ObjectUtils;

public class FiveTopStarGraph
extends AbstractBaseUnitChart {
    private float x;
    private float y;
    private float r = 6.0f;
    private BaseColor color = BaseColor.BLACK;
    private float rotation;
    private boolean isFillColor;

    public FiveTopStarGraph(AbstractBaseChart baseChart, PdfWriter writer, PdfContentByte contentByte, Document document) {
        super(baseChart, writer, contentByte, document);
    }

    public FiveTopStarGraph(PdfWriter writer, PdfContentByte contentByte, Document document) {
        super(writer, contentByte, document);
    }

    @Override
    public void chart() {
        int i;
        float spaceSize;
        float space = spaceSize = 72.0f;
        float x0 = 0.0f;
        float y0 = 0.0f;
        float nextX = 0.0f;
        float nextY = 0.0f;
        float max = 90.0f;
        this.contentByte.setLineWidth(0.5f);
        ArrayList<TPoint> points = null;
        TPoint point = null;
        float offset = 0.376f;
        for (i = 0; i <= 5; ++i) {
            this.contentByte.setColorStroke(this.color);
            x0 = this.x + (float)((double)this.r * Math.sin(Math.PI * (double)(space - spaceSize + this.rotation) / 90.0));
            y0 = this.y + (float)((double)this.r * Math.cos(Math.PI * (double)(space - spaceSize + this.rotation) / 90.0));
            nextX = this.x + (float)((double)this.r * Math.sin(Math.PI * (double)(space + this.rotation) / 90.0));
            nextY = this.y + (float)((double)this.r * Math.cos(Math.PI * (double)(space + this.rotation) / 90.0));
            if (i != 0) {
                this.getBaseChart().moveLine(this.contentByte, x0, y0, nextX, nextY);
            }
            if (this.isFillColor && i > 0) {
                if (i == 5) {
                    space = spaceSize;
                }
                float j = 0.0f;
                while (j < this.r) {
                    nextX = this.x + (float)((double)j * Math.sin(Math.PI * (double)(space + this.rotation) / 90.0));
                    nextY = this.y + (float)((double)j * Math.cos(Math.PI * (double)(space + this.rotation) / 90.0));
                    this.getBaseChart().moveLine(this.contentByte, x0, y0, nextX, nextY);
                    j = (float)((double)j + 0.1);
                }
            } else if (!this.isFillColor) {
                if (ObjectUtils.equals(null, (Object)points)) {
                    points = new ArrayList<TPoint>();
                }
                point = new TPoint();
                point.setX(this.x + (float)((double)(this.r * 0.376f) * Math.sin(Math.PI * (double)(space - spaceSize + 18.0f) / 90.0)));
                point.setY(this.y + (float)((double)(this.r * 0.376f) * Math.cos(Math.PI * (double)(space - spaceSize + 18.0f) / 90.0)));
                switch (i) {
                    case 0: 
                    case 1: 
                    case 2: {
                        points.add(i, point);
                        break;
                    }
                    case 3: {
                        points.add(1, point);
                        break;
                    }
                    case 4: {
                        points.add(3, point);
                        break;
                    }
                }
            }
            space += spaceSize;
        }
        if (points != null) {
            this.contentByte.setLineWidth(2.0f);
            this.contentByte.setColorStroke(BaseColor.WHITE);
            for (i = 0; i < points.size(); ++i) {
                if (i < points.size() - 1) {
                    this.getBaseChart().moveLine(this.contentByte, ((TPoint)points.get(i)).getX(), ((TPoint)points.get(i)).getY(), ((TPoint)points.get(i + 1)).getX(), ((TPoint)points.get(i + 1)).getY());
                    continue;
                }
                this.getBaseChart().moveLine(this.contentByte, ((TPoint)points.get(i)).getX(), ((TPoint)points.get(i)).getY(), ((TPoint)points.get(0)).getX(), ((TPoint)points.get(0)).getY());
            }
        }
    }

    public FiveTopStarGraph setFillColor(boolean isFillColor) {
        this.isFillColor = isFillColor;
        return this;
    }

    public FiveTopStarGraph setX(float x) {
        this.x = x;
        return this;
    }

    public FiveTopStarGraph setY(float y) {
        this.y = y;
        return this;
    }

    public FiveTopStarGraph setR(float r) {
        this.r = r;
        return this;
    }

    public FiveTopStarGraph setColor(BaseColor color) {
        this.color = color;
        return this;
    }

    public FiveTopStarGraph setRotation(float rotation) {
        this.rotation = rotation;
        return this;
    }
}

