/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.base.unit;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.base.AbstractBaseChart;
import com.xianghy.itextpdf.tools.base.AbstractBaseUnitChart;
import com.xianghy.itextpdf.tools.base.TPoint;
import java.util.LinkedList;

public class FourTopQuadrilateralGraph
extends AbstractBaseUnitChart {
    private float first_x;
    private float first_y;
    private float second_x;
    private float second_y;
    private float third_x;
    private float third_y;
    private float fourth_x;
    private float fourth_y;
    private int color;
    private boolean isFillColor = true;

    public FourTopQuadrilateralGraph(AbstractBaseChart baseChart, PdfWriter writer, PdfContentByte contentByte, Document document) {
        super(baseChart, writer, contentByte, document);
    }

    public FourTopQuadrilateralGraph(PdfWriter writer, PdfContentByte contentByte, Document document) {
        super(writer, contentByte, document);
    }

    @Override
    public void chart() {
        BaseColor color_ = new BaseColor(this.color);
        this.contentByte.setColorStroke(color_);
        if (!this.isFillColor) {
            this.getBaseChart().moveLine(this.contentByte, this.first_x, this.first_y, this.second_x, this.second_y);
            this.getBaseChart().moveLine(this.contentByte, this.third_x, this.third_y, this.fourth_x, this.fourth_y);
            this.getBaseChart().moveLine(this.contentByte, this.first_x, this.first_y, this.fourth_x, this.fourth_y);
            this.getBaseChart().moveLine(this.contentByte, this.third_x, this.third_y, this.second_x, this.second_y);
            return;
        }
        double l1 = Math.sqrt((this.second_x - this.first_x) * (this.second_x - this.first_x) + (this.second_y - this.first_y) * (this.second_y - this.first_y));
        double l2 = Math.sqrt((this.third_x - this.fourth_x) * (this.third_x - this.fourth_x) + (this.third_y - this.fourth_y) * (this.third_y - this.fourth_y));
        LinkedList<TPoint> oneStack = new LinkedList<TPoint>();
        LinkedList<TPoint> anotherStack = new LinkedList<TPoint>();
        TPoint onePoint = new TPoint();
        if (l1 > l2) {
            onePoint.setX(this.first_x);
            onePoint.setY(this.first_y);
            oneStack.push(onePoint);
            onePoint = new TPoint();
            onePoint.setX(this.second_x);
            onePoint.setY(this.second_y);
            oneStack.push(onePoint);
            onePoint = new TPoint();
            onePoint.setX(this.fourth_x);
            onePoint.setY(this.fourth_y);
            anotherStack.push(onePoint);
            onePoint = new TPoint();
            onePoint.setX(this.third_x);
            onePoint.setY(this.third_y);
            anotherStack.push(onePoint);
        } else {
            onePoint.setX(this.first_x);
            onePoint.setY(this.first_y);
            anotherStack.push(onePoint);
            onePoint = new TPoint();
            onePoint.setX(this.second_x);
            onePoint.setY(this.second_y);
            anotherStack.push(onePoint);
            onePoint = new TPoint();
            onePoint.setX(this.fourth_x);
            onePoint.setY(this.fourth_y);
            oneStack.push(onePoint);
            onePoint = new TPoint();
            onePoint.setX(this.third_x);
            onePoint.setY(this.third_y);
            oneStack.push(onePoint);
        }
        TPoint centerPoint = null;
        TPoint anotherPoint = null;
        TPoint oneCenterPoint = null;
        while (!oneStack.isEmpty()) {
            centerPoint = new TPoint();
            anotherPoint = (TPoint)oneStack.pop();
            onePoint = (TPoint)oneStack.peek();
            centerPoint.setX((anotherPoint.getX() + onePoint.getX()) / 2.0f);
            centerPoint.setY((anotherPoint.getY() + onePoint.getY()) / 2.0f);
            if (Math.round(centerPoint.getX() * 10.0f) == Math.round(onePoint.getX() * 10.0f) && Math.round(centerPoint.getY() * 10.0f) == Math.round(onePoint.getY() * 10.0f) || Math.round(centerPoint.getX() * 10.0f) == Math.round(anotherPoint.getX() * 10.0f) && Math.round(centerPoint.getY() * 10.0f) == Math.round(anotherPoint.getY() * 10.0f)) {
                oneStack.pop();
                anotherStack.pop();
                anotherStack.pop();
                continue;
            }
            oneStack.push(centerPoint);
            oneStack.push(anotherPoint);
            oneStack.push(centerPoint);
            oneCenterPoint = new TPoint();
            anotherPoint = (TPoint)anotherStack.pop();
            onePoint = (TPoint)anotherStack.peek();
            oneCenterPoint.setX((anotherPoint.getX() + onePoint.getX()) / 2.0f);
            oneCenterPoint.setY((anotherPoint.getY() + onePoint.getY()) / 2.0f);
            anotherStack.push(oneCenterPoint);
            anotherStack.push(anotherPoint);
            anotherStack.push(oneCenterPoint);
            this.getBaseChart().moveLine(this.contentByte, oneCenterPoint.getX(), oneCenterPoint.getY(), centerPoint.getX(), centerPoint.getY());
        }
    }

    public FourTopQuadrilateralGraph setFirst_x(float first_x) {
        this.first_x = first_x;
        return this;
    }

    public FourTopQuadrilateralGraph setFirst_y(float first_y) {
        this.first_y = first_y;
        return this;
    }

    public FourTopQuadrilateralGraph setSecond_x(float second_x) {
        this.second_x = second_x;
        return this;
    }

    public FourTopQuadrilateralGraph setSecond_y(float second_y) {
        this.second_y = second_y;
        return this;
    }

    public FourTopQuadrilateralGraph setThird_x(float third_x) {
        this.third_x = third_x;
        return this;
    }

    public FourTopQuadrilateralGraph setThird_y(float third_y) {
        this.third_y = third_y;
        return this;
    }

    public FourTopQuadrilateralGraph setFourth_x(float fourth_x) {
        this.fourth_x = fourth_x;
        return this;
    }

    public FourTopQuadrilateralGraph setFourth_y(float fourth_y) {
        this.fourth_y = fourth_y;
        return this;
    }

    public FourTopQuadrilateralGraph setColor(int color) {
        this.color = color;
        return this;
    }

    public FourTopQuadrilateralGraph setFillColor(boolean isFillColor) {
        this.isFillColor = isFillColor;
        return this;
    }
}

