/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.base.unit;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.base.AbstractBaseChart;
import com.xianghy.itextpdf.tools.base.AbstractBaseUnitChart;

public class PolygonGraph
extends AbstractBaseUnitChart {
    private float x;
    private float y;
    private float r = 7.0f;
    private int sideNum = 3;
    private float rotation;
    private BaseColor fillColor;

    public PolygonGraph(AbstractBaseChart baseChart, PdfWriter writer, PdfContentByte cb, Document doc) {
        super(baseChart, writer, cb, doc);
    }

    public PolygonGraph(PdfWriter writer, PdfContentByte cb, Document doc) {
        super(writer, cb, doc);
    }

    @Override
    public void chart() {
        float spaceSize;
        float space = spaceSize = 360.0f / (float)this.sideNum;
        float x0 = 0.0f;
        float y0 = 0.0f;
        float nextX = 0.0f;
        float nextY = 0.0f;
        float max = 180.0f;
        for (int i = 0; i <= this.sideNum; ++i) {
            x0 = this.x + (float)((double)this.r * Math.sin(Math.PI * (double)(space - spaceSize + this.rotation) / 180.0));
            y0 = this.y + (float)((double)this.r * Math.cos(Math.PI * (double)(space - spaceSize + this.rotation) / 180.0));
            nextX = this.x + (float)((double)this.r * Math.sin(Math.PI * (double)(space + this.rotation) / 180.0));
            nextY = this.y + (float)((double)this.r * Math.cos(Math.PI * (double)(space + this.rotation) / 180.0));
            if (i != 0) {
                this.getBaseChart().moveLine(this.contentByte, x0, y0, nextX, nextY);
            }
            if (this.fillColor != null && i > 0) {
                this.contentByte.setColorStroke(this.fillColor);
                this.contentByte.setColorFill(this.fillColor);
                if (i == this.sideNum) {
                    space = spaceSize;
                }
                float j = 0.0f;
                while (j < this.r) {
                    nextX = this.x + (float)((double)j * Math.sin(Math.PI * (double)(space + this.rotation) / 180.0));
                    nextY = this.y + (float)((double)j * Math.cos(Math.PI * (double)(space + this.rotation) / 180.0));
                    this.getBaseChart().moveLine(this.contentByte, x0, y0, nextX, nextY);
                    j = (float)((double)j + 0.1);
                }
            } else {
                this.getBaseChart().moveLine(this.contentByte, this.x, this.y, nextX, nextY);
            }
            space += spaceSize;
        }
    }

    public PolygonGraph setX(float x) {
        this.x = x;
        return this;
    }

    public PolygonGraph setY(float y) {
        this.y = y;
        return this;
    }

    public PolygonGraph setR(float r) {
        this.r = r;
        return this;
    }

    public PolygonGraph setSideNum(int sideNum) {
        this.sideNum = sideNum;
        return this;
    }

    public PolygonGraph setRotation(float rotation) {
        this.rotation = rotation;
        return this;
    }

    public PolygonGraph setFillColor(BaseColor fillColor) {
        this.fillColor = fillColor;
        return this;
    }
}

