/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.base.unit;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.base.AbstractBaseChart;
import com.xianghy.itextpdf.tools.base.AbstractBaseUnitChart;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class RectangleLineThroughGraph
extends AbstractBaseUnitChart {
    public static final int LINE_THROUGH_X = 1;
    public static final int LINE_THROUGH_Y = 2;
    private float height = 15.0f;
    private float width = 30.0f;
    private int color = 6149040;
    private float fontSize = 9.0f;
    private int fontColor = 0xFFFFFF;
    private String text;
    private int lineThrough = 1;
    private float lineThroughLength = 30.0f;
    private float lineThroughWidth = 2.0f;
    private float x;
    private float y;
    private boolean hasLineThrough = true;

    public RectangleLineThroughGraph(AbstractBaseChart baseChart, PdfWriter writer, PdfContentByte contentByte, Document document) {
        super(baseChart, writer, contentByte, document);
    }

    public RectangleLineThroughGraph(PdfWriter writer, PdfContentByte contentByte, Document document) {
        super(writer, contentByte, document);
    }

    @Override
    public void chart() {
        if (ObjectUtils.equals(null, (Object)this.baseFont)) {
            throw new RuntimeException("\u8bf7\u786e\u4fddbaseFont\u88ab\u6dfb\u52a0\uff01");
        }
        BaseColor color_ = new BaseColor(this.color);
        BaseColor fontColor_ = new BaseColor(this.fontColor);
        this.contentByte.setLineWidth(this.lineThroughWidth);
        this.contentByte.setColorFill(color_);
        this.contentByte.setColorStroke(color_);
        this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
        switch (this.lineThrough) {
            case 1: {
                if (this.hasLineThrough) {
                    this.getBaseChart().moveLine(this.contentByte, this.x - this.lineThroughLength / 2.0f, this.y + this.height / 2.0f, this.x + this.width + this.lineThroughLength / 2.0f, this.y + this.height / 2.0f);
                }
                this.getBaseChart().moveRoundRect(this.contentByte, this.x, this.y, this.width, this.height, 2.0f, true);
                this.contentByte.setColorFill(fontColor_);
                this.getBaseChart().moveMultiLineText(this.contentByte, StringUtils.defaultString((String)this.text, (String)" "), this.fontSize, this.width, this.height, this.x, this.y + this.height, 0);
                break;
            }
            case 2: {
                if (this.hasLineThrough) {
                    this.getBaseChart().moveLine(this.contentByte, this.x + this.height / 2.0f, this.y + this.width + this.lineThroughLength / 2.0f, this.x + this.height / 2.0f, this.y - this.lineThroughLength / 2.0f);
                }
                this.getBaseChart().moveRoundRect(this.contentByte, this.x, this.y, this.height, this.width, 2.0f, true);
                this.contentByte.setColorFill(fontColor_);
                this.getBaseChart().moveMultiLineText(this.contentByte, StringUtils.defaultString((String)this.text, (String)" "), this.fontSize, this.fontSize + 0.5f, this.width, this.x + (this.height - this.fontSize - 0.5f) / 2.0f, this.y + this.width, 0);
                break;
            }
        }
    }

    public RectangleLineThroughGraph setHeight(float height) {
        this.height = height;
        return this;
    }

    public RectangleLineThroughGraph setWidth(float width) {
        this.width = width;
        return this;
    }

    public RectangleLineThroughGraph setX(float x) {
        this.x = x;
        return this;
    }

    public RectangleLineThroughGraph setY(float y) {
        this.y = y;
        return this;
    }

    public RectangleLineThroughGraph setColor(int color) {
        this.color = color;
        return this;
    }

    public RectangleLineThroughGraph setLineThrough(int lineThrough) {
        this.lineThrough = lineThrough;
        return this;
    }

    public RectangleLineThroughGraph setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public RectangleLineThroughGraph setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public RectangleLineThroughGraph setText(String text) {
        this.text = text;
        return this;
    }

    public RectangleLineThroughGraph setLineThroughLength(float lineThroughLength) {
        this.lineThroughLength = lineThroughLength;
        return this;
    }

    public RectangleLineThroughGraph setLineThroughWidth(float lineThroughWidth) {
        this.lineThroughWidth = lineThroughWidth;
        return this;
    }

    public RectangleLineThroughGraph setHasLineThrough(boolean hasLineThrough) {
        this.hasLineThrough = hasLineThrough;
        return this;
    }
}

