/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.base.unit;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.base.AbstractBaseChart;
import com.xianghy.itextpdf.tools.base.AbstractBaseUnitChart;
import com.xianghy.itextpdf.tools.base.TPoint;
import java.util.LinkedList;

public class ThreeTopTriangleGraph
extends AbstractBaseUnitChart {
    private float top_x;
    private float top_y;
    private float left_x;
    private float left_y;
    private float right_x;
    private float right_y;
    private int color;
    private boolean isFillColor = true;

    public ThreeTopTriangleGraph(AbstractBaseChart baseChart, PdfWriter writer, PdfContentByte contentByte, Document document) {
        super(baseChart, writer, contentByte, document);
    }

    public ThreeTopTriangleGraph(PdfWriter writer, PdfContentByte contentByte, Document document) {
        super(writer, contentByte, document);
    }

    @Override
    public void chart() {
        BaseColor color_ = new BaseColor(this.color);
        this.contentByte.setColorStroke(color_);
        if (!this.isFillColor) {
            this.getBaseChart().moveLine(this.contentByte, this.top_x, this.top_y, this.right_x, this.right_y);
            this.getBaseChart().moveLine(this.contentByte, this.top_x, this.top_y, this.left_x, this.left_y);
            this.getBaseChart().moveLine(this.contentByte, this.right_x, this.right_y, this.left_x, this.left_y);
            return;
        }
        LinkedList<TPoint> stack = new LinkedList<TPoint>();
        TPoint onePoint = new TPoint();
        onePoint.setX(this.left_x);
        onePoint.setY(this.left_y);
        stack.push(onePoint);
        onePoint = new TPoint();
        onePoint.setX(this.right_x);
        onePoint.setY(this.right_y);
        stack.push(onePoint);
        TPoint centerPoint = null;
        TPoint anotherPoint = null;
        while (!stack.isEmpty()) {
            centerPoint = new TPoint();
            anotherPoint = (TPoint)stack.pop();
            onePoint = (TPoint)stack.peek();
            centerPoint.setX((anotherPoint.getX() + onePoint.getX()) / 2.0f);
            centerPoint.setY((anotherPoint.getY() + onePoint.getY()) / 2.0f);
            if (Math.round(centerPoint.getX() * 10.0f) == Math.round(onePoint.getX() * 10.0f) && Math.round(centerPoint.getY() * 10.0f) == Math.round(onePoint.getY() * 10.0f) || Math.round(centerPoint.getX() * 10.0f) == Math.round(anotherPoint.getX() * 10.0f) && Math.round(centerPoint.getY() * 10.0f) == Math.round(anotherPoint.getY() * 10.0f)) {
                stack.pop();
                continue;
            }
            this.getBaseChart().moveLine(this.contentByte, this.top_x, this.top_y, centerPoint.getX(), centerPoint.getY());
            stack.push(centerPoint);
            stack.push(anotherPoint);
            stack.push(centerPoint);
        }
    }

    public ThreeTopTriangleGraph setTop_x(float top_x) {
        this.top_x = top_x;
        return this;
    }

    public ThreeTopTriangleGraph setTop_y(float top_y) {
        this.top_y = top_y;
        return this;
    }

    public ThreeTopTriangleGraph setLeft_x(float left_x) {
        this.left_x = left_x;
        return this;
    }

    public ThreeTopTriangleGraph setLeft_y(float left_y) {
        this.left_y = left_y;
        return this;
    }

    public ThreeTopTriangleGraph setRight_x(float right_x) {
        this.right_x = right_x;
        return this;
    }

    public ThreeTopTriangleGraph setRight_y(float right_y) {
        this.right_y = right_y;
        return this;
    }

    public ThreeTopTriangleGraph setColor(int color) {
        this.color = color;
        return this;
    }

    public ThreeTopTriangleGraph setFillColor(boolean isFillColor) {
        this.isFillColor = isFillColor;
        return this;
    }
}

