/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.base.unit;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.base.AbstractBaseChart;
import com.xianghy.itextpdf.tools.base.AbstractBaseUnitChart;
import com.xianghy.itextpdf.tools.base.TPoint;

public class TwoTriangleGraph
extends AbstractBaseUnitChart {
    private float height = 10.0f;
    private float width = 10.0f;
    private float x;
    private float y;
    private BaseColor color = BaseColor.BLACK;

    public TwoTriangleGraph(AbstractBaseChart baseChart, PdfWriter writer, PdfContentByte contentByte, Document document) {
        super(baseChart, writer, contentByte, document);
    }

    public TwoTriangleGraph(PdfWriter writer, PdfContentByte contentByte, Document document) {
        super(writer, contentByte, document);
    }

    @Override
    public void chart() {
        TPoint leftLevel = new TPoint();
        leftLevel.setY(this.y - this.height / 2.0f);
        leftLevel.setX(this.x - this.width);
        TPoint rightLevel = new TPoint();
        rightLevel.setY(leftLevel.getY());
        rightLevel.setX(this.x);
        TPoint leftUp = new TPoint();
        leftUp.setY(this.y);
        leftUp.setX(this.x - 4.0f * this.width / 3.0f);
        TPoint leftDown = new TPoint();
        leftDown.setX(leftUp.getX());
        leftDown.setY(this.y - this.height);
        this.contentByte.setLineWidth(0.5f);
        this.contentByte.setColorStroke(this.color);
        this.getBaseChart().moveLine(this.contentByte, leftLevel.getX(), leftLevel.getY(), rightLevel.getX(), rightLevel.getY());
        this.getBaseChart().moveLine(this.contentByte, rightLevel.getX(), rightLevel.getY(), leftUp.getX(), leftUp.getY());
        this.getBaseChart().moveLine(this.contentByte, leftLevel.getX(), leftLevel.getY(), leftUp.getX(), leftUp.getY());
        this.getBaseChart().moveLine(this.contentByte, rightLevel.getX(), rightLevel.getY(), leftDown.getX(), leftDown.getY());
        this.getBaseChart().moveLine(this.contentByte, leftDown.getX(), leftDown.getY(), leftLevel.getX(), leftLevel.getY());
        for (float i = leftLevel.getX() + 0.5f; i < rightLevel.getX(); i += 0.5f) {
            this.getBaseChart().moveLine(this.contentByte, leftDown.getX(), leftDown.getY(), i, leftLevel.getY());
        }
    }

    public TwoTriangleGraph setHeight(float height) {
        this.height = height;
        return this;
    }

    public TwoTriangleGraph setWidth(float width) {
        this.width = width;
        return this;
    }

    public TwoTriangleGraph setX(float x) {
        this.x = x;
        return this;
    }

    public TwoTriangleGraph setY(float y) {
        this.y = y;
        return this;
    }

    public TwoTriangleGraph setColor(BaseColor color) {
        this.color = color;
        return this;
    }
}

