/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.chart;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;

public class HistogramAreaExtremumChart
extends AbstractChart {
    private float x;
    private float y;
    private float height = 200.0f;
    private float width = 450.0f;
    private float fontSize = 10.0f;
    private int[] levels;
    private String[] itemNames;
    private float[] scores;
    private int borderColor = 0xAAAAAA;
    private int fontColor = 0;
    private int[] extremumIndex;
    private String[] extremumNames;
    private int[] extremumColors;
    private int[] extremumAreaColors;
    private float positionY;
    private float showScoreAreaHeight = 30.0f;

    public HistogramAreaExtremumChart() {
    }

    public HistogramAreaExtremumChart(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        this.positionY = 0.0f;
        if (ObjectUtils.equals(null, (Object)this.itemNames) || this.itemNames.length < 1 || ObjectUtils.equals(null, (Object)this.scores) || this.scores.length < 1) {
            throw new RuntimeException("\u8bf7\u68c0\u6d4bitemNames\u3001scores\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (ObjectUtils.equals(null, (Object)this.levels)) {
            this.levels = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        }
        if (ObjectUtils.equals(null, (Object)this.extremumIndex)) {
            this.extremumIndex = new int[]{0, 2};
        }
        if (ObjectUtils.equals(null, (Object)this.extremumNames)) {
            this.extremumNames = new String[]{"\u6700\u9ad8", "\u6700\u4f4e"};
        }
        if (ObjectUtils.equals(null, (Object)this.extremumColors)) {
            this.extremumColors = new int[]{7523245, 0x7F7F7F, 14974292, 0x7F7F7F};
        }
        if (ObjectUtils.equals(null, (Object)this.extremumAreaColors)) {
            this.extremumAreaColors = new int[]{13101790, 0xFFFFFF, 16042939, 0xFFFFFF};
        }
        try {
            BaseColor borderColor_ = new BaseColor(this.borderColor);
            BaseColor fontColor_ = new BaseColor(this.fontColor);
            this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
            this.contentByte.setColorFill(fontColor_);
            this.drawEveryArea();
            this.drawFrame(borderColor_, fontColor_);
            this.drawScore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawScore() {
        float sepWidth = this.width / (float)this.itemNames.length;
        float kHeight = this.height / (float)(this.levels[this.levels.length - 1] - this.levels[0]);
        float x0 = this.x;
        float y0 = 0.0f;
        float offset = 10.0f;
        float textHeight = 0.0f;
        int index = 0;
        for (int i = 0; i < this.itemNames.length; ++i) {
            y0 = kHeight * (this.scores[i] - (float)this.levels[0]);
            this.contentByte.setColorFill(BaseColor.BLACK);
            this.moveRect(this.contentByte, x0 + sepWidth / 4.0f, this.y + 1.0f, x0 + sepWidth * 3.0f / 4.0f, this.y + y0, this.extremumColors[i], false);
            this.moveRect(this.contentByte, x0, this.y, x0 + sepWidth - 1.0f, this.y - this.showScoreAreaHeight, this.extremumColors[i], false);
            this.contentByte.setColorFill(BaseColor.WHITE);
            this.drawMulRowText(this.showScoreAreaHeight, sepWidth, this.scores[i] + "", x0, this.y);
            textHeight = (float)this.itemNames[i].length() * this.fontSize;
            textHeight = textHeight % sepWidth == 0.0f ? textHeight / sepWidth : 1.0f + textHeight / sepWidth;
            textHeight = textHeight > 1.0f ? textHeight * this.fontSize : this.showScoreAreaHeight;
            this.contentByte.setColorFill(BaseColor.BLACK);
            this.drawMulRowText(textHeight, sepWidth, this.itemNames[i], x0, this.y - this.showScoreAreaHeight);
            this.positionY = Math.max(this.positionY, textHeight + this.showScoreAreaHeight);
            if (ArrayUtils.contains((int[])this.extremumIndex, (int)i)) {
                textHeight = (float)this.extremumNames[index].length() * this.fontSize;
                textHeight = textHeight % (sepWidth / 2.0f) == 0.0f ? textHeight / (sepWidth / 2.0f) : 1.0f + textHeight / (sepWidth / 2.0f);
                offset = y0 <= 10.0f + textHeight ? y0 + (textHeight *= this.fontSize) + 2.0f : y0 - 10.0f;
                this.moveRect(this.contentByte, x0 + sepWidth / 4.0f + 1.0f, this.y + offset, x0 + sepWidth * 3.0f / 4.0f - 1.0f, this.y + offset - textHeight, BaseColor.WHITE.getRGB(), false);
                this.drawMulRowText(textHeight, sepWidth / 2.0f - 2.0f < this.fontSize ? this.fontSize : sepWidth / 2.0f - 2.0f, this.extremumNames[index++], x0 + sepWidth / 4.0f + 1.0f, this.y + offset);
            }
            x0 += sepWidth;
        }
    }

    private void drawEveryArea() {
        float sepWidth = this.width / (float)this.itemNames.length;
        float x0 = this.x;
        for (int i = 0; i < this.itemNames.length; ++i) {
            this.moveRect(this.contentByte, i == 0 ? x0 + 1.0f : x0, this.y + 1.0f, x0 + sepWidth - 1.0f, this.y + this.height, this.extremumAreaColors[i], false);
            x0 += sepWidth;
        }
    }

    private void drawMulRowText(float lineHeight, float witdh, String text, float x, float y) {
        this.moveMultiLineText(this.contentByte, text, this.fontSize, witdh, lineHeight, x, y, 0);
    }

    private void drawFrame(BaseColor borderColor, BaseColor fontColor) {
        this.contentByte.setColorStroke(borderColor);
        this.moveLine(this.contentByte, this.x, this.y, this.x, this.y + this.height);
        float x1 = this.x;
        float kHeight = this.height / (float)(this.levels[this.levels.length - 1] - this.levels[0]);
        float y1 = 0.0f;
        for (int i = 0; i < this.levels.length; ++i) {
            y1 = this.y + kHeight * (float)(this.levels[i] - this.levels[0]);
            this.contentByte.setColorStroke(borderColor);
            this.contentByte.setLineDash(1.0f);
            this.moveLine(this.contentByte, x1, y1, this.x - 2.0f, y1);
            this.contentByte.setColorFill(fontColor);
            this.moveText(this.contentByte, this.levels[i] + "", x1 - 6.0f, y1 - 3.0f, 2, 0.0f);
            if (i <= 0) continue;
            this.contentByte.setColorStroke(borderColor);
            this.contentByte.setLineDash(3.0f, 2.0f);
            this.moveLine(this.contentByte, x1, y1, x1 + this.width, y1);
        }
        this.moveText(this.contentByte, this.levels[this.levels.length - 1] + "", x1 - 6.0f, y1 - 3.0f, 2, 0.0f);
        float sepWidth = this.width / (float)this.itemNames.length;
        this.contentByte.setColorStroke(BaseColor.BLACK);
        float x2 = this.x + sepWidth;
        float y2 = this.y;
        for (int i = 0; i < this.itemNames.length - 1; ++i) {
            this.contentByte.setLineDash(1.0f);
            this.moveLine(this.contentByte, x2, y2, x2, y2 + this.height);
            x2 += sepWidth;
        }
    }

    public float getPositionY() {
        this.positionY = this.y - this.positionY - 10.0f;
        return this.positionY;
    }

    public HistogramAreaExtremumChart setX(float x) {
        this.x = x;
        return this;
    }

    public HistogramAreaExtremumChart setY(float y) {
        this.y = y;
        return this;
    }

    public HistogramAreaExtremumChart setHeight(float height) {
        this.height = height;
        return this;
    }

    public HistogramAreaExtremumChart setWidth(float width) {
        this.width = width;
        return this;
    }

    public HistogramAreaExtremumChart setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public HistogramAreaExtremumChart setLevels(int[] levels) {
        this.levels = levels;
        return this;
    }

    public HistogramAreaExtremumChart setItemNames(String[] itemNames) {
        this.itemNames = itemNames;
        return this;
    }

    public HistogramAreaExtremumChart setScores(float[] scores) {
        this.scores = scores;
        return this;
    }

    public HistogramAreaExtremumChart setExtremumIndex(int[] extremumIndex) {
        this.extremumIndex = extremumIndex;
        return this;
    }

    public HistogramAreaExtremumChart setExtremumNames(String[] extremumNames) {
        this.extremumNames = extremumNames;
        return this;
    }

    public HistogramAreaExtremumChart setExtremumColors(int[] extremumColors) {
        this.extremumColors = extremumColors;
        return this;
    }

    public HistogramAreaExtremumChart setExtremumAreaColors(int[] extremumAreaColors) {
        this.extremumAreaColors = extremumAreaColors;
        return this;
    }

    public HistogramAreaExtremumChart setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public HistogramAreaExtremumChart setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public HistogramAreaExtremumChart setShowScoreAreaHeight(float showScoreAreaHeight) {
        this.showScoreAreaHeight = showScoreAreaHeight;
        return this;
    }
}

