/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.chart;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import org.apache.commons.lang3.ObjectUtils;

public class HistogramCurveExtremumChart
extends AbstractChart {
    private float x;
    private float y;
    private float height = 120.0f;
    private float width = 450.0f;
    private float fontSize = 10.0f;
    private float[] levels;
    private String[] itemNames;
    private float[] maxScores;
    private float[] minScores;
    private float[] avgScores;
    private int[] areaBackgroundColors;
    private int[] histogramFillColors;
    private int jionLineColor = 8301263;
    private int fontColor = 0;
    private int borderColor = 0x868686;
    private int[] rowBackgroundColors;
    private float cellHeight = 20.0f;
    private float positionY;
    private int scoreDescWidth = 50;
    private String[] scoreDescNames;
    private int[] areaScoreColors;
    private int maxScoreIndex = 0;
    private int minScoreIndex = 1;
    private int avgScoreIndex = 2;

    public HistogramCurveExtremumChart setScoreDescWidth(int scoreDescWidth) {
        this.scoreDescWidth = scoreDescWidth;
        return this;
    }

    public HistogramCurveExtremumChart setScoreDescNames(String[] scoreDescNames) {
        this.scoreDescNames = scoreDescNames;
        return this;
    }

    public HistogramCurveExtremumChart setAreaScoreColors(int[] areaScoreColors) {
        this.areaScoreColors = areaScoreColors;
        return this;
    }

    public HistogramCurveExtremumChart() {
    }

    public HistogramCurveExtremumChart(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        this.positionY = 0.0f;
        if (ObjectUtils.equals(null, (Object)this.itemNames) || this.itemNames.length < 1 || ObjectUtils.equals(null, (Object)this.maxScores) || this.maxScores.length < 1 || ObjectUtils.equals(null, (Object)this.minScores) || this.minScores.length < 1 || ObjectUtils.equals(null, (Object)this.avgScores) || this.avgScores.length < 1) {
            throw new RuntimeException("\u8bf7\u68c0\u6d4bitemNames\u3001maxScores\u3001minScores\u3001avgScores\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (ObjectUtils.equals(null, (Object)this.levels)) {
            this.levels = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f};
        }
        if (ObjectUtils.equals(null, (Object)this.areaBackgroundColors)) {
            this.areaBackgroundColors = new int[]{14220748, 14611967, 15661023, 0xFFF5DD};
        }
        if (ObjectUtils.equals(null, (Object)this.histogramFillColors)) {
            this.histogramFillColors = new int[]{0x7F7F7F, 5885951, 11131233, 16764500};
        }
        if (ObjectUtils.equals(null, (Object)this.rowBackgroundColors)) {
            this.rowBackgroundColors = new int[]{14939631, 16442845, 14149108};
        }
        if (ObjectUtils.equals(null, (Object)this.areaScoreColors)) {
            this.areaScoreColors = new int[]{7523245, 14974292, 3767238};
        }
        if (ObjectUtils.equals(null, (Object)this.scoreDescNames)) {
            this.scoreDescNames = new String[]{"\u6700\u5927\u503c", "\u6700\u5c0f\u503c", "\u5e73\u5747\u503c"};
        }
        try {
            BaseColor fontColor_ = new BaseColor(this.fontColor);
            BaseColor borderColor_ = new BaseColor(this.borderColor);
            BaseColor jionLineColor_ = new BaseColor(this.jionLineColor);
            this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
            this.contentByte.setColorFill(fontColor_);
            this.drawEveryArea();
            this.drawFrame(borderColor_, fontColor_);
            this.drawTable(fontColor_, borderColor_);
            this.drawScore(jionLineColor_);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawScore(BaseColor jionLineColor) {
        float sepWidth = this.width / (float)this.itemNames.length;
        float kHeight = this.height / (this.levels[this.levels.length - 1] - this.levels[0]);
        float x0 = this.x + sepWidth / 4.0f;
        float minY = 0.0f;
        float maxY = 0.0f;
        float curY = 0.0f;
        float temY = 0.0f;
        float nextY = 0.0f;
        for (int i = 0; i < this.itemNames.length; ++i) {
            minY = (this.minScores[i] - this.levels[0]) * kHeight;
            maxY = (this.maxScores[i] - this.levels[0]) * kHeight;
            curY = (this.avgScores[i] - this.levels[0]) * kHeight;
            this.moveRect(this.contentByte, x0, this.y + minY, x0 + sepWidth / 2.0f, this.y + maxY, this.histogramFillColors[i], new boolean[0]);
            this.contentByte.setLineDash(1.0f);
            this.contentByte.setLineWidth(1.0f);
            this.contentByte.setColorStroke(BaseColor.WHITE);
            this.moveCircle(this.contentByte, x0 + sepWidth / 4.0f, this.y + curY, 2.0f, true);
            this.contentByte.setColorStroke(jionLineColor);
            this.contentByte.setLineWidth(2.0f);
            this.contentByte.circle(x0 + sepWidth / 4.0f, this.y + curY, 2.0f);
            this.contentByte.stroke();
            if (minY - this.fontSize - 1.0f >= 0.0f) {
                temY = this.y + minY - 1.0f;
                nextY = temY - this.fontSize;
            } else if (minY - this.fontSize - 1.0f < 0.0f && curY - 4.0f - this.fontSize >= 0.0f) {
                temY = this.y + curY - 4.0f;
                nextY = temY - this.fontSize;
            } else {
                nextY = this.y + curY + 4.0f;
                temY = nextY + this.fontSize;
            }
            this.moveRect(this.contentByte, x0 + 1.5f, temY, x0 + sepWidth / 2.0f - 1.5f, nextY, this.areaScoreColors[this.minScoreIndex], new boolean[0]);
            this.moveText(this.contentByte, this.minScores[i] + "", x0 + sepWidth / 4.0f, nextY + 1.0f, 1, 0.0f);
            if (temY >= this.y + curY + 4.0f) {
                nextY = temY + 1.5f;
                temY = nextY + this.fontSize;
            } else {
                nextY = this.y + curY + 3.0f;
                temY = nextY + this.fontSize;
            }
            this.moveRect(this.contentByte, x0 + 1.5f, temY, x0 + sepWidth / 2.0f - 1.5f, nextY, this.areaScoreColors[this.avgScoreIndex], new boolean[0]);
            this.moveText(this.contentByte, this.avgScores[i] + "", x0 + sepWidth / 4.0f, nextY + 1.0f, 1, 0.0f);
            if (temY >= this.y + maxY + 1.0f) {
                nextY = temY + 1.0f;
                temY = nextY + this.fontSize;
            } else {
                nextY = this.y + maxY + 1.0f;
                temY = nextY + this.fontSize;
            }
            this.moveRect(this.contentByte, x0 + 1.5f, temY, x0 + sepWidth / 2.0f - 1.5f, nextY, this.areaScoreColors[this.maxScoreIndex], new boolean[0]);
            this.moveText(this.contentByte, this.maxScores[i] + "", x0 + sepWidth / 4.0f, nextY + 1.0f, 1, 0.0f);
            if (i > 0) {
                this.contentByte.setLineDash(1.0f);
                this.contentByte.setLineWidth(2.0f);
                temY = (this.avgScores[i - 1] - this.levels[0]) * kHeight;
                this.moveLine(this.contentByte, x0 - sepWidth * 3.0f / 4.0f + 2.0f, this.y + temY, x0 + sepWidth / 4.0f - 2.0f, this.y + curY);
            }
            x0 += sepWidth;
        }
    }

    private void drawEveryArea() {
        float sepWidth = this.width / (float)this.itemNames.length;
        float x0 = this.x;
        for (int i = 0; i < this.itemNames.length; ++i) {
            this.moveRect(this.contentByte, i == 0 ? x0 + 1.0f : x0, this.y + 1.0f, x0 + sepWidth - 1.0f, this.y + this.height, this.areaBackgroundColors[i], false);
            x0 += sepWidth;
        }
    }

    private void drawMulRowText(float lineHeight, float witdh, String text, float x, float y) {
        this.moveMultiLineText(this.contentByte, text, this.fontSize, witdh, lineHeight, x, y, 0);
    }

    private float calTableHeadHeight(float width) {
        float sum = 0.0f;
        for (int i = 0; i < this.itemNames.length; ++i) {
            sum = Math.max(sum, (float)this.itemNames[i].length());
        }
        sum = sum * this.fontSize % width == 0.0f ? sum * this.fontSize / width : (float)(Math.floor(sum * this.fontSize / width) + 1.0);
        return (sum - 1.0f) * this.fontSize + this.cellHeight;
    }

    private void drawTable(BaseColor fontColor, BaseColor tabelBorderColor) {
        int i;
        float sepWidth = this.width / (float)this.itemNames.length;
        float temp = this.calTableHeadHeight(sepWidth);
        float x0 = this.x;
        float y0 = this.y - temp;
        for (i = 0; i < this.itemNames.length; ++i) {
            this.moveRect(this.contentByte, x0, this.y, x0 + sepWidth - 1.0f, y0 + 1.0f, this.histogramFillColors[i % this.histogramFillColors.length], new boolean[0]);
            this.contentByte.setColorFill(BaseColor.WHITE);
            this.drawMulRowText(temp - 1.0f, sepWidth, this.itemNames[i], x0, this.y);
            x0 += sepWidth;
        }
        x0 = this.x;
        for (i = 0; i < this.rowBackgroundColors.length; ++i) {
            for (int j = 0; j < this.avgScores.length; ++j) {
                this.moveRect(this.contentByte, x0, y0, x0 + sepWidth - 1.0f, y0 - this.cellHeight + 1.0f, this.rowBackgroundColors[i % 2], new boolean[0]);
                this.contentByte.setColorFill(fontColor);
                this.drawMulRowText(this.cellHeight - 1.0f, sepWidth, this.maxScores[j] + "", x0, y0);
                x0 += sepWidth;
            }
            x0 = this.x;
            this.moveRect(this.contentByte, x0 - 1.0f, y0, x0 - 1.0f - (float)this.scoreDescWidth, y0 - this.cellHeight + 1.0f, this.areaScoreColors[i], new boolean[0]);
            this.contentByte.setColorFill(BaseColor.WHITE);
            this.drawMulRowText(this.cellHeight, this.scoreDescWidth, this.scoreDescNames[i], x0 - 1.0f - (float)this.scoreDescWidth, y0);
            y0 -= this.cellHeight;
            this.positionY += this.cellHeight;
        }
    }

    private void drawFrame(BaseColor borderColor, BaseColor fontColor) {
        this.contentByte.setColorStroke(borderColor);
        this.moveLine(this.contentByte, this.x, this.y, this.x, this.y + this.height);
        float x1 = this.x;
        float kHeight = this.height / (this.levels[this.levels.length - 1] - this.levels[0]);
        float y1 = 0.0f;
        for (int i = 0; i < this.levels.length; ++i) {
            y1 = this.y + kHeight * (this.levels[i] - this.levels[0]);
            this.contentByte.setColorStroke(borderColor);
            this.contentByte.setLineDash(1.0f);
            this.moveLine(this.contentByte, x1, y1, this.x - 2.0f, y1);
            this.contentByte.setColorFill(fontColor);
            this.moveText(this.contentByte, this.levels[i] + "", x1 - 6.0f, y1 - 3.0f, 2, 0.0f);
            if (i <= 0) continue;
            this.contentByte.setColorStroke(borderColor);
            this.contentByte.setLineDash(2.0f, 3.0f, 3.0f);
            this.moveLine(this.contentByte, x1, y1, x1 + this.width, y1);
            this.contentByte.setLineDash(6.0f, 1.0f);
            this.moveLine(this.contentByte, x1, y1, x1 + this.width, y1);
        }
        this.moveText(this.contentByte, this.levels[this.levels.length - 1] + "", x1 - 6.0f, y1 - 3.0f, 2, 0.0f);
    }

    public HistogramCurveExtremumChart setX(float x) {
        this.x = x;
        return this;
    }

    public HistogramCurveExtremumChart setY(float y) {
        this.y = y;
        return this;
    }

    public HistogramCurveExtremumChart setHeight(float height) {
        this.height = height;
        return this;
    }

    public HistogramCurveExtremumChart setWidth(float width) {
        this.width = width;
        return this;
    }

    public HistogramCurveExtremumChart setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public HistogramCurveExtremumChart setLevels(float[] levels) {
        this.levels = levels;
        return this;
    }

    public HistogramCurveExtremumChart setItemNames(String[] itemNames) {
        this.itemNames = itemNames;
        return this;
    }

    public HistogramCurveExtremumChart setMaxScores(float[] maxScores) {
        this.maxScores = maxScores;
        return this;
    }

    public HistogramCurveExtremumChart setMinScores(float[] minScores) {
        this.minScores = minScores;
        return this;
    }

    public HistogramCurveExtremumChart setAvgScores(float[] avgScores) {
        this.avgScores = avgScores;
        return this;
    }

    public HistogramCurveExtremumChart setAreaBackgroundColors(int[] areaBackgroundColors) {
        this.areaBackgroundColors = areaBackgroundColors;
        return this;
    }

    public HistogramCurveExtremumChart setHistogramFillColors(int[] histogramFillColors) {
        this.histogramFillColors = histogramFillColors;
        return this;
    }

    public HistogramCurveExtremumChart setJionLineColor(int jionLineColor) {
        this.jionLineColor = jionLineColor;
        return this;
    }

    public HistogramCurveExtremumChart setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public HistogramCurveExtremumChart setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public HistogramCurveExtremumChart setRowBackgroundColors(int[] rowBackgroundColors) {
        this.rowBackgroundColors = rowBackgroundColors;
        return this;
    }

    public HistogramCurveExtremumChart setCellHeight(float cellHeight) {
        this.cellHeight = cellHeight;
        return this;
    }

    public HistogramCurveExtremumChart setMaxScoreIndex(int maxScoreIndex) {
        this.maxScoreIndex = maxScoreIndex;
        return this;
    }

    public HistogramCurveExtremumChart setMinScoreIndex(int minScoreIndex) {
        this.minScoreIndex = minScoreIndex;
        return this;
    }

    public HistogramCurveExtremumChart setAvgScoreIndex(int avgScoreIndex) {
        this.avgScoreIndex = avgScoreIndex;
        return this;
    }

    public float getPositionY() {
        this.positionY = this.y - this.height - this.positionY + 10.0f;
        return this.positionY;
    }
}

