/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.chart;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import java.text.DecimalFormat;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class HistogramGradeDistributionChart
extends AbstractChart {
    private float x;
    private float y;
    private float height = 120.0f;
    private float width = 330.0f;
    private float fontSize = 10.0f;
    private int[] levels;
    private String[] itemNames;
    private String[] gradeNames;
    private int[] gradeBackgroundColors;
    private int[] scoreBackgroundColors;
    private float[] scores;
    private int histogramBackgroundColor = 8950462;
    private int fontColor = 0;
    private int levelSepLineXColor = 0xBFBFBF;
    private int levelYBorderColor = 0xBFBFBF;
    private int levelBackgroundColor = 0xBFBFBF;
    private float positionY;
    private float cellHeight = 15.0f;
    private float frameLeftOffsetX = 120.0f;
    private float levelCellWidth = 30.0f;
    private int scale = 2;
    private float itemRightOffsetX = 10.0f;

    public HistogramGradeDistributionChart setScale(int scale) {
        this.scale = scale;
        return this;
    }

    public HistogramGradeDistributionChart setFrameLeftOffsetX(float frameLeftOffsetX) {
        this.frameLeftOffsetX = frameLeftOffsetX;
        return this;
    }

    public HistogramGradeDistributionChart setItemRightOffsetX(float itemRightOffsetX) {
        this.itemRightOffsetX = itemRightOffsetX;
        return this;
    }

    public HistogramGradeDistributionChart() {
    }

    public HistogramGradeDistributionChart(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        this.positionY = 0.0f;
        if (ObjectUtils.equals(null, (Object)this.itemNames) || this.itemNames.length < 1 || ObjectUtils.equals(null, (Object)this.scores) || this.scores.length < 1) {
            throw new RuntimeException("\u8bf7\u68c0\u6d4bitemNames\u3001scores\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (ObjectUtils.equals(null, (Object)this.levels)) {
            this.levels = new int[]{0, 30, 60, 90};
        }
        if (ObjectUtils.equals(null, (Object)this.gradeNames)) {
            this.gradeNames = new String[]{"\u5f31\u9700\u6c42", "\u4e2d\u7b49\u9700\u6c42", "\u5f3a\u9700\u6c42"};
        }
        if (ObjectUtils.equals(null, (Object)this.gradeBackgroundColors)) {
            this.gradeBackgroundColors = new int[]{10205138, 8950462, 8611491};
        }
        if (ObjectUtils.equals(null, (Object)this.scoreBackgroundColors)) {
            this.scoreBackgroundColors = new int[]{7233174, 16303968, 15099179, 7636014, 12024447};
        }
        try {
            BaseColor fontColor_ = new BaseColor(this.fontColor);
            BaseColor levelSepLineXColor_ = new BaseColor(this.levelSepLineXColor);
            BaseColor levelYBorderColor_ = new BaseColor(this.levelYBorderColor);
            this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
            this.drawFrame(levelYBorderColor_, fontColor_);
            this.drawScore(levelSepLineXColor_, fontColor_);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawFrame(BaseColor levelYBorderColor, BaseColor fontColor) throws Exception {
        float sepWidth = this.width / (float)this.gradeNames.length;
        float x0 = this.x + this.frameLeftOffsetX;
        float y0 = this.y + this.height;
        float headHeight = this.calTableHeadHeight(sepWidth);
        for (int i = 0; i < this.gradeNames.length; ++i) {
            this.moveRect(this.contentByte, x0, y0, x0 + sepWidth - 1.0f, y0 + headHeight, this.gradeBackgroundColors[i], new boolean[0]);
            this.contentByte.setColorFill(BaseColor.WHITE);
            this.drawMulRowText(headHeight, sepWidth, this.gradeNames[i], x0, y0 + headHeight);
            this.moveRect(this.contentByte, x0 - this.levelCellWidth / 2.0f, this.y - this.fontSize, x0 + this.levelCellWidth / 2.0f, this.y - this.fontSize * 2.0f - 3.0f, this.levelBackgroundColor, new boolean[0]);
            this.contentByte.setColorFill(fontColor);
            this.drawMulRowText(this.fontSize, this.levelCellWidth, this.levels[i] + "", x0 - this.levelCellWidth / 2.0f, this.y - this.fontSize - 1.5f);
            this.contentByte.setLineDash(2.0f, 3.0f);
            this.contentByte.setColorStroke(levelYBorderColor);
            this.moveLine(this.contentByte, x0, y0 + this.cellHeight, x0, this.y - this.fontSize);
            x0 += sepWidth;
        }
        this.moveRect(this.contentByte, x0 - this.levelCellWidth / 2.0f, this.y - this.fontSize, x0 + this.levelCellWidth / 2.0f, this.y - this.fontSize * 2.0f - 3.0f, this.levelBackgroundColor, new boolean[0]);
        this.contentByte.setColorFill(fontColor);
        this.drawMulRowText(this.fontSize, this.levelCellWidth, this.levels[this.levels.length - 1] + "", x0 - this.levelCellWidth / 2.0f, this.y - this.fontSize - 1.5f);
        this.contentByte.setLineDash(2.0f, 3.0f);
        this.contentByte.setColorStroke(levelYBorderColor);
        this.moveLine(this.contentByte, x0, y0 + this.cellHeight, x0, this.y - this.fontSize);
    }

    private void drawMulRowText(float lineHeight, float witdh, String text, float x, float y) {
        this.moveMultiLineText(this.contentByte, text, this.fontSize, witdh, lineHeight, x, y, 0);
    }

    private float calTableHeadHeight(float width) {
        float sum = 0.0f;
        for (int i = 0; i < this.gradeNames.length; ++i) {
            sum = Math.max(sum, (float)this.gradeNames[i].length());
        }
        sum = sum * this.fontSize % width == 0.0f ? sum * this.fontSize / width : (float)(Math.floor(sum * this.fontSize / width) + 1.0);
        return (sum - 1.0f) * this.fontSize + this.cellHeight;
    }

    private void drawScore(BaseColor levelSepLineXColor, BaseColor fontColor) throws Exception {
        DecimalFormat df = new DecimalFormat("0" + (this.scale == 0 ? "" : "." + StringUtils.repeat((String)"#", (int)this.scale)));
        float sepHeight = (this.height - this.cellHeight - this.fontSize / 2.0f) / (float)(this.itemNames.length - 1);
        float y0 = this.y + this.height - this.cellHeight;
        float x0 = this.x + this.frameLeftOffsetX;
        float kWidth = this.width / (float)(this.levels[this.levels.length - 1] - this.levels[0]);
        BaseColor[] scoreColors = new BaseColor[this.scoreBackgroundColors.length];
        for (int j = 0; j < scoreColors.length; ++j) {
            scoreColors[j] = new BaseColor(this.scoreBackgroundColors[j]);
        }
        this.contentByte.setColorStroke(levelSepLineXColor);
        this.contentByte.setLineDash(1.0f);
        for (int i = 0; i < this.itemNames.length; ++i) {
            this.moveLineCircle(x0 - this.itemRightOffsetX, y0, 3.0f, this.frameLeftOffsetX - 3.0f - this.itemRightOffsetX, scoreColors[i], levelSepLineXColor);
            this.contentByte.setColorFill(fontColor);
            this.moveText(this.contentByte, this.itemNames[i], x0 - this.itemRightOffsetX - 3.0f - this.fontSize, y0 + 3.0f, 2, 0.0f);
            this.contentByte.setColorStroke(levelSepLineXColor);
            this.moveLine(this.contentByte, x0, y0, x0 + this.width, y0);
            this.moveRect(this.contentByte, x0 + 1.0f, y0 + this.cellHeight / 2.0f, x0 + kWidth * (this.scores[i] - (float)this.levels[0]), y0 - this.cellHeight / 2.0f, this.histogramBackgroundColor, new boolean[0]);
            this.contentByte.setColorFill(fontColor);
            this.moveText(this.contentByte, df.format(this.scores[i]), x0 + kWidth * (this.scores[i] - (float)this.levels[0]) + this.fontSize, y0 - this.fontSize / 3.0f, 0, 0.0f);
            y0 -= sepHeight;
        }
    }

    private void moveLineCircle(float x, float y, float r, float width, BaseColor color, BaseColor lineColor) {
        this.contentByte.setColorStroke(color);
        this.contentByte.setColorFill(color);
        this.moveCircle(this.contentByte, x, y, r, new boolean[0]);
        this.contentByte.setColorStroke(lineColor);
        this.moveLine(this.contentByte, x - width, y, x - r, y);
    }

    public HistogramGradeDistributionChart setX(float x) {
        this.x = x;
        return this;
    }

    public HistogramGradeDistributionChart setY(float y) {
        this.y = y;
        return this;
    }

    public HistogramGradeDistributionChart setHeight(float height) {
        this.height = height;
        return this;
    }

    public HistogramGradeDistributionChart setWidth(float width) {
        this.width = width;
        return this;
    }

    public HistogramGradeDistributionChart setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public HistogramGradeDistributionChart setLevels(int[] levels) {
        this.levels = levels;
        return this;
    }

    public HistogramGradeDistributionChart setGradeNames(String[] gradeNames) {
        this.gradeNames = gradeNames;
        return this;
    }

    public HistogramGradeDistributionChart setScores(float[] scores) {
        this.scores = scores;
        return this;
    }

    public HistogramGradeDistributionChart setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public HistogramGradeDistributionChart setItemNames(String[] itemNames) {
        this.itemNames = itemNames;
        return this;
    }

    public HistogramGradeDistributionChart setGradeBackgroundColors(int[] gradeBackgroundColors) {
        this.gradeBackgroundColors = gradeBackgroundColors;
        return this;
    }

    public HistogramGradeDistributionChart setScoreBackgroundColors(int[] scoreBackgroundColors) {
        this.scoreBackgroundColors = scoreBackgroundColors;
        return this;
    }

    public HistogramGradeDistributionChart setHistogramBackgroundColor(int histogramBackgroundColor) {
        this.histogramBackgroundColor = histogramBackgroundColor;
        return this;
    }

    public HistogramGradeDistributionChart setLevelSepLineXColor(int levelSepLineXColor) {
        this.levelSepLineXColor = levelSepLineXColor;
        return this;
    }

    public HistogramGradeDistributionChart setLevelYBorderColor(int levelYBorderColor) {
        this.levelYBorderColor = levelYBorderColor;
        return this;
    }

    public HistogramGradeDistributionChart setLevelBackgroundColor(int levelBackgroundColor) {
        this.levelBackgroundColor = levelBackgroundColor;
        return this;
    }

    public HistogramGradeDistributionChart setCellHeight(float cellHeight) {
        this.cellHeight = cellHeight;
        return this;
    }

    public HistogramGradeDistributionChart setLevelCellWidth(float levelCellWidth) {
        this.levelCellWidth = levelCellWidth;
        return this;
    }

    public float getPositionY() {
        this.positionY = this.y - this.fontSize * 2.0f - 10.0f;
        return this.positionY;
    }
}

