/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.chart;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class HistogramManyHistogramChart
extends AbstractChart {
    private float x;
    private float y;
    private float height = 160.0f;
    private float width = 450.0f;
    private float fontSize = 10.0f;
    private int[] levels;
    private String[] itemNames;
    private int itemBackgroundColor = 3767238;
    private int frameBackgroundColor = 0xF2F2F2;
    private String[] typeNames;
    private int[] typeFillColors;
    private int[] rowColors;
    private List<float[]> scores;
    private int borderColor = 0x868686;
    private int fontColor = 0;
    private float positionY;
    private float cellHeight = 30.0f;
    private float typeWidth = 40.0f;
    private int tabelBorderColor = 0xD2D2D2;

    public HistogramManyHistogramChart() {
    }

    public HistogramManyHistogramChart(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        this.positionY = 0.0f;
        if (ObjectUtils.equals(null, (Object)this.itemNames) || this.itemNames.length < 1 || ObjectUtils.equals(null, this.scores) || this.scores.size() < 1 || ObjectUtils.equals(null, (Object)this.typeNames) || this.typeNames.length < 1) {
            throw new RuntimeException("\u8bf7\u68c0\u6d4bitemNames\u3001typeNames\u3001scores\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (ObjectUtils.equals(null, (Object)this.levels)) {
            this.levels = new int[]{0, 20, 40, 60, 80, 100};
        }
        if (ObjectUtils.equals(null, (Object)this.typeFillColors)) {
            this.typeFillColors = new int[]{7523245, 14974292};
        }
        if (ObjectUtils.equals(null, (Object)this.rowColors)) {
            this.rowColors = new int[]{0xFFFFFF, 0xF2F2F2};
        }
        try {
            BaseColor borderColor_ = new BaseColor(this.borderColor);
            BaseColor fontColor_ = new BaseColor(this.fontColor);
            BaseColor tabelBorderColor_ = new BaseColor(this.tabelBorderColor);
            this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
            this.contentByte.setColorFill(fontColor_);
            this.drawFrame(borderColor_, fontColor_);
            this.drawTable(fontColor_, tabelBorderColor_);
            this.drawScore(fontColor_, tabelBorderColor_);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private float calTableHeadHeight(float width) {
        float sum = 0.0f;
        for (int i = 0; i < this.itemNames.length; ++i) {
            sum = Math.max(sum, (float)this.itemNames[i].length());
        }
        sum = sum * this.fontSize % width == 0.0f ? sum * this.fontSize / width : (float)(Math.floor(sum * this.fontSize / width) + 1.0);
        return (sum - 1.0f) * this.fontSize + this.cellHeight;
    }

    private void drawScore(BaseColor fontColor, BaseColor tabelBorderColor) {
        float kHeight = this.height / (float)(this.levels[this.levels.length - 1] - this.levels[0]);
        float sepWidth = this.width / (float)this.itemNames.length;
        float y0 = 0.0f;
        float offset = sepWidth / (float)(this.typeNames.length + 2);
        float x0 = 0.0f;
        for (int i = 0; i < this.scores.size(); ++i) {
            x0 = this.x + offset * (float)(i + 1);
            for (int j = 0; j < this.scores.get(i).length; ++j) {
                y0 = kHeight * (this.scores.get(i)[j] - (float)this.levels[0]);
                this.moveRect(this.contentByte, x0, this.y + 1.0f, x0 + offset, this.y + y0, this.typeFillColors[i % this.typeNames.length], new boolean[0]);
                x0 += sepWidth;
            }
        }
    }

    private void drawTable(BaseColor fontColor, BaseColor tabelBorderColor) {
        int i;
        float sepWidth = this.width / (float)this.itemNames.length;
        float x0 = this.x;
        float temp = this.calTableHeadHeight(sepWidth);
        float y0 = this.y - temp;
        for (i = 0; i < this.itemNames.length; ++i) {
            this.moveRect(this.contentByte, x0, this.y, x0 + sepWidth - 1.0f, y0, this.itemBackgroundColor, new boolean[0]);
            this.contentByte.setColorFill(BaseColor.WHITE);
            this.drawMulRowText(temp, sepWidth, this.itemNames[i], x0, this.y);
            this.contentByte.setColorStroke(tabelBorderColor);
            this.contentByte.setLineDash(1.0f);
            this.moveLine(this.contentByte, x0, this.y, x0, y0);
            x0 += sepWidth;
        }
        this.positionY += temp;
        this.contentByte.setColorStroke(tabelBorderColor);
        this.contentByte.setLineDash(1.0f);
        this.moveLine(this.contentByte, x0, this.y, x0, y0);
        x0 = this.x;
        for (i = 0; i < this.scores.size(); ++i) {
            for (int j = 0; j < this.scores.get(i).length; ++j) {
                this.moveRect(this.contentByte, x0, y0, x0 + sepWidth - 1.0f, y0 - this.cellHeight, this.rowColors[i % 2], new boolean[0]);
                this.contentByte.setColorFill(fontColor);
                this.drawMulRowText(this.cellHeight, sepWidth, this.scores.get(i)[j] + "", x0, y0);
                this.contentByte.setColorStroke(tabelBorderColor);
                this.contentByte.setLineDash(1.0f);
                this.moveLine(this.contentByte, x0, y0, x0, y0 - this.cellHeight);
                x0 += sepWidth;
            }
            this.contentByte.setColorStroke(tabelBorderColor);
            this.contentByte.setLineDash(1.0f);
            this.moveLine(this.contentByte, x0, y0, x0, y0 - this.cellHeight);
            x0 = this.x;
            this.moveRect(this.contentByte, x0 - 1.0f, y0, x0 - 1.0f - this.typeWidth, y0 - this.cellHeight, this.rowColors[i % 2], new boolean[0]);
            temp = this.drawMulRowText(this.cellHeight, this.typeWidth - 5.0f, this.typeNames[i] + "", x0 + 5.0f - this.typeWidth, y0);
            this.moveRect(this.contentByte, temp - 2.0f, y0 - this.cellHeight / 2.0f + 2.5f, temp - 7.0f, y0 - this.cellHeight / 2.0f - 2.5f, this.typeFillColors[i % this.typeNames.length], new boolean[0]);
            this.contentByte.setColorStroke(tabelBorderColor);
            this.contentByte.setLineDash(1.0f);
            this.contentByte.rectangle(x0 - 1.0f - this.typeWidth, y0 - this.cellHeight, this.typeWidth, this.cellHeight);
            this.contentByte.stroke();
            y0 -= this.cellHeight;
            this.positionY += this.cellHeight;
        }
        this.contentByte.setColorStroke(tabelBorderColor);
        this.contentByte.setLineDash(1.0f);
        this.moveLine(this.contentByte, this.x, y0, this.x + this.width, y0);
    }

    private float drawMulRowText(float lineHeight, float witdh, String text, float x, float y) {
        this.moveMultiLineText(this.contentByte, text, this.fontSize, witdh, lineHeight, x, y, 0);
        return lineHeight;
    }

    private void drawFrame(BaseColor borderColor, BaseColor fontColor) {
        this.contentByte.setColorStroke(borderColor);
        this.moveLine(this.contentByte, this.x, this.y, this.x, this.y + this.height);
        this.moveRect(this.contentByte, this.x, this.y + 1.5f, this.x + this.width, this.y + this.height + 1.5f, this.frameBackgroundColor, new boolean[0]);
        float x1 = this.x;
        float kHeight = this.height / (float)(this.levels[this.levels.length - 1] - this.levels[0]);
        float y1 = 0.0f;
        for (int i = 0; i < this.levels.length; ++i) {
            y1 = this.y + kHeight * (float)(this.levels[i] - this.levels[0]);
            this.contentByte.setColorStroke(borderColor);
            this.contentByte.setLineDash(1.0f);
            this.moveLine(this.contentByte, x1, y1, this.x - 2.0f, y1);
            this.contentByte.setColorFill(fontColor);
            this.moveText(this.contentByte, this.levels[i] + "", x1 - 6.0f, y1 - 3.0f, 2, 0.0f);
            if (i <= 0) continue;
            this.contentByte.setColorStroke(borderColor);
            this.contentByte.setLineDash(3.0f, 2.0f);
            this.moveLine(this.contentByte, x1, y1, x1 + this.width, y1);
        }
        this.moveText(this.contentByte, this.levels[this.levels.length - 1] + "", x1 - 6.0f, y1 - 3.0f, 2, 0.0f);
    }

    public float getPositionY() {
        this.positionY = this.y - this.positionY - 10.0f;
        return this.positionY;
    }

    public HistogramManyHistogramChart setX(float x) {
        this.x = x;
        return this;
    }

    public HistogramManyHistogramChart setY(float y) {
        this.y = y;
        return this;
    }

    public HistogramManyHistogramChart setHeight(float height) {
        this.height = height;
        return this;
    }

    public HistogramManyHistogramChart setWidth(float width) {
        this.width = width;
        return this;
    }

    public HistogramManyHistogramChart setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public HistogramManyHistogramChart setLevels(int[] levels) {
        this.levels = levels;
        return this;
    }

    public HistogramManyHistogramChart setItemNames(String[] itemNames) {
        this.itemNames = itemNames;
        return this;
    }

    public HistogramManyHistogramChart setScores(List<float[]> scores) {
        this.scores = scores;
        return this;
    }

    public HistogramManyHistogramChart setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public HistogramManyHistogramChart setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public HistogramManyHistogramChart setItemBackgroundColor(int itemBackgroundColor) {
        this.itemBackgroundColor = itemBackgroundColor;
        return this;
    }

    public HistogramManyHistogramChart setFrameBackgroundColor(int frameBackgroundColor) {
        this.frameBackgroundColor = frameBackgroundColor;
        return this;
    }

    public HistogramManyHistogramChart setTypeNames(String[] typeNames) {
        this.typeNames = typeNames;
        return this;
    }

    public HistogramManyHistogramChart setTypeFillColors(int[] typeFillColors) {
        this.typeFillColors = typeFillColors;
        return this;
    }

    public HistogramManyHistogramChart setRowColors(int[] rowColors) {
        this.rowColors = rowColors;
        return this;
    }

    public HistogramManyHistogramChart setCellHeight(float cellHeight) {
        this.cellHeight = cellHeight;
        return this;
    }

    public HistogramManyHistogramChart setTypeWidth(float typeWidth) {
        this.typeWidth = typeWidth;
        return this;
    }
}

