/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.chart;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import org.apache.commons.lang3.ObjectUtils;

public class HistogramXOrYDirectionChart
extends AbstractChart {
    public static final int DIRECTION_X = 0;
    public static final int DIRECTION_Y = 1;
    private float x;
    private float y;
    private float height = 120.0f;
    private float width = 450.0f;
    private float fontSize = 10.0f;
    private int histogramDirection = 0;
    private int[] levels;
    private String[] itemNames;
    private float[] scores;
    private int[] itemColors;
    private int fontColor = 0;
    private int borderColor = 0;
    private float positionY;

    public HistogramXOrYDirectionChart() {
    }

    public HistogramXOrYDirectionChart(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        this.positionY = 0.0f;
        if (ObjectUtils.equals(null, (Object)this.itemNames) || this.itemNames.length < 1 || ObjectUtils.equals(null, (Object)this.scores) || this.scores.length < 1) {
            throw new RuntimeException("\u8bf7\u68c0\u6d4bitemNames\u3001scores\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (ObjectUtils.equals(null, (Object)this.levels)) {
            this.levels = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        }
        if (ObjectUtils.equals(null, (Object)this.itemColors)) {
            this.itemColors = new int[]{7523245, 14974292};
        }
        try {
            BaseColor fontColor_ = new BaseColor(this.fontColor);
            BaseColor borderColor_ = new BaseColor(this.borderColor);
            this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
            this.drawFrame(borderColor_, fontColor_);
            this.drawHistogram();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawHistogram() {
        switch (this.histogramDirection) {
            case 0: {
                float sepHeight = this.height / (float)this.itemNames.length;
                float kWidth = this.width / (float)(this.levels[this.levels.length - 1] - this.levels[0]);
                float y0 = this.y + sepHeight / 4.0f;
                float x0 = 0.0f;
                float textY = 0.0f;
                for (int i = 0; i < this.itemNames.length; ++i) {
                    x0 = kWidth * (this.scores[i] - (float)this.levels[0]);
                    textY = sepHeight > this.fontSize ? y0 + (sepHeight / 2.0f - this.fontSize) / 2.0f : y0 + sepHeight / 2.0f;
                    this.moveText(this.contentByte, this.itemNames[i], this.x - this.fontSize / 2.0f, textY, 2, 0.0f);
                    this.moveRect(this.contentByte, this.x + 1.0f, y0, this.x + x0, y0 + sepHeight / 2.0f, this.itemColors[i % this.itemNames.length], new boolean[0]);
                    this.moveText(this.contentByte, this.scores[i] + "", this.x + x0 + this.fontSize / 2.0f, textY, 0, 0.0f);
                    y0 += sepHeight;
                }
                break;
            }
            case 1: {
                float sepWidht = this.width / (float)this.itemNames.length;
                float kHeight = this.height / (float)(this.levels[this.levels.length - 1] - this.levels[0]);
                float x0 = this.x + sepWidht / 4.0f;
                float y0 = 0.0f;
                float textX = 0.0f;
                for (int i = 0; i < this.itemNames.length; ++i) {
                    y0 = kHeight * (this.scores[i] - (float)this.levels[0]);
                    textX = sepWidht > this.fontSize ? x0 + (sepWidht / 2.0f - this.fontSize * (float)this.itemNames[i].length()) / 2.0f : x0 + sepWidht / 2.0f;
                    this.moveText(this.contentByte, this.itemNames[i], textX, this.y - 14.0f, 0, 0.0f);
                    this.moveRect(this.contentByte, x0, this.y + 1.0f, x0 + sepWidht / 2.0f, this.y + y0, this.itemColors[i % this.itemNames.length], new boolean[0]);
                    this.moveText(this.contentByte, this.scores[i] + "", textX, this.y + y0 + this.fontSize / 2.0f, 0, 0.0f);
                    x0 += sepWidht;
                }
                break;
            }
        }
    }

    private void drawFrame(BaseColor borderColor, BaseColor fontColor) {
        this.contentByte.setColorStroke(borderColor);
        this.moveLine(this.contentByte, this.x, this.y, this.x, this.y + this.height);
        this.moveLine(this.contentByte, this.x, this.y, this.x + this.width, this.y);
        float lineLength = this.width;
        float noChangedParam = this.y;
        float changedParam = 0.0f;
        switch (this.histogramDirection) {
            case 0: {
                lineLength = this.width / (float)(this.levels[this.levels.length - 1] - this.levels[0]);
                noChangedParam = this.y;
                changedParam = this.x;
                break;
            }
            case 1: {
                lineLength = this.height / (float)(this.levels[this.levels.length - 1] - this.levels[0]);
                noChangedParam = this.x;
                changedParam = this.y;
                break;
            }
        }
        float tempParam = 0.0f;
        block8: for (int i = 0; i < this.levels.length; ++i) {
            tempParam = changedParam + lineLength * (float)(this.levels[i] - this.levels[0]);
            this.contentByte.setColorStroke(borderColor);
            this.contentByte.setLineDash(1.0f);
            switch (this.histogramDirection) {
                case 0: {
                    this.moveLine(this.contentByte, tempParam, noChangedParam, tempParam, noChangedParam + 3.0f);
                    this.contentByte.setColorFill(fontColor);
                    this.moveText(this.contentByte, this.levels[i] + "", tempParam + 3.0f, noChangedParam - 10.0f, 2, 0.0f);
                    continue block8;
                }
                case 1: {
                    this.moveLine(this.contentByte, noChangedParam, tempParam, noChangedParam - 3.0f, tempParam);
                    this.contentByte.setColorFill(fontColor);
                    this.moveText(this.contentByte, this.levels[i] + "", noChangedParam - 5.0f, tempParam - 3.0f, 2, 0.0f);
                    continue block8;
                }
            }
        }
    }

    public float getPositionY() {
        this.positionY = this.y - this.height - this.positionY + 10.0f;
        return this.positionY;
    }

    public HistogramXOrYDirectionChart setX(float x) {
        this.x = x;
        return this;
    }

    public HistogramXOrYDirectionChart setY(float y) {
        this.y = y;
        return this;
    }

    public HistogramXOrYDirectionChart setHeight(float height) {
        this.height = height;
        return this;
    }

    public HistogramXOrYDirectionChart setWidth(float width) {
        this.width = width;
        return this;
    }

    public HistogramXOrYDirectionChart setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public HistogramXOrYDirectionChart setLevels(int[] levels) {
        this.levels = levels;
        return this;
    }

    public HistogramXOrYDirectionChart setItemNames(String[] itemNames) {
        this.itemNames = itemNames;
        return this;
    }

    public HistogramXOrYDirectionChart setScores(float[] scores) {
        this.scores = scores;
        return this;
    }

    public HistogramXOrYDirectionChart setItemColors(int[] itemColors) {
        this.itemColors = itemColors;
        return this;
    }

    public HistogramXOrYDirectionChart setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public HistogramXOrYDirectionChart setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public HistogramXOrYDirectionChart setHistogramDirection(int histogramDirection) {
        this.histogramDirection = histogramDirection;
        return this;
    }
}

