/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.chart;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import org.apache.commons.lang3.ObjectUtils;

public class LineMulCurveLineAreaTableChart
extends AbstractChart {
    private float x;
    private float y;
    private float height = 120.0f;
    private float width = 450.0f;
    private float fontSize = 9.0f;
    private float[] levels;
    private String[] itemNames;
    private float[][] scores;
    private int tableBorderColor = 0xCFCFCF;
    private int[] areaBackgroundColors;
    private int[] tableHeadFillColors;
    private int[] jionLineColors;
    private int fontColor = 0;
    private int borderColor = 0x868686;
    private int[] rowColors;
    private float cellHeight = 20.0f;
    private float positionY;
    private int scoreDescWidth = 60;
    private String[] scoreDescNames;

    public LineMulCurveLineAreaTableChart setScoreDescWidth(int scoreDescWidth) {
        this.scoreDescWidth = scoreDescWidth;
        return this;
    }

    public LineMulCurveLineAreaTableChart setScoreDescNames(String[] scoreDescNames) {
        this.scoreDescNames = scoreDescNames;
        return this;
    }

    public LineMulCurveLineAreaTableChart() {
    }

    public LineMulCurveLineAreaTableChart(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        this.positionY = 0.0f;
        if (ObjectUtils.equals(null, (Object)this.itemNames) || this.itemNames.length < 1 || ObjectUtils.equals(null, (Object)this.scores) || this.scores.length < 1) {
            throw new RuntimeException("\u8bf7\u68c0\u6d4bitemNames\u3001scores\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (ObjectUtils.equals(null, (Object)this.levels)) {
            this.levels = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f};
        }
        if (ObjectUtils.equals(null, (Object)this.areaBackgroundColors)) {
            this.areaBackgroundColors = new int[]{14611967, 15661023, 0xFFF5DD};
        }
        if (ObjectUtils.equals(null, (Object)this.tableHeadFillColors)) {
            this.tableHeadFillColors = new int[]{5885951, 11131233, 16764500};
        }
        if (ObjectUtils.equals(null, (Object)this.rowColors)) {
            this.rowColors = new int[]{0xFFFFFF, 0xF2F2F2};
        }
        if (ObjectUtils.equals(null, (Object)this.scoreDescNames)) {
            this.scoreDescNames = new String[]{"\u7b2c\u4e00\u6279\u6b21", "\u7b2c\u4e8c\u6279\u6b21", "\u7b2c\u4e09\u6279\u6b21", "\u7b2c\u56db\u6279\u6b21", "\u7b2c\u4e94\u6279\u6b21"};
        }
        if (ObjectUtils.equals(null, (Object)this.jionLineColors)) {
            this.jionLineColors = new int[]{9933532, 16764500, 7523245, 14974292, 5885951};
        }
        try {
            BaseColor fontColor_ = new BaseColor(this.fontColor);
            BaseColor borderColor_ = new BaseColor(this.borderColor);
            BaseColor tableBorderColor_ = new BaseColor(this.tableBorderColor);
            BaseColor[] jionLineColors_ = new BaseColor[this.jionLineColors.length];
            int len = this.jionLineColors.length;
            for (int i = 0; i < len; ++i) {
                jionLineColors_[i] = new BaseColor(this.jionLineColors[i]);
            }
            this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
            this.contentByte.setColorFill(fontColor_);
            this.drawEveryArea();
            this.drawFrame(borderColor_, fontColor_);
            this.drawTable(fontColor_, tableBorderColor_, jionLineColors_);
            this.drawScore(jionLineColors_);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawScore(BaseColor[] jionLineColors) {
        float sepWidth = this.width / (float)this.itemNames.length;
        float kHeight = this.height / (this.levels[this.levels.length - 1] - this.levels[0]);
        float x0 = this.x + sepWidth / 2.0f;
        int len = this.scores.length;
        for (int i = 0; i < len; ++i) {
            this.contentByte.setColorStroke(jionLineColors[i]);
            this.contentByte.setColorFill(jionLineColors[i]);
            int l = this.scores[i].length;
            for (int j = 0; j < l; ++j) {
                if (j > 0) {
                    this.moveLine(this.contentByte, x0 - 2.0f, this.y + kHeight * (this.scores[i][j] - this.levels[0]), x0 - sepWidth + 2.0f, this.y + kHeight * (this.scores[i][j - 1] - this.levels[0]));
                }
                this.moveCircle(this.contentByte, x0, this.y + kHeight * (this.scores[i][j] - this.levels[0]), 2.0f, false);
                x0 += sepWidth;
            }
            x0 = this.x + sepWidth / 2.0f;
        }
    }

    private void drawEveryArea() {
        float sepWidth = this.width / (float)this.itemNames.length;
        float x0 = this.x;
        for (int i = 0; i < this.itemNames.length; ++i) {
            this.moveRect(this.contentByte, i == 0 ? x0 + 1.0f : x0, this.y + 1.0f, x0 + sepWidth - 1.0f, this.y + this.height, this.areaBackgroundColors[i], false);
            x0 += sepWidth;
        }
    }

    private void drawMulRowText(float lineHeight, float witdh, String text, float x, float y) {
        this.moveMultiLineText(this.contentByte, text, this.fontSize, witdh, lineHeight, x, y, 0);
    }

    private float calTableHeadHeight(float width) {
        float sum = 0.0f;
        for (int i = 0; i < this.itemNames.length; ++i) {
            sum = Math.max(sum, (float)this.itemNames[i].length());
        }
        sum = sum * this.fontSize % width == 0.0f ? sum * this.fontSize / width : (float)(Math.floor(sum * this.fontSize / width) + 1.0);
        return (sum - 1.0f) * this.fontSize + this.cellHeight;
    }

    private void drawTable(BaseColor fontColor, BaseColor tabelBorderColor, BaseColor[] jionLineColors) {
        int i;
        float sepWidth = this.width / (float)this.itemNames.length;
        float temp = this.calTableHeadHeight(sepWidth);
        float x0 = this.x;
        float y0 = this.y - temp;
        this.positionY += temp;
        this.contentByte.setLineWidth(1.0f);
        this.contentByte.setLineDash(1.0f);
        for (i = 0; i < this.itemNames.length; ++i) {
            this.contentByte.setColorFill(tabelBorderColor);
            this.contentByte.setColorStroke(tabelBorderColor);
            this.moveRect(this.contentByte, x0, this.y, x0 + sepWidth - 1.0f, y0 + 1.0f, this.tableHeadFillColors[i], new boolean[0]);
            this.moveLine(this.contentByte, x0 + sepWidth - 1.0f, this.y, x0 + sepWidth - 1.0f, y0 + 1.0f);
            this.contentByte.setColorFill(BaseColor.WHITE);
            this.drawMulRowText(temp - 1.0f, sepWidth, this.itemNames[i], x0, this.y);
            x0 += sepWidth;
        }
        this.contentByte.setColorStroke(tabelBorderColor);
        this.moveLine(this.contentByte, x0 - this.width - 1.0f, y0, x0 - this.width - 1.0f, y0 + this.cellHeight + 1.0f);
        x0 = this.x;
        int len = this.scores.length;
        for (i = 0; i < len; ++i) {
            int l = this.scores[i].length;
            for (int j = 0; j < l; ++j) {
                this.contentByte.setColorStroke(tabelBorderColor);
                this.contentByte.setColorFill(tabelBorderColor);
                this.moveRect(this.contentByte, x0, y0, x0 + sepWidth - 1.0f, y0 - this.cellHeight + 1.0f, this.rowColors[i % 2], new boolean[0]);
                this.moveLine(this.contentByte, x0 + sepWidth - 1.0f, y0, x0 + sepWidth - 1.0f, y0 - this.cellHeight + 1.0f);
                this.contentByte.setColorFill(fontColor);
                this.drawMulRowText(this.cellHeight - 1.0f, sepWidth, this.scores[i][j] + "", x0, y0);
                if (i == len - 1) {
                    this.moveLine(this.contentByte, x0, y0 - this.cellHeight + 1.0f, x0 + sepWidth, y0 - this.cellHeight + 1.0f);
                }
                x0 += sepWidth;
            }
            x0 = this.x;
            this.moveRect(this.contentByte, x0 - 1.0f, y0, x0 - 1.0f - (float)this.scoreDescWidth, y0 - this.cellHeight + 1.0f, this.rowColors[i % 2], new boolean[0]);
            this.contentByte.setColorStroke(tabelBorderColor);
            this.moveLine(this.contentByte, x0 - 1.0f, y0, x0 - 1.0f, y0 - this.cellHeight + 1.0f);
            this.moveLine(this.contentByte, x0 - 1.0f - (float)this.scoreDescWidth, y0, x0 - 1.0f - (float)this.scoreDescWidth, y0 - this.cellHeight + 1.0f);
            if (i == 0) {
                this.moveLine(this.contentByte, x0 - 1.0f, y0, x0 - 1.0f - (float)this.scoreDescWidth, y0);
            }
            if (i == len - 1) {
                this.moveLine(this.contentByte, x0 - 1.0f, y0 - this.cellHeight + 1.0f, x0 - 1.0f - (float)this.scoreDescWidth, y0 - this.cellHeight + 1.0f);
            }
            this.contentByte.setColorFill(fontColor);
            temp = (float)this.scoreDescWidth * 4.0f / 5.0f;
            this.drawMulRowText(this.cellHeight, temp, this.scoreDescNames[i], x0 - 1.0f - temp, y0);
            temp = (temp - this.calTextWidth(this.fontSize, this.scoreDescNames[i])) / 2.0f;
            temp = ((float)(this.scoreDescWidth / 5) + temp) / 2.0f;
            this.contentByte.setColorStroke(jionLineColors[i]);
            this.drawLineCircle(x0 - 1.0f - (float)this.scoreDescWidth + temp, y0 - this.cellHeight / 2.0f, 2.0f, false);
            y0 -= this.cellHeight;
            this.positionY += this.cellHeight;
        }
    }

    private void drawLineCircle(float x, float y, float r, boolean isFill) {
        this.moveCircle(this.contentByte, x, y, r, isFill);
        this.moveLine(this.contentByte, x - r, y, x - r - 5.0f, y);
        this.moveLine(this.contentByte, x + r, y, x + r + 5.0f, y);
    }

    private void drawFrame(BaseColor borderColor, BaseColor fontColor) {
        this.contentByte.setColorStroke(borderColor);
        this.moveLine(this.contentByte, this.x, this.y, this.x, this.y + this.height);
        float x1 = this.x;
        float kHeight = this.height / (this.levels[this.levels.length - 1] - this.levels[0]);
        float y1 = 0.0f;
        for (int i = 0; i < this.levels.length; ++i) {
            y1 = this.y + kHeight * (this.levels[i] - this.levels[0]);
            this.contentByte.setColorStroke(borderColor);
            this.contentByte.setLineDash(1.0f);
            this.moveLine(this.contentByte, x1, y1, this.x - 2.0f, y1);
            this.contentByte.setColorFill(fontColor);
            this.moveText(this.contentByte, this.levels[i] + "", x1 - 6.0f, y1 - 3.0f, 2, 0.0f);
            if (i <= 0) continue;
            this.contentByte.setColorStroke(borderColor);
            this.contentByte.setLineDash(2.0f, 3.0f, 3.0f);
            this.moveLine(this.contentByte, x1, y1, x1 + this.width, y1);
            this.contentByte.setLineDash(6.0f, 1.0f);
            this.moveLine(this.contentByte, x1, y1, x1 + this.width, y1);
        }
        this.moveText(this.contentByte, this.levels[this.levels.length - 1] + "", x1 - 6.0f, y1 - 3.0f, 2, 0.0f);
    }

    public LineMulCurveLineAreaTableChart setX(float x) {
        this.x = x;
        return this;
    }

    public LineMulCurveLineAreaTableChart setY(float y) {
        this.y = y;
        return this;
    }

    public LineMulCurveLineAreaTableChart setHeight(float height) {
        this.height = height;
        return this;
    }

    public LineMulCurveLineAreaTableChart setWidth(float width) {
        this.width = width;
        return this;
    }

    public LineMulCurveLineAreaTableChart setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public LineMulCurveLineAreaTableChart setLevels(float[] levels) {
        this.levels = levels;
        return this;
    }

    public LineMulCurveLineAreaTableChart setItemNames(String[] itemNames) {
        this.itemNames = itemNames;
        return this;
    }

    public LineMulCurveLineAreaTableChart setAreaBackgroundColors(int[] areaBackgroundColors) {
        this.areaBackgroundColors = areaBackgroundColors;
        return this;
    }

    public LineMulCurveLineAreaTableChart setTableHeadFillColors(int[] tableHeadFillColors) {
        this.tableHeadFillColors = tableHeadFillColors;
        return this;
    }

    public LineMulCurveLineAreaTableChart setJionLineColors(int[] jionLineColors) {
        this.jionLineColors = jionLineColors;
        return this;
    }

    public LineMulCurveLineAreaTableChart setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public LineMulCurveLineAreaTableChart setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public LineMulCurveLineAreaTableChart setScores(float[][] scores) {
        this.scores = scores;
        return this;
    }

    public LineMulCurveLineAreaTableChart setRowColors(int[] rowColors) {
        this.rowColors = rowColors;
        return this;
    }

    public LineMulCurveLineAreaTableChart setCellHeight(float cellHeight) {
        this.cellHeight = cellHeight;
        return this;
    }

    public LineMulCurveLineAreaTableChart setTableBorderColor(int tableBorderColor) {
        this.tableBorderColor = tableBorderColor;
        return this;
    }

    public float getPositionY() {
        this.positionY = this.y - this.positionY - 5.0f;
        return this.positionY;
    }
}

