/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.chart;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.AsianFontMapper;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.FontMapper;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class PolyLineChart
extends AbstractChart {
    private List<Float[]> dataList;
    private String[] dataRowNames;
    private String[] dataColNames;
    private int[] dataColColors;
    private float cellHeight = 20.0f;
    private float fontSize = 9.0f;
    private int tableBorderColor = 0xCFCFCF;
    private int[] rowColors;
    private int fontColor = 0;
    private int scoreDescWidth = 60;
    private float maxValue = 9.0f;
    private int rownum = 9;
    private Integer[] normBGColor;
    private Integer[] batchColor;
    private int templateWidth = 470;
    private int templateHeight = 200;
    private int yOffset = 50;
    private int xOffset = 50;
    private int tableTitleWidth = 20;
    private int before = 5;
    private int leftBlank = 20;
    private float positionY;

    public PolyLineChart() {
    }

    public PolyLineChart(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        int j;
        List<int[]> dot;
        int i;
        this.positionY = 0.0f;
        if (ObjectUtils.equals(null, this.dataList) || this.dataList.isEmpty()) {
            throw new RuntimeException("\u8bf7\u68c0\u6d4bdataList\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (ObjectUtils.equals(null, (Object)this.normBGColor) || this.normBGColor.length < 1) {
            this.normBGColor = new Integer[]{14611967, 15661023, 0xFFF5DD};
        }
        if (ObjectUtils.equals(null, (Object)this.batchColor) || this.batchColor.length < 1) {
            this.batchColor = new Integer[]{9933533, 16764500, 7523501, 15039828, 9031679};
        }
        if (ObjectUtils.equals(null, (Object)this.dataColColors)) {
            this.dataColColors = new int[]{5885951, 11131233, 16764500};
        }
        if (ObjectUtils.equals(null, (Object)this.rowColors)) {
            this.rowColors = new int[]{0xFFFFFF, 0xF2F2F2};
        }
        if (ObjectUtils.equals(null, (Object)this.dataRowNames)) {
            this.dataRowNames = new String[]{"\u7b2c\u4e00\u6279\u6b21", "\u7b2c\u4e8c\u6279\u6b21", "\u7b2c\u4e09\u6279\u6b21", "\u7b2c\u56db\u6279\u6b21", "\u7b2c\u4e94\u6279\u6b21"};
        }
        int chartColWidth = (this.templateWidth - this.tableTitleWidth) / this.normBGColor.length;
        this.templateWidth = this.tableTitleWidth + chartColWidth * this.normBGColor.length;
        int chartRowHeight = (this.templateHeight - this.before) / this.rownum;
        int chartHeight = chartRowHeight * this.rownum;
        this.templateHeight = chartHeight + this.before;
        AsianFontMapper fm = new AsianFontMapper("STSong-Light", "UniGB-UCS2-H");
        PdfTemplate template = this.contentByte.createTemplate((float)this.templateWidth, (float)this.templateHeight);
        this.contentByte.addTemplate(template, (float)this.xOffset, this.document.getPageSize().getHeight() - (float)this.templateHeight - (float)this.yOffset);
        Graphics2D g2d = template.createGraphics((float)this.templateWidth, (float)this.templateHeight, (FontMapper)fm);
        for (int j2 = 0; j2 < this.normBGColor.length; ++j2) {
            g2d.setColor(new Color(this.normBGColor[j2]));
            g2d.fillRect(this.tableTitleWidth + j2 * chartColWidth, this.before, chartColWidth, chartHeight);
        }
        BasicStroke dash = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{4.0f, 3.0f, 1.0f, 3.0f}, 0.0f);
        for (int i2 = 0; i2 < this.rownum + 1; ++i2) {
            g2d.setColor(Color.GRAY);
            g2d.setStroke(dash);
            if (i2 < this.rownum) {
                g2d.drawLine(this.tableTitleWidth, this.before + i2 * chartRowHeight, this.templateWidth, this.before + i2 * chartRowHeight);
            }
            g2d.setColor(Color.GRAY);
            if (i2 < this.rownum) {
                g2d.drawString(this.maxValue - (float)i2 * (this.maxValue / (float)this.rownum) + "", this.tableTitleWidth - this.leftBlank, this.before + i2 * chartRowHeight + 4);
                continue;
            }
            g2d.drawString(this.maxValue - (float)i2 * (this.maxValue / (float)this.rownum) + "", this.tableTitleWidth - this.leftBlank, this.before + i2 * chartRowHeight);
        }
        dash = new BasicStroke(1.0f);
        g2d.setStroke(dash);
        g2d.setColor(Color.GRAY);
        g2d.drawLine(this.tableTitleWidth, this.before, this.tableTitleWidth, this.before + chartHeight);
        ArrayList dots = new ArrayList();
        for (i = 0; i < this.dataList.size(); ++i) {
            dot = new ArrayList();
            dots.add(dot);
            Float[] datas = this.dataList.get(i);
            for (j = 0; j < datas.length; ++j) {
                float score = datas[j].floatValue();
                g2d.setColor(new Color(this.batchColor[i]));
                int x = this.tableTitleWidth + j * chartColWidth + chartColWidth / 2;
                int y = this.before + (int)((this.maxValue - score) / this.maxValue * (float)chartHeight);
                g2d.fillOval(x - 2, y - 2, 4, 4);
                g2d.setColor(Color.WHITE);
                g2d.fillOval(x - 1, y - 1, 2, 2);
                dot.add(new int[]{x, y});
            }
        }
        for (i = 0; i < dots.size(); ++i) {
            g2d.setColor(new Color(this.batchColor[i]));
            dot = (List)dots.get(i);
            for (j = 0; j < dot.size() - 1; ++j) {
                g2d.drawLine(((int[])dot.get(j))[0] + 1, ((int[])dot.get(j))[1], ((int[])dot.get(j + 1))[0] - 1, ((int[])dot.get(j + 1))[1]);
            }
        }
        g2d.dispose();
        this.drawTable();
    }

    private float calTableHeadHeight(float width) {
        float sum = 0.0f;
        for (int i = 0; i < this.dataColNames.length; ++i) {
            sum = Math.max(sum, (float)this.dataColNames[i].length());
        }
        sum = sum * this.fontSize % width == 0.0f ? sum * this.fontSize / width : (float)(Math.floor(sum * this.fontSize / width) + 1.0);
        return (sum - 1.0f) * this.fontSize + this.cellHeight;
    }

    private void drawTable() {
        float curY = this.getPositionY() + 5.0f;
        float sepWidth = (this.templateWidth - this.tableTitleWidth) / this.normBGColor.length;
        float temp = this.calTableHeadHeight(sepWidth);
        float x0 = this.xOffset + this.tableTitleWidth;
        BaseColor tabelBorderColor = new BaseColor(this.tableBorderColor);
        this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
        int len = this.dataColNames.length;
        for (int i = 0; i < len; ++i) {
            this.moveRect(this.contentByte, x0, curY, x0 + sepWidth, curY - temp, this.dataColColors[i], new boolean[0]);
            this.contentByte.setColorFill(BaseColor.WHITE);
            this.moveMultiLineText(this.contentByte, this.dataColNames[i], this.fontSize, sepWidth, temp, x0, curY, 0);
            this.contentByte.setColorFill(tabelBorderColor);
            this.contentByte.setColorStroke(tabelBorderColor);
            this.moveLine(this.contentByte, x0 + sepWidth, curY, x0 + sepWidth, curY - this.cellHeight + 1.0f);
            x0 += sepWidth;
        }
        this.positionY = temp;
        curY -= temp;
        BaseColor fontColor_ = new BaseColor(this.fontColor);
        BaseColor[] lineColors_ = new BaseColor[this.batchColor.length];
        int len2 = this.batchColor.length;
        for (int k = 0; k < len2; ++k) {
            lineColors_[k] = new BaseColor(this.batchColor[k].intValue());
        }
        x0 = this.xOffset + this.tableTitleWidth;
        this.contentByte.setColorStroke(tabelBorderColor);
        this.moveLine(this.contentByte, x0, curY, x0, curY + this.cellHeight + 1.0f);
        temp = 0.0f;
        len2 = this.dataList.size();
        for (int i = 0; i < len2; ++i) {
            int l = this.dataList.get(i).length;
            for (int j = 0; j < l; ++j) {
                this.contentByte.setColorStroke(tabelBorderColor);
                this.contentByte.setColorFill(tabelBorderColor);
                this.moveRect(this.contentByte, x0, curY, x0 + sepWidth, curY - this.cellHeight + 1.0f, this.rowColors[i % 2], new boolean[0]);
                this.moveLine(this.contentByte, x0 + sepWidth, curY, x0 + sepWidth, curY - this.cellHeight + 1.0f);
                this.contentByte.setColorFill(fontColor_);
                this.moveMultiLineText(this.contentByte, this.dataList.get(i)[j] + "", this.fontSize, sepWidth, this.cellHeight, x0, curY, 0);
                if (i == len2 - 1) {
                    this.moveLine(this.contentByte, x0, curY - this.cellHeight + 1.0f, x0 + sepWidth, curY - this.cellHeight + 1.0f);
                }
                x0 += sepWidth;
            }
            x0 = this.xOffset + this.tableTitleWidth;
            this.moveRect(this.contentByte, x0 - 1.0f, curY, x0 - 1.0f - (float)this.scoreDescWidth, curY - this.cellHeight + 1.0f, this.rowColors[i % 2], new boolean[0]);
            this.contentByte.setColorStroke(tabelBorderColor);
            this.moveLine(this.contentByte, x0 - 1.0f, curY, x0 - 1.0f, curY - this.cellHeight + 1.0f);
            this.moveLine(this.contentByte, x0 - 1.0f - (float)this.scoreDescWidth, curY, x0 - 1.0f - (float)this.scoreDescWidth, curY - this.cellHeight + 1.0f);
            if (i == 0) {
                this.moveLine(this.contentByte, x0 - 1.0f, curY, x0 - 1.0f - (float)this.scoreDescWidth, curY);
            }
            if (i == len2 - 1) {
                this.moveLine(this.contentByte, x0 - 1.0f, curY - this.cellHeight + 1.0f, x0 - 1.0f - (float)this.scoreDescWidth, curY - this.cellHeight + 1.0f);
            }
            this.contentByte.setColorFill(fontColor_);
            temp = (float)this.scoreDescWidth * 4.0f / 5.0f;
            this.moveMultiLineText(this.contentByte, this.dataRowNames[i], this.fontSize, temp, this.cellHeight, x0 - 1.0f - temp, curY, 0);
            temp = (temp - this.calTextWidth(this.fontSize, this.dataRowNames[i])) / 2.0f;
            temp = ((float)(this.scoreDescWidth / 5) + temp) / 2.0f;
            this.contentByte.setColorStroke(lineColors_[i]);
            this.drawLineCircle(x0 - 1.0f - (float)this.scoreDescWidth + temp, curY - this.cellHeight / 2.0f, 2.0f, false);
            curY -= this.cellHeight;
            this.positionY += this.cellHeight;
        }
    }

    private void drawLineCircle(float x, float y, float r, boolean isFill) {
        this.moveCircle(this.contentByte, x, y, r, isFill);
        this.moveLine(this.contentByte, x - r, y, x - r - 5.0f, y);
        this.moveLine(this.contentByte, x + r, y, x + r + 5.0f, y);
    }

    public PolyLineChart setDataList(List<Float[]> dataList) {
        this.dataList = dataList;
        return this;
    }

    public PolyLineChart setMaxValue(float maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public PolyLineChart setRownum(int rownum) {
        this.rownum = rownum;
        return this;
    }

    public PolyLineChart setNormBGColor(Integer[] normBGColor) {
        this.normBGColor = normBGColor;
        return this;
    }

    public PolyLineChart setBatchColor(Integer[] batchColor) {
        this.batchColor = batchColor;
        return this;
    }

    public PolyLineChart setTemplateWidth(int templateWidth) {
        this.templateWidth = templateWidth;
        return this;
    }

    public PolyLineChart setTemplateHeight(int templateHeight) {
        this.templateHeight = templateHeight;
        return this;
    }

    public PolyLineChart setyOffset(int yOffset) {
        this.yOffset = yOffset;
        return this;
    }

    public PolyLineChart setxOffset(int xOffset) {
        this.xOffset = xOffset;
        return this;
    }

    public PolyLineChart setTableTitleWidth(int tableTitleWidth) {
        this.tableTitleWidth = tableTitleWidth;
        return this;
    }

    public PolyLineChart setBefore(int before) {
        this.before = before;
        return this;
    }

    public PolyLineChart setLeftBlank(int leftBlank) {
        this.leftBlank = leftBlank;
        return this;
    }

    public PolyLineChart setDataRowNames(String[] dataRowNames) {
        this.dataRowNames = dataRowNames;
        return this;
    }

    public PolyLineChart setDataColNames(String[] dataColNames) {
        this.dataColNames = dataColNames;
        return this;
    }

    public PolyLineChart setDataColColors(int[] dataColColors) {
        this.dataColColors = dataColColors;
        return this;
    }

    public PolyLineChart setCellHeight(float cellHeight) {
        this.cellHeight = cellHeight;
        return this;
    }

    public PolyLineChart setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public PolyLineChart setTableBorderColor(int tableBorderColor) {
        this.tableBorderColor = tableBorderColor;
        return this;
    }

    public PolyLineChart setRowColors(int[] rowColors) {
        this.rowColors = rowColors;
        return this;
    }

    public PolyLineChart setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public PolyLineChart setScoreDescWidth(int scoreDescWidth) {
        this.scoreDescWidth = scoreDescWidth;
        return this;
    }

    public float getPositionY() {
        this.positionY = this.document.getPageSize().getHeight() - this.positionY;
        this.positionY -= (float)this.templateHeight;
        this.positionY -= (float)this.yOffset;
        return this.positionY;
    }
}

