/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.chart;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.base.TPoint;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import java.text.DecimalFormat;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class RadarSimpleRectChart
extends AbstractChart {
    private float x;
    private float r = 100.0f;
    private float y;
    private float fontSize = 9.0f;
    private int fillColor = 16688930;
    private float positionY;
    private String[] itemNames;
    private float[] scores;
    private BaseColor borderColor = BaseColor.LIGHT_GRAY;
    private int scale = 2;
    private float maxScore = 100.0f;
    private float smallCircle = 5.0f;

    public RadarSimpleRectChart() {
    }

    public RadarSimpleRectChart(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        this.positionY = 0.0f;
        if (ObjectUtils.equals(null, (Object)this.itemNames) || this.itemNames.length < 1 || ObjectUtils.equals(null, (Object)this.scores) || this.scores.length < 1) {
            throw new RuntimeException("\u8bf7\u68c0\u6d4bitemNames\u3001scores\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        BaseColor fillColor_ = new BaseColor(this.fillColor);
        try {
            this.addRadar(fillColor_);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addRadar(BaseColor fillColor) {
        int count = this.itemNames.length;
        float y = this.writer.getVerticalPosition(true);
        float spaceSize = 360.0f / (float)count;
        DecimalFormat df = new DecimalFormat("0" + (this.scale > 0 ? "." + StringUtils.repeat((String)"#", (int)this.scale) : ""));
        this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
        this.contentByte.setColorFill(fillColor);
        float centerPointX = this.x;
        float centerPointY = this.y;
        float x0 = 0.0f;
        TPoint pointAttr = null;
        TPoint centerPoint = new TPoint(centerPointX, centerPointY);
        float space = spaceSize;
        float nextX = 0.0f;
        float nextY = 0.0f;
        float tempRound = 0.0f;
        float tempRound_ = 0.0f;
        for (int i = 0; i <= count; ++i) {
            tempRound = i == count ? this.scores[0] * this.r / this.maxScore : this.scores[i] * this.r / this.maxScore;
            tempRound = this.maxScore == 0.0f ? 0.0f : tempRound;
            x0 = centerPointX + (float)((double)tempRound_ * Math.sin(Math.PI * (double)(space - spaceSize) / 180.0));
            y = centerPointY + (float)((double)tempRound_ * Math.cos(Math.PI * (double)(space - spaceSize) / 180.0));
            nextX = centerPointX + (float)((double)tempRound * Math.sin(Math.PI * (double)space / 180.0));
            nextY = centerPointY + (float)((double)tempRound * Math.cos(Math.PI * (double)space / 180.0));
            tempRound_ = tempRound;
            if (i > 0) {
                this.contentByte.setColorStroke(this.borderColor);
                this.moveLine(this.contentByte, x0, y, nextX, nextY);
                this.contentByte.setColorStroke(fillColor);
                int j = 1;
                while ((float)j < tempRound) {
                    nextX = centerPointX + (float)((double)j * Math.sin(Math.PI * (double)(i == count ? spaceSize : space) / 180.0));
                    nextY = centerPointY + (float)((double)j * Math.cos(Math.PI * (double)(i == count ? spaceSize : space) / 180.0));
                    if ((float)((int)y) == centerPointY) {
                        if (i < count / 2) {
                            this.moveLine(this.contentByte, x0, y - 1.0f, nextX, nextY);
                        } else {
                            this.moveLine(this.contentByte, x0, y + 1.0f, nextX, nextY);
                        }
                    } else if (y < centerPointY) {
                        this.moveLine(this.contentByte, x0 - 1.5f, y, nextX, nextY);
                    } else {
                        this.moveLine(this.contentByte, x0 + 1.5f, y, nextX, nextY);
                    }
                    ++j;
                }
            }
            this.contentByte.setColorStroke(this.borderColor);
            x0 = centerPointX + (float)((double)this.r * Math.sin(Math.PI * (double)(space - spaceSize) / 180.0));
            y = centerPointY + (float)((double)this.r * Math.cos(Math.PI * (double)(space - spaceSize) / 180.0));
            nextX = centerPointX + (float)((double)this.r * Math.sin(Math.PI * (double)(i == count ? spaceSize : space) / 180.0));
            nextY = centerPointY + (float)((double)this.r * Math.cos(Math.PI * (double)(i == count ? spaceSize : space) / 180.0));
            if (i != count) {
                this.moveLine(this.contentByte, centerPointX, centerPointY, nextX, nextY);
                this.contentByte.circle(nextX, nextY, this.smallCircle);
                this.contentByte.setColorFill(fillColor);
                this.contentByte.fillStroke();
            }
            if (i != 0) {
                this.moveLine(this.contentByte, x0, y, nextX, nextY);
                int i0 = i != count ? i : 0;
                String str = this.itemNames[i0] + " " + df.format(this.scores[i0]) + "%";
                float width = (float)(this.itemNames[i0] + "").length() * this.fontSize / 2.0f + (float)(df.format(this.scores[i0]) + "%").length() * this.fontSize / 2.0f + this.fontSize;
                this.contentByte.setColorFill(BaseColor.BLACK);
                pointAttr = this.changeRotation(i == count ? spaceSize : space, width, centerPoint);
                this.moveText(this.contentByte, str, pointAttr.getX(), pointAttr.getY(), 1, pointAttr.getR());
            }
            space += spaceSize;
        }
    }

    private int textMaxLength() {
        int max = 0;
        for (String s : this.itemNames) {
            max = s.length() > max ? s.length() : max;
        }
        return max;
    }

    private TPoint changeRotation(float space, float width, TPoint centerPoint) {
        TPoint pointAttr = new TPoint();
        pointAttr.setX(centerPoint.getX() + (float)((double)(this.r + width) * Math.sin(Math.PI * (double)space / 180.0)));
        pointAttr.setY(centerPoint.getY() + (float)((double)(this.r + width) * Math.cos(Math.PI * (double)space / 180.0)));
        if (space > 45.0f && space <= 225.0f) {
            pointAttr.setR(90.0f - space);
        } else if (space <= 361.0f || space <= 45.0f) {
            pointAttr.setR(270.0f - space);
        }
        return pointAttr;
    }

    public RadarSimpleRectChart setX(float x) {
        this.x = x;
        return this;
    }

    public RadarSimpleRectChart setY(float y) {
        this.y = y;
        return this;
    }

    public RadarSimpleRectChart setItemNames(String[] itemNames) {
        this.itemNames = itemNames;
        return this;
    }

    public RadarSimpleRectChart setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public RadarSimpleRectChart setR(float r) {
        this.r = r;
        return this;
    }

    public RadarSimpleRectChart setFillColor(int fillColor) {
        this.fillColor = fillColor;
        return this;
    }

    public RadarSimpleRectChart setScores(float[] scores) {
        this.scores = scores;
        return this;
    }

    public RadarSimpleRectChart setScale(int scale) {
        this.scale = scale;
        return this;
    }

    public RadarSimpleRectChart setMaxScore(float maxScore) {
        this.maxScore = maxScore;
        return this;
    }

    public RadarSimpleRectChart setBorderColor(BaseColor borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public RadarSimpleRectChart setSmallCircle(float smallCircle) {
        this.smallCircle = smallCircle;
        return this;
    }

    public float getPositionY() {
        this.positionY = this.y - this.r - (float)this.textMaxLength() * this.fontSize - (float)("" + NumberUtils.max((float[])this.scores)).length() * this.fontSize;
        return this.positionY;
    }
}

