/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.chart;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class Round2DCakeChart
extends AbstractChart {
    private float x;
    private float y;
    private float r = 80.0f;
    private float rotation = 90.0f;
    private BaseColor[] fillColors;
    private String[] descs;
    private float fontSize = 10.0f;
    private float[] scores;
    private float positionY;
    private final int SIDE_NUM = 3600;
    private final float MAX = 180.0f;
    private float whiteSepLineWidth = 1.5f;
    private boolean isDrawDesc = true;

    public Round2DCakeChart() {
    }

    public Round2DCakeChart(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        float space;
        this.positionY = 0.0f;
        if (ObjectUtils.equals(null, (Object)this.scores) || this.scores.length < 1) {
            throw new IllegalArgumentException("\u8bf7\u68c0\u6d4bscores\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (this.isDrawDesc && (ObjectUtils.equals(null, (Object)this.descs) || this.descs.length < 1)) {
            throw new IllegalArgumentException("descs\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (ObjectUtils.equals(null, (Object)this.fillColors)) {
            this.fillColors = new BaseColor[]{new BaseColor(5885951), new BaseColor(16309138), new BaseColor(11131233), new BaseColor(11772615), new BaseColor(0xFF0000)};
        }
        this.getClass();
        float spaceSize = space = 360.0f / 3600.0f;
        float x0 = 0.0f;
        float y0 = 0.0f;
        float tempValue = 0.0f;
        for (int i = 0; i < this.scores.length; ++i) {
            tempValue += this.scores[i];
        }
        float[] everyEreas = new float[this.scores.length];
        for (int i = 0; i < this.scores.length; ++i) {
            float f = this.scores[i] / tempValue;
            this.getClass();
            everyEreas[i] = f * 3600.0f;
        }
        int areaNum = 0;
        float areaSum = everyEreas[areaNum];
        for (int i = 0; i < this.SIDE_NUM; ++i) {
            if ((float)i <= areaSum) {
                this.contentByte.setColorStroke(this.fillColors[areaNum]);
            } else {
                areaSum += everyEreas[++areaNum];
            }
            double d = this.r;
            double d2 = Math.PI * (double)(space + this.rotation);
            this.getClass();
            x0 = this.x + (float)(d * Math.sin(d2 / 180.0));
            double d3 = this.r;
            double d4 = Math.PI * (double)(space + this.rotation);
            this.getClass();
            y0 = this.y + (float)(d3 * Math.cos(d4 / 180.0));
            this.moveLine(this.contentByte, this.x, this.y, x0, y0);
            space += spaceSize;
        }
        this.drawDataText(everyEreas, spaceSize);
        if (this.isDrawDesc) {
            this.drawDesc();
        }
        if (this.scores.length > 1) {
            this.drawSepLine(everyEreas);
        }
    }

    private void drawDesc() {
        float allWidth = (float)StringUtils.join((Object[])this.descs, (String)"").length() * this.fontSize + (float)((this.descs.length - 1) * 10) + (float)(this.descs.length * 10);
        float benginX = this.x - allWidth / 2.0f;
        float benginY = this.y - this.r - 30.0f;
        for (int i = 0; i < this.descs.length; ++i) {
            this.contentByte.setColorFill(this.fillColors[i]);
            this.contentByte.setColorStroke(this.fillColors[i]);
            this.moveRect(this.contentByte, benginX, benginY, benginX + 10.0f, benginY + 10.0f, this.fillColors[i].getRGB(), true);
            this.contentByte.setColorFill(BaseColor.BLACK);
            this.moveText(this.contentByte, this.descs[i], benginX += 13.0f, benginY, 0, 0.0f);
            benginX += (float)(this.descs[i].length() + 1) * this.fontSize;
        }
    }

    private void drawDataText(float[] everyEreas, float spaceSize) {
        this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
        float curEreaHalf = 0.0f;
        float space = 0.0f;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        float x0 = 0.0f;
        float y0 = 0.0f;
        float tempValue = 0.0f;
        int oneNum = 0;
        for (int i = 0; i < everyEreas.length; ++i) {
            space += curEreaHalf * spaceSize;
            curEreaHalf = everyEreas[i] / 2.0f;
            this.contentByte.setColorStroke(this.fillColors[i]);
            double d = this.r / 2.0f;
            double d2 = Math.PI * (double)((space += spaceSize * curEreaHalf) + this.rotation);
            this.getClass();
            x0 = this.x + (float)(d * Math.sin(d2 / 180.0));
            double d3 = this.r / 2.0f;
            double d4 = Math.PI * (double)(space + this.rotation);
            this.getClass();
            y0 = this.y + (float)(d3 * Math.cos(d4 / 180.0));
            if (this.scores[i] < 10.0f) {
                tempValue = this.fontSize * (float)("" + this.scores[i]).length();
                if (this.scores[i] <= 2.0f) {
                    tempValue = ++oneNum % 3 == 2 ? tempValue + this.fontSize * (float)("" + this.scores[i]).length() - 5.0f : (oneNum % 3 == 1 ? 5.0f : tempValue);
                }
                double d5 = this.r + tempValue;
                double d6 = Math.PI * (double)(space + this.rotation);
                this.getClass();
                offsetX = this.x + (float)(d5 * Math.sin(d6 / 180.0));
                double d7 = this.r + tempValue;
                double d8 = Math.PI * (double)(space + this.rotation);
                this.getClass();
                offsetY = this.y + (float)(d7 * Math.cos(d8 / 180.0));
                this.moveLine(this.contentByte, x0, y0, offsetX, offsetY);
                if (offsetX > this.x) {
                    this.moveText(this.contentByte, this.scores[i] + "%", offsetX, offsetY, 0, 0.0f);
                } else if (offsetX < this.x) {
                    this.moveText(this.contentByte, this.scores[i] + "%", offsetX, offsetY, 2, 0.0f);
                } else {
                    this.moveText(this.contentByte, this.scores[i] + "%", offsetX, offsetY, 1, 0.0f);
                }
                offsetY = 0.0f;
                offsetX = 0.0f;
                continue;
            }
            if (this.scores[i] < 20.0f) {
                double d9 = this.r / 2.0f;
                double d10 = Math.PI * (double)(space + this.rotation);
                this.getClass();
                offsetX = (float)(d9 * Math.sin(d10 / 180.0)) * 6.0f / this.scores[i];
                double d11 = this.r / 2.0f;
                double d12 = Math.PI * (double)(space + this.rotation);
                this.getClass();
                offsetY = (float)(d11 * Math.cos(d12 / 180.0)) * 4.0f / this.scores[i];
            }
            if (this.scores.length < 2) {
                offsetX = 0.0f;
                offsetY = 0.0f;
                x0 = this.x;
                y0 = this.y;
            }
            this.moveText(this.contentByte, this.scores[i] + "%", x0 + offsetX, y0 + offsetY, 1, 0.0f);
            offsetY = 0.0f;
            offsetX = 0.0f;
        }
    }

    private void drawSepLine(float[] everyEreas) {
        float space;
        this.getClass();
        float spaceSize = space = 360.0f / 3600.0f;
        int areaNum = 0;
        float areaSum = everyEreas[areaNum];
        float x0 = 0.0f;
        float y0 = 0.0f;
        this.contentByte.setColorStroke(BaseColor.WHITE);
        this.contentByte.setLineWidth(this.whiteSepLineWidth);
        for (int i = 0; i < this.SIDE_NUM; ++i) {
            if ((float)i > areaSum) {
                areaSum += everyEreas[++areaNum];
                double d = this.r;
                double d2 = Math.PI * (double)(space + this.rotation);
                this.getClass();
                x0 = this.x + (float)(d * Math.sin(d2 / 180.0));
                double d3 = this.r;
                double d4 = Math.PI * (double)(space + this.rotation);
                this.getClass();
                y0 = this.y + (float)(d3 * Math.cos(d4 / 180.0));
                this.moveLine(this.contentByte, this.x, this.y, x0, y0);
            }
            space += spaceSize;
        }
        double d = this.r;
        double d5 = Math.PI * (double)(spaceSize + this.rotation);
        this.getClass();
        x0 = this.x + (float)(d * Math.sin(d5 / 180.0));
        double d6 = this.r;
        double d7 = Math.PI * (double)(spaceSize + this.rotation);
        this.getClass();
        y0 = this.y + (float)(d6 * Math.cos(d7 / 180.0));
        this.moveLine(this.contentByte, this.x, this.y, x0, y0);
    }

    public Round2DCakeChart setX(float x) {
        this.x = x;
        return this;
    }

    public Round2DCakeChart setY(float y) {
        this.y = y;
        return this;
    }

    public Round2DCakeChart setR(float r) {
        this.r = r;
        return this;
    }

    public Round2DCakeChart setFillColors(BaseColor[] fillColors) {
        this.fillColors = fillColors;
        return this;
    }

    public Round2DCakeChart setDescs(String[] descs) {
        this.descs = descs;
        return this;
    }

    public Round2DCakeChart setScores(float[] scores) {
        this.scores = scores;
        return this;
    }

    public Round2DCakeChart setRotation(float rotation) {
        this.rotation = rotation;
        return this;
    }

    public Round2DCakeChart setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public Round2DCakeChart setWhiteSepLineWidth(float whiteSepLineWidth) {
        this.whiteSepLineWidth = whiteSepLineWidth;
        return this;
    }

    public float getPositionY() {
        this.positionY = this.y - this.r - 40.0f;
        return this.positionY;
    }

    public boolean isDrawDesc() {
        return this.isDrawDesc;
    }

    public void setDrawDesc(boolean drawDesc) {
        this.isDrawDesc = drawDesc;
    }
}

