/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.chart;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.base.TPoint;
import com.xianghy.itextpdf.tools.base.unit.CurveHasRadianGraph;
import com.xianghy.itextpdf.tools.base.unit.DoubleArrowGraph;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class TableChartedDoubleArrowCurveChart
extends AbstractChart {
    private float width = 450.0f;
    private String title;
    private float fontSize = 9.0f;
    private int titleColor = 5885951;
    private float lineHeight = 25.0f;
    private String[] tableHeads;
    private int[] scoreLevels;
    private int tableHeadColor = 11331583;
    private String[] parentTypes;
    private int parentTypeColor = 14480379;
    private List<String[]> childrenTypes;
    private float[][] scores;
    private int[] rowColors;
    private int colNumber = 3;
    private int colColor = 16442845;
    private float positionY;
    private int curveColor = 0xCC3030;
    private float[] widths;
    private float levelFontSize = 7.0f;
    private int maxScoreColNum = 1;
    private int minScoreColNum = 2;
    private int curScoreColNum = 3;
    private DoubleArrowGraph doubleArrowGraph;
    private CurveHasRadianGraph curveHasRadianGraph;
    private float[] realRowHeight;
    private int lineNumber;

    public TableChartedDoubleArrowCurveChart() {
    }

    public TableChartedDoubleArrowCurveChart(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        this.positionY = 0.0f;
        if (ObjectUtils.equals(null, (Object)this.title) || ObjectUtils.equals(null, this.childrenTypes) || this.childrenTypes.isEmpty() || ObjectUtils.equals(null, (Object)this.tableHeads) || this.tableHeads.length < 1 || ObjectUtils.equals(null, (Object)this.parentTypes) || this.parentTypes.length < 1 || ObjectUtils.equals(null, (Object)this.scores) || this.scores.length < 1) {
            throw new RuntimeException("\u8bf7\u68c0\u6d4btableHeads\u3001childrenTypes\u3001parentTypes\u3001scores\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (ObjectUtils.equals(null, (Object)this.scoreLevels)) {
            this.scoreLevels = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        }
        if (ObjectUtils.equals(null, (Object)this.widths)) {
            this.widths = new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 50.0f};
        }
        if (ObjectUtils.equals(null, (Object)this.rowColors)) {
            this.rowColors = new int[]{0xFFFFFF, 0xF2F2F2};
        }
        try {
            float sum = 0.0f;
            for (float w : this.widths) {
                sum += w;
            }
            float y0 = this.writer.getVerticalPosition(true);
            this.checkPositionHeight(y0, sum);
            BaseColor borderColor = new BaseColor(0xBFBFBF);
            if (this.lineNumber <= 0) {
                this.document.newPage();
            }
            this.addTitleHead();
            this.addTableHead(borderColor, sum);
            this.addTableBody(borderColor, sum);
            this.lineNumber = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int checkPositionHeight(float y0, float sum) {
        int i;
        float curHeight = this.lineHeight + 52.0f;
        float temp = 0.0f;
        for (i = 0; i < this.tableHeads.length; ++i) {
            temp = Math.max(this.everyColHeight(this.tableHeads[i], i, sum), temp);
        }
        curHeight += temp;
        for (i = 0; i < this.childrenTypes.size(); ++i) {
            int j;
            for (j = 0; j < this.childrenTypes.get(i).length; ++j) {
                temp = this.everyColHeight(this.childrenTypes.get(i)[j], 1, sum);
                curHeight += temp;
            }
            if (curHeight > y0) {
                return this.lineNumber;
            }
            this.lineNumber += j;
        }
        return this.lineNumber;
    }

    private void drawMulRowText(float lineHeight, float witdh, String text, float x, float y) {
        this.moveMultiLineText(this.contentByte, text, this.fontSize, witdh, lineHeight, x, y, 0);
    }

    private void addTableBody(BaseColor borderColor, float sum) throws Exception {
        float x;
        float y;
        float y0 = y = this.writer.getVerticalPosition(true);
        float x0 = x = (this.document.getPageSize().getWidth() - this.width) / 2.0f;
        int[] colSpan = new int[this.childrenTypes.size()];
        ArrayList<Object> childStr = new ArrayList<Object>();
        for (int i = 0; i < this.childrenTypes.size(); ++i) {
            colSpan[i] = this.childrenTypes.get(i).length;
            childStr.addAll(Arrays.asList((Object[])this.childrenTypes.get(i)));
        }
        this.realRowHeight = new float[this.scores.length];
        float[] rowScores = null;
        boolean isNewPage = true;
        this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
        for (int i = 0; i < this.scores.length; ++i) {
            if (this.lineNumber > 0 && isNewPage && i + 1 > this.lineNumber) {
                this.drawTextAndScore(y, colSpan, sum, true);
                this.document.newPage();
                this.addTitleHead();
                this.addTableHead(borderColor, sum);
                y = y0 = this.writer.getVerticalPosition(true);
                isNewPage = false;
                this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
            }
            rowScores = this.scores[i];
            this.realRowHeight[i] = this.everyColHeight((String)childStr.get(i) + "", 1, sum);
            int curColColor = 0;
            String text = null;
            this.contentByte.setColorStroke(borderColor);
            this.contentByte.setLineWidth(1.0f);
            this.moveLine(this.contentByte, x0 + 0.5f, y0, x0 + 0.5f, y0 - this.realRowHeight[i]);
            for (int curCol = 1; curCol < this.widths.length; ++curCol) {
                this.contentByte.setLineWidth(3.5f);
                curColColor = this.colNumber == curCol - 1 ? this.colColor : (curCol == this.widths.length - 1 || (i + 1) % 2 == 1 ? this.rowColors[0] : this.rowColors[1]);
                if (curCol == 1) {
                    text = (String)childStr.get(i);
                } else if (curCol != this.widths.length - 1) {
                    text = rowScores[curCol - 2] + "";
                }
                this.contentByte.setColorStroke(borderColor);
                this.moveLine(this.contentByte, x0 += this.widths[curCol - 1] * this.width / sum, y0, x0, y0 - this.realRowHeight[i]);
                this.moveRect(this.contentByte, x0, y0, x0 + this.widths[curCol] * this.width / sum, y0 - this.realRowHeight[i], curColColor, new boolean[0]);
                if (curCol != this.widths.length - 1) {
                    this.drawMulRowText(this.realRowHeight[i], this.widths[curCol] * this.width / sum, text, x0, y0);
                }
                if ((!isNewPage || this.lineNumber <= 0 || i + 1 < this.lineNumber) && (isNewPage && this.lineNumber > 0 || i != this.scores.length - 1)) continue;
                this.contentByte.setLineWidth(1.0f);
                this.moveLine(this.contentByte, x0 - this.widths[curCol] * this.width / sum, y0 - this.realRowHeight[i], x0, y0 - this.realRowHeight[i]);
                this.moveLine(this.contentByte, x0, y0 - this.realRowHeight[i], x0 + this.widths[curCol] * this.width / sum, y0 - this.realRowHeight[i]);
            }
            y0 -= this.realRowHeight[i];
            x0 = x;
        }
        this.drawTextAndScore(y, colSpan, sum, new boolean[0]);
        this.calPositionY(y);
    }

    private float rowHeightSum(int curRow, int[] colSpan) {
        int benRow = 0;
        for (int i = 0; i <= curRow - 1; ++i) {
            benRow += colSpan[i];
        }
        float sum = 0.0f;
        for (int i = benRow; i < benRow + colSpan[curRow]; ++i) {
            sum += this.realRowHeight[i];
        }
        return sum;
    }

    private void drawTextAndScore(float y, int[] colSpan, float sum, boolean ... isNewPage) {
        int i;
        float y0 = y - this.fontSize;
        float cellHeight = 0.0f;
        float offsetY = 0.0f;
        float yt = y0;
        float x0 = (this.document.getPageSize().getWidth() - this.width) / 2.0f + this.widths[0] * this.width / sum / 2.0f;
        char[] texts = null;
        this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
        int rows = 0;
        for (int i1 = 0; i1 < colSpan.length; ++i1) {
            if ((isNewPage.length < 1 || !isNewPage[0]) && this.lineNumber > 0 && this.lineNumber < this.realRowHeight.length && (rows += colSpan[i1]) <= this.lineNumber) continue;
            cellHeight = this.rowHeightSum(i1, colSpan);
            this.contentByte.setLineWidth(1.0f);
            this.moveRect(this.contentByte, x0 - this.widths[0] * this.width / sum / 2.0f + 1.0f, y0 + this.fontSize, x0 + this.widths[0] * this.width / sum / 2.0f - 2.0f, y0 - cellHeight + this.fontSize, 0xBFBFBF, new boolean[0]);
            this.moveRect(this.contentByte, x0 - this.widths[0] * this.width / sum / 2.0f + 1.0f, i1 == 0 ? y0 + this.fontSize : y0 + this.fontSize, x0 + this.widths[0] * this.width / sum / 2.0f - 2.0f, y0 - cellHeight + this.fontSize + 1.2f, this.parentTypeColor, true);
            yt -= cellHeight;
            if ((float)this.parentTypes[i1].length() * this.fontSize > cellHeight) {
                this.drawMulRowText(cellHeight, this.widths[0] * this.width / sum, this.parentTypes[i1], x0 - this.widths[0] * this.width / sum / 2.0f + 1.0f, y0 + this.fontSize);
            } else {
                offsetY = (float)this.parentTypes[i1].length() * this.fontSize;
                offsetY = (cellHeight - offsetY) / 2.0f;
                texts = this.parentTypes[i1].toCharArray();
                y0 -= offsetY;
                for (char c : texts) {
                    this.moveText(this.contentByte, c + "", x0, y0, 1, 0.0f);
                    y0 -= this.fontSize;
                }
            }
            y0 = yt;
            if (isNewPage.length > 0 && isNewPage[0] && rows >= this.lineNumber) break;
        }
        rows = 0;
        y0 = isNewPage.length > 0 && isNewPage[0] || this.lineNumber >= this.realRowHeight.length ? y - this.realRowHeight[0] : y - this.realRowHeight[this.lineNumber];
        x0 = (this.document.getPageSize().getWidth() - this.width) / 2.0f + this.width - this.widths[this.widths.length - 1] * this.width / sum;
        float endX = x0 + this.widths[this.widths.length - 1] * this.width / sum - 2.0f;
        float sepWidth = (endX - x0) / (float)(this.scoreLevels[this.scoreLevels.length - 1] - this.scoreLevels[0]);
        float offsetX = 0.0f;
        BaseColor lineYColor = new BaseColor(this.titleColor);
        BaseColor lineXColor = new BaseColor(0xBFBFBF);
        TPoint prevPoint = null;
        this.contentByte.setLineWidth(1.5f);
        int n = i = (isNewPage.length < 1 || !isNewPage[0]) && this.lineNumber < this.realRowHeight.length ? this.lineNumber : 0;
        while (i < this.scores.length) {
            if (isNewPage.length > 0 && isNewPage[0] && i + 1 < this.lineNumber || (isNewPage.length < 1 || !isNewPage[0]) && i + 1 != this.scores.length) {
                this.contentByte.setLineDash(2.5f);
                this.contentByte.setColorStroke(BaseColor.WHITE);
                if (this.colNumber == 3) {
                    this.moveLine(this.contentByte, x0 - this.widths[this.colNumber + 1] * this.width / sum - 3.0f, y0, x0 - 2.0f, y0);
                } else {
                    float l = 0.0f;
                    for (int t = this.colNumber + 1; t < this.widths.length - 1; ++t) {
                        l += this.widths[t] * this.width / sum;
                    }
                    this.moveLine(this.contentByte, x0 - this.widths[this.colNumber + 1] * this.width / sum - 3.0f, y0, x0 - l - 2.0f, y0);
                }
                this.contentByte.setLineDash(1.5f, 1.0f);
                this.contentByte.setColorStroke(lineYColor);
                this.moveLine(this.contentByte, x0, y0, endX, y0);
            }
            this.contentByte.setLineDash(1.5f, 1.0f);
            this.contentByte.setColorStroke(lineXColor);
            for (int j = 0; j < this.scoreLevels.length; ++j) {
                if (j + 1 == this.scoreLevels.length - 1) {
                    this.contentByte.setLineDash(1.0f);
                    this.contentByte.setLineWidth(1.0f);
                }
                if (j + 1 == this.scoreLevels.length) continue;
                offsetX = (float)(this.scoreLevels[j + 1] - this.scoreLevels[0]) * sepWidth;
                this.moveLine(this.contentByte, x0 + offsetX, y0 + this.realRowHeight[i], x0 + offsetX, y0);
            }
            this.contentByte.setLineDash(1.0f);
            prevPoint = this.drawGraph(this.widths[this.widths.length - 1] * this.width / sum - 2.0f, x0, y0, i, prevPoint);
            if (i + 1 != this.scores.length) {
                y0 -= this.realRowHeight[i + 1];
            }
            if (isNewPage.length > 0 && isNewPage[0] && i + 1 >= this.lineNumber) break;
            ++i;
        }
    }

    private TPoint drawGraph(float width, float x, float y, int rowNum, TPoint prevPoint) {
        float[] curRowScores = this.scores[rowNum];
        float subLeveScore = width / (float)(this.scoreLevels[this.scoreLevels.length - 1] - this.scoreLevels[0]);
        float maxScoreX = (curRowScores[this.maxScoreColNum - 1] - (float)this.scoreLevels[0]) * subLeveScore;
        float minScoreX = (curRowScores[this.minScoreColNum - 1] - (float)this.scoreLevels[0]) * subLeveScore;
        float curScoreX = (curRowScores[this.curScoreColNum - 1] - (float)this.scoreLevels[0]) * subLeveScore;
        if (ObjectUtils.equals(null, (Object)this.doubleArrowGraph)) {
            this.doubleArrowGraph = new DoubleArrowGraph(this.writer, this.contentByte, this.document);
        }
        this.doubleArrowGraph.setBaseChart(this);
        this.doubleArrowGraph.setX(x + minScoreX).setY(y + this.realRowHeight[rowNum] * 1.0f / 2.0f).setX0(x + maxScoreX).setY0(y + this.realRowHeight[rowNum] * 1.0f / 2.0f).setHeight(this.lineHeight * 2.0f / 3.0f).setColor(this.titleColor).setArrowWidth(5.0f).setArrowLineWidth(1.2f);
        this.doubleArrowGraph.chart();
        if (ObjectUtils.notEqual(null, (Object)prevPoint)) {
            if (ObjectUtils.equals(null, (Object)this.curveHasRadianGraph)) {
                this.curveHasRadianGraph = new CurveHasRadianGraph(this.writer, this.contentByte, this.document);
            }
            this.curveHasRadianGraph.setBaseChart(this);
            this.curveHasRadianGraph.setX(prevPoint.getX()).setY(prevPoint.getY()).setX0(x + curScoreX).setY0(y + this.realRowHeight[rowNum] * 1.0f / 2.0f).setHasCircle(true).setColor(this.curveColor);
            this.curveHasRadianGraph.chart();
        }
        TPoint curPoint = new TPoint();
        curPoint.setX(x + curScoreX);
        curPoint.setY(y + this.realRowHeight[rowNum] * 1.0f / 2.0f);
        return curPoint;
    }

    private void addTableHead(BaseColor borderColor, float sum) throws Exception {
        PdfPTable headTable = new PdfPTable(this.widths.length);
        headTable.setTotalWidth(this.width);
        headTable.setLockedWidth(true);
        headTable.setWidths(this.widths);
        PdfPCell cell = null;
        for (int k = 0; k < 2; ++k) {
            for (int i = 0; i < this.tableHeads.length; ++i) {
                cell = k == 0 && i != this.tableHeads.length - 1 ? this.addOneCell(new Font(this.baseFont, this.fontSize, 0, BaseColor.BLACK), this.tableHeads[i], this.everyColHeight(this.tableHeads[i], i, sum), new BaseColor(this.tableHeadColor), true) : this.addOneCell(new Font(this.baseFont, this.fontSize, 0, BaseColor.BLACK), "", 0.0f, new BaseColor(this.tableHeadColor), false);
                cell.setBorderColorRight(BaseColor.WHITE);
                cell.setBorderWidthRight(1.5f);
                cell.setBorderColorBottom(BaseColor.BLACK);
                cell.setBorderWidthBottom(0.5f);
                if (i == 0) {
                    cell.setBorderWidthLeft(1.0f);
                    cell.setBorderColorLeft(borderColor);
                } else if (i == this.tableHeads.length - 1) {
                    cell.setBorderColorRight(borderColor);
                    cell.setBorderWidthRight(1.0f);
                }
                headTable.addCell(cell);
            }
        }
        this.document.add((Element)headTable);
        float everyCell = this.width * this.widths[this.widths.length - 1] / sum;
        float sepWidth = everyCell / (float)(this.scoreLevels[this.scoreLevels.length - 1] - this.scoreLevels[0]);
        float posstion = (this.document.getPageSize().getWidth() - this.width) / 2.0f + this.width - everyCell + 3.0f;
        float y = this.writer.getVerticalPosition(true) + 3.0f;
        float offsetX = 0.0f;
        this.contentByte.setFontAndSize(this.baseFont, this.levelFontSize);
        this.contentByte.setColorFill(BaseColor.BLACK);
        for (int i = 0; i < this.scoreLevels.length; ++i) {
            offsetX = (float)(this.scoreLevels[i] - this.scoreLevels[0]) * sepWidth;
            if (i == this.scoreLevels.length - 1) {
                offsetX -= 5.0f;
            }
            this.moveText(this.contentByte, this.scoreLevels[i] + "", offsetX + posstion, y, i == this.scoreLevels.length - 1 ? 2 : 1, 0.0f);
        }
    }

    private float everyColHeight(String str, int curCol, float totalWidth) {
        float extendHeight = 0.0f;
        float everyCell = this.width * this.widths[curCol] / totalWidth;
        extendHeight = (float)str.length() * this.fontSize / everyCell;
        extendHeight = extendHeight > 1.0f ? (float)Math.ceil(extendHeight) : 1.0f;
        return extendHeight * this.lineHeight;
    }

    private void addTitleHead() throws Exception {
        PdfPTable headTable = new PdfPTable(1);
        headTable.setTotalWidth(this.width);
        headTable.setLockedWidth(true);
        this.addBorderColorCell(headTable, new Font(this.baseFont, this.fontSize, 1, BaseColor.WHITE), this.title, new BaseColor(this.titleColor), 1, this.lineHeight, 0, false);
        this.addBorderColorCell(headTable, new Font(this.baseFont, this.fontSize, 1, BaseColor.WHITE), " ", BaseColor.BLACK, 1, 3.0f, null, false);
        this.document.add((Element)headTable);
    }

    private PdfPCell addOneCell(Font pFont, String str, float height, BaseColor backColor, boolean isHasHeight) {
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(str, pFont));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setBackgroundColor(backColor);
        if (isHasHeight) {
            cell.setPaddingTop(6.0f);
            cell.setPaddingBottom(6.0f);
            cell.setFixedHeight(height);
        } else {
            cell.setPaddingTop(0.0f);
            cell.setPaddingBottom(0.0f);
            cell.setFixedHeight(height);
        }
        cell.setBorder(0);
        return cell;
    }

    public TableChartedDoubleArrowCurveChart setWidth(float width) {
        this.width = width;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setTitle(String title) {
        this.title = title;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setTitleColor(int titleColor) {
        this.titleColor = titleColor;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setTableHeads(String[] tableHeads) {
        this.tableHeads = tableHeads;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setScoreLevels(int[] scoreLevels) {
        this.scoreLevels = scoreLevels;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setTableHeadColor(int tableHeadColor) {
        this.tableHeadColor = tableHeadColor;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setParentTypes(String[] parentTypes) {
        this.parentTypes = parentTypes;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setParentTypeColor(int parentTypeColor) {
        this.parentTypeColor = parentTypeColor;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setChildrenTypes(List<String[]> childrenTypes) {
        this.childrenTypes = childrenTypes;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setScores(float[][] scores) {
        this.scores = scores;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setRowColors(int[] rowColors) {
        this.rowColors = rowColors;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setColNumber(int colNumber) {
        this.colNumber = colNumber;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setColColor(int colColor) {
        this.colColor = colColor;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setCurveColor(int curveColor) {
        this.curveColor = curveColor;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setLineHeight(float lineHeight) {
        this.lineHeight = lineHeight;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setWidths(float[] widths) {
        this.widths = widths;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setLevelFontSize(float levelFontSize) {
        this.levelFontSize = levelFontSize;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setMaxScoreColNum(int maxScoreColNum) {
        this.maxScoreColNum = maxScoreColNum;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setMinScoreColNum(int minScoreColNum) {
        this.minScoreColNum = minScoreColNum;
        return this;
    }

    public TableChartedDoubleArrowCurveChart setCurScoreColNum(int curScoreColNum) {
        this.curScoreColNum = curScoreColNum;
        return this;
    }

    public float getPositionY() {
        return this.positionY;
    }

    private void calPositionY(float y) {
        int i;
        float y0 = 0.0f;
        int n = i = this.lineNumber > 0 && this.lineNumber < this.realRowHeight.length ? this.lineNumber : 0;
        while (i < this.realRowHeight.length) {
            y0 += this.realRowHeight[i];
            ++i;
        }
        this.positionY = y - y0 - 5.0f;
    }
}

