/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.chart;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import java.text.DecimalFormat;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TableDashTableRectChart
extends AbstractChart {
    private float x;
    private float width = 450.0f;
    private float y;
    private int[] levels;
    private String[] itemNames;
    private String[] headNames;
    private float[] scores;
    private int levelShowInColmun = 2;
    private float[] colWidths;
    private float fontSize = 9.0f;
    private int fontColor = 0;
    private float positionY;
    private int fillRectColor = 13459786;
    private int fristColmunBackgroundColor = 14675706;
    private int borderColor = 0xAAAAAA;
    private int headBackgroundColor = 476808;
    private float cellHeight = 25.0f;
    private float headFontSize = 12.0f;
    private int scale = 2;

    public TableDashTableRectChart() {
    }

    public TableDashTableRectChart(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    public TableDashTableRectChart setScale(int scale) {
        this.scale = scale;
        return this;
    }

    @Override
    public void chart() {
        this.positionY = 0.0f;
        if (ObjectUtils.equals(null, (Object)this.itemNames) || this.itemNames.length < 1 || ObjectUtils.equals(null, (Object)this.headNames) || this.headNames.length < 1 || ObjectUtils.equals(null, (Object)this.scores) || this.scores.length < 1) {
            throw new RuntimeException("\u8bf7\u68c0\u6d4bitemNames\u3001headNames\u3001scores\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (ObjectUtils.equals(null, (Object)this.levels)) {
            this.levels = new int[]{10, 20, 30, 40, 50, 60, 70, 80, 90};
        }
        if (ObjectUtils.equals(null, (Object)this.colWidths)) {
            this.colWidths = new float[]{15.0f, 70.0f, 15.0f};
        }
        float sum = 0.0f;
        for (float s : this.colWidths) {
            sum += s;
        }
        BaseColor fontColor_ = new BaseColor(this.fontColor);
        BaseColor headBackgroundColor_ = new BaseColor(this.headBackgroundColor);
        BaseColor borderColor_ = new BaseColor(this.borderColor);
        try {
            this.addTableHead(headBackgroundColor_, sum);
            this.addBody(borderColor_, fontColor_, sum);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawMulRowText(float lineHeight, float witdh, float fontSize_, String text, float x, float y) {
        this.moveMultiLineText(this.contentByte, text, fontSize_, witdh, lineHeight, x, y, 0);
    }

    private float calTableHeadHeight(float sum, float fontSize) {
        float width = 0.0f;
        int lineNumber = 0;
        for (int i = 0; i < this.colWidths.length; ++i) {
            width = this.width * this.colWidths[i] / sum;
            lineNumber = Math.max(lineNumber, (int)Math.ceil((float)this.itemNames[i].length() * fontSize / width));
        }
        return (float)(lineNumber - 1) * fontSize + this.cellHeight;
    }

    private void addTableHead(BaseColor headBackgroundColor, float sum) throws Exception {
        float x1 = 0.0f;
        float levelWidth = 0.0f;
        float x0 = this.x;
        float y0 = this.y;
        this.contentByte.setFontAndSize(this.baseFont, this.headFontSize);
        float realHeight = this.calTableHeadHeight(sum, this.headFontSize);
        this.positionY += realHeight;
        for (int i = 0; i < this.colWidths.length; ++i) {
            if (i + 1 == this.levelShowInColmun) {
                x1 = x0;
                levelWidth = this.width * this.colWidths[i] / sum;
            }
            this.moveRect(this.contentByte, x0, y0, x0 + this.width * this.colWidths[i] / sum, y0 - realHeight, this.headBackgroundColor, new boolean[0]);
            if (i + 1 != this.levelShowInColmun) {
                this.contentByte.setColorFill(BaseColor.WHITE);
                this.drawMulRowText(realHeight, this.width * this.colWidths[i] / sum, this.headFontSize, this.headNames[i], x0, y0);
            }
            x0 += this.width * this.colWidths[i] / sum;
            if (i == this.colWidths.length - 1) continue;
            this.contentByte.setColorStroke(BaseColor.BLACK);
            this.contentByte.setLineWidth(1.5f);
            this.moveLine(this.contentByte, x0, y0, x0, y0 - realHeight + 0.3f);
        }
        this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
        this.contentByte.setColorFill(BaseColor.WHITE);
        this.contentByte.setColorStroke(BaseColor.WHITE);
        float sepWidth = levelWidth / (float)this.levels[this.levels.length - 1];
        this.contentByte.setLineWidth(1.0f);
        for (int j = 0; j < this.levels.length; ++j) {
            if (j == this.levels.length - 1) continue;
            this.moveText(this.contentByte, this.levels[j] + "", x1 + sepWidth * (float)this.levels[j], y0 - realHeight + 3.0f, 1, 0.0f);
            this.moveLine(this.contentByte, x1 + sepWidth * (float)this.levels[j], y0 - realHeight, x1 + sepWidth * (float)this.levels[j], y0 - realHeight + 3.0f);
        }
    }

    private void addBody(BaseColor borderColor, BaseColor fontColor, float sum) throws Exception {
        DecimalFormat df = new DecimalFormat("0" + (this.scale == 0 ? "" : "." + StringUtils.repeat((String)"#", (int)this.scale)));
        float x1 = 0.0f;
        float levelWidth = 0.0f;
        float x0 = this.x;
        float y0 = this.y;
        float realHeight = this.calTableHeadHeight(sum, this.headFontSize);
        this.contentByte.setColorStroke(BaseColor.BLACK);
        this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
        for (int k = 0; k < this.itemNames.length; ++k) {
            x0 = this.x;
            y0 -= realHeight;
            for (int i = 0; i < this.colWidths.length; ++i) {
                if (i + 1 != this.levelShowInColmun) {
                    this.contentByte.setColorFill(fontColor);
                    switch (i) {
                        case 0: {
                            realHeight = this.calTableHeadHeight(sum, this.fontSize);
                            this.positionY += realHeight;
                            this.moveRect(this.contentByte, x0, y0, x0 + this.width * this.colWidths[i] / sum, y0 - realHeight, this.fristColmunBackgroundColor, new boolean[0]);
                            this.drawMulRowText(realHeight, this.width * this.colWidths[i] / sum, this.fontSize, this.itemNames[k], x0, y0);
                            break;
                        }
                        default: {
                            this.drawMulRowText(realHeight, this.width * this.colWidths[i] / sum, this.fontSize, df.format(this.scores[k]), x0, y0);
                            break;
                        }
                    }
                } else {
                    levelWidth = this.width * this.colWidths[i] / sum;
                    float sepWidth = levelWidth / (float)this.levels[this.levels.length - 1];
                    x1 = x0 + this.scores[k] * sepWidth;
                    this.moveRect(this.contentByte, x0, y0 - realHeight / 4.0f, x1, y0 - realHeight * 3.0f / 4.0f, this.fillRectColor, new boolean[0]);
                }
                this.contentByte.setColorStroke(borderColor);
                this.contentByte.setLineWidth(2.0f);
                this.contentByte.setLineDash(2.0f, 2.0f);
                this.moveLine(this.contentByte, x0 += this.width * this.colWidths[i] / sum, y0, x0, y0 - realHeight + 0.3f);
                this.moveLine(this.contentByte, x0 - this.width * this.colWidths[i] / sum, y0, x0 - this.width * this.colWidths[i] / sum, y0 - realHeight + 0.3f);
                this.moveLine(this.contentByte, x0, y0 - realHeight + 0.3f, x0 - this.width * this.colWidths[i] / sum, y0 - realHeight + 0.3f);
            }
        }
    }

    public TableDashTableRectChart setWidth(float width) {
        this.width = width;
        return this;
    }

    public TableDashTableRectChart setScores(float[] scores) {
        this.scores = scores;
        return this;
    }

    public TableDashTableRectChart setX(float x) {
        this.x = x;
        return this;
    }

    public TableDashTableRectChart setY(float y) {
        this.y = y;
        return this;
    }

    public TableDashTableRectChart setLevels(int[] levels) {
        this.levels = levels;
        return this;
    }

    public TableDashTableRectChart setItemNames(String[] itemNames) {
        this.itemNames = itemNames;
        return this;
    }

    public TableDashTableRectChart setHeadNames(String[] headNames) {
        this.headNames = headNames;
        return this;
    }

    public TableDashTableRectChart setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public TableDashTableRectChart setFillRectColor(int fillRectColor) {
        this.fillRectColor = fillRectColor;
        return this;
    }

    public TableDashTableRectChart setFristColmunBackgroundColor(int fristColmunBackgroundColor) {
        this.fristColmunBackgroundColor = fristColmunBackgroundColor;
        return this;
    }

    public TableDashTableRectChart setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public TableDashTableRectChart setHeadBackgroundColor(int headBackgroundColor) {
        this.headBackgroundColor = headBackgroundColor;
        return this;
    }

    public TableDashTableRectChart setLevelShowInColmun(int levelShowInColmun) {
        this.levelShowInColmun = levelShowInColmun;
        return this;
    }

    public TableDashTableRectChart setColWidths(float[] colWidths) {
        this.colWidths = colWidths;
        return this;
    }

    public TableDashTableRectChart setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public TableDashTableRectChart setCellHeight(float cellHeight) {
        this.cellHeight = cellHeight;
        return this;
    }

    public TableDashTableRectChart setHeadFontSize(float headFontSize) {
        this.headFontSize = headFontSize;
        return this;
    }

    public float getPositionY() {
        this.positionY = this.y - this.positionY - 10.0f;
        return this.positionY;
    }
}

