/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.chart;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.base.unit.BalloonGraph;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class TableGradeDistributionChart
extends AbstractChart {
    private float x;
    private float width = 450.0f;
    private float y;
    private String[] gradeNames;
    private List<String[]> dataAreas;
    private int[] gradeBackgroundColors;
    private float[] levels;
    private String[] tagNames;
    private float curScore;
    private int[] percentageLevels;
    private float fontSize = 10.0f;
    private float firstColumnFontSize = 8.0f;
    private int borderColor = 0x999999;
    private int fontColor = 0;
    private String percentageName = "\u767e\u5206\u6bd4";
    private float positionY;
    private int autoAddPercentageSymbolIndex = 0;
    private int firstColumnBackgroundColor = 0xEEEEEE;

    public TableGradeDistributionChart() {
    }

    public TableGradeDistributionChart(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        this.positionY = 0.0f;
        if (ObjectUtils.equals(null, this.dataAreas) || this.dataAreas.isEmpty()) {
            throw new RuntimeException("\u8bf7\u68c0\u6d4bdataAreas\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (ObjectUtils.equals(null, (Object)this.levels)) {
            this.levels = new float[]{1.2f, 1.1f, 1.0f, 0.9f, 0.8f};
        }
        if (ObjectUtils.equals(null, (Object)this.gradeNames)) {
            this.gradeNames = new String[]{"\u4f18\u79c0", "\u826f\u597d", "\u5408\u683c", "\u5f85\u53d1\u5c55"};
        }
        if (ObjectUtils.equals(null, (Object)this.tagNames)) {
            this.tagNames = new String[]{"\u7b49\u7ea7", "\u6240\u5360\u6bd4\u4f8b", "\u4eba\u6570", "\u5206\u6bb5\u6570"};
        }
        if (ObjectUtils.equals(null, (Object)this.percentageLevels)) {
            this.percentageLevels = new int[]{0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100};
        }
        if (ObjectUtils.equals(null, (Object)this.gradeBackgroundColors)) {
            this.gradeBackgroundColors = new int[]{6149040, 9621584, 0xFFC000, 16552507};
        }
        BaseColor borderColor_ = new BaseColor(this.borderColor);
        BaseColor fontColor_ = new BaseColor(this.fontColor);
        BaseColor[] gradeBackgroundColors_ = new BaseColor[this.gradeBackgroundColors.length];
        for (int i = 0; i < this.gradeBackgroundColors.length; ++i) {
            gradeBackgroundColors_[i] = new BaseColor(this.gradeBackgroundColors[i]);
        }
        try {
            this.contentByte.setLineWidth(1.0f);
            this.contentByte.setColorStroke(borderColor_);
            this.contentByte.setColorFill(fontColor_);
            float colHeihgt = 30.0f;
            this.drawPercentage();
            this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
            this.setLine(1, 8.0f, this.document);
            this.drawTable(colHeihgt);
            this.drawTag(colHeihgt, borderColor_);
            this.contentByte.setColorStroke(borderColor_);
            this.drawLine(colHeihgt, this.y - 13.0f, this.dataAreas.size() + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawTable(float colHeihgt) {
        String[] columnWidth = this.dataAreas.get(this.autoAddPercentageSymbolIndex);
        float sepWidth = this.width / (float)(this.percentageLevels[this.percentageLevels.length - 1] - this.percentageLevels[0]);
        float x0 = this.x;
        this.positionY += colHeihgt;
        for (int i = 0; i < this.gradeNames.length; ++i) {
            this.moveRect(this.contentByte, x0, this.y - 15.0f, x0 + sepWidth * (Float.parseFloat(columnWidth[i]) - (float)this.percentageLevels[0]) - 1.0f, this.y - colHeihgt - 15.0f, this.gradeBackgroundColors[i % this.gradeBackgroundColors.length], new boolean[0]);
            this.contentByte.setColorFill(BaseColor.BLACK);
            this.drawMulRowText(colHeihgt, sepWidth * (Float.parseFloat(columnWidth[i]) - (float)this.percentageLevels[0]), this.gradeNames[i], x0 - 0.1f, this.y - this.fontSize / 2.0f - (colHeihgt - this.fontSize) / 2.0f);
            this.drawMulRowText(colHeihgt, sepWidth * (Float.parseFloat(columnWidth[i]) - (float)this.percentageLevels[0]), this.gradeNames[i], x0 + 0.1f, this.y - this.fontSize / 2.0f - (colHeihgt - this.fontSize) / 2.0f);
            this.drawMulRowText(colHeihgt, sepWidth * (Float.parseFloat(columnWidth[i]) - (float)this.percentageLevels[0]), this.gradeNames[i], x0, 0.1f + this.y - this.fontSize / 2.0f - (colHeihgt - this.fontSize) / 2.0f);
            this.drawMulRowText(colHeihgt, sepWidth * (Float.parseFloat(columnWidth[i]) - (float)this.percentageLevels[0]), this.gradeNames[i], x0, -0.1f + this.y - this.fontSize / 2.0f - (colHeihgt - this.fontSize) / 2.0f);
            x0 += sepWidth * (Float.parseFloat(columnWidth[i]) - (float)this.percentageLevels[0]);
        }
        String[] rowCell = null;
        float y0 = this.y;
        for (int j = 0; j < this.dataAreas.size(); ++j) {
            x0 = this.x;
            y0 -= colHeihgt;
            this.positionY += colHeihgt;
            rowCell = this.dataAreas.get(j);
            for (int i = 0; i < rowCell.length; ++i) {
                this.drawMulRowText(colHeihgt, sepWidth * (Float.parseFloat(columnWidth[i]) - (float)this.percentageLevels[0]), rowCell[i] + (j == this.autoAddPercentageSymbolIndex ? "%" : ""), j == this.autoAddPercentageSymbolIndex ? x0 + this.fontSize : x0, y0 - this.fontSize / 2.0f - (colHeihgt - this.fontSize) / 2.0f);
                x0 += sepWidth * (Float.parseFloat(columnWidth[i]) - (float)this.percentageLevels[0]);
            }
        }
        this.positionY += colHeihgt;
    }

    private void drawMulRowText(float lineHeight, float witdh, String text, float x, float y) {
        float fontSize = text.matches("^(?:\\d{1,})|(?:\\d{1,}\\.\\d{1,})$") || text.endsWith("%") ? this.fontSize / 2.0f : this.fontSize;
        float lineNumber = (float)text.length() * fontSize / witdh;
        lineNumber = lineNumber > 1.0f ? (float)Math.ceil(lineNumber) : 1.0f;
        int everyLen = Math.round((float)text.length() / lineNumber);
        String tempText = null;
        float x0 = 0.0f;
        float y0 = y - (lineHeight - lineNumber * this.fontSize) / 2.0f - this.fontSize + 1.0f;
        int i = 0;
        while ((float)i < lineNumber) {
            tempText = text.substring(i * everyLen, lineNumber > 1.0f && (float)i == lineNumber - 1.0f ? text.length() : everyLen * (i + 1));
            x0 = x + (witdh - (float)tempText.length() * fontSize) / 2.0f;
            if (text.endsWith("%")) {
                this.moveText(this.contentByte, tempText, x0, y0, 1, 0.0f);
            } else {
                this.moveText(this.contentByte, tempText, x0, y0, 0, 0.0f);
            }
            y0 -= this.fontSize + 1.0f;
            ++i;
        }
    }

    private void drawLine(float colHeihgt, float y0, int rows) {
        float offset = 3.0f;
        this.contentByte.setLineDash(4.0f, 2.0f, 0.0f);
        for (int i = 0; i < rows; ++i) {
            this.moveLine(this.contentByte, this.x, y0 - offset, this.x + this.width, y0 - offset);
            offset += colHeihgt;
        }
        this.moveLine(this.contentByte, this.x, y0 - offset, this.x + this.width, y0 - offset);
        String[] columnWidth = this.dataAreas.get(this.autoAddPercentageSymbolIndex);
        this.contentByte.setLineWidth(1.0f);
        this.contentByte.setLineDash(1.0f);
        float sepWidth = this.width / (float)(this.percentageLevels[this.percentageLevels.length - 1] - this.percentageLevels[0]);
        offset = 0.0f;
        rows = this.dataAreas.size() + 1;
        for (int j = 0; j < rows; ++j) {
            for (int i = 0; i < columnWidth.length; ++i) {
                this.moveLine(this.contentByte, this.x + offset, y0 - 3.0f, this.x + offset, y0 - colHeihgt - 3.0f);
                offset += sepWidth * (Float.parseFloat(columnWidth[i]) - (float)this.percentageLevels[0]);
            }
            this.moveLine(this.contentByte, this.x + offset, y0 - 3.0f, this.x + offset, y0 - colHeihgt - 3.0f);
            y0 -= colHeihgt;
            offset = 0.0f;
        }
    }

    private void drawTag(float colHeihgt, BaseColor borderColor) {
        String[] columnWidth = this.dataAreas.get(this.autoAddPercentageSymbolIndex);
        this.contentByte.setFontAndSize(this.baseFont, this.firstColumnFontSize);
        this.contentByte.setColorFill(BaseColor.BLACK);
        float y1 = this.y - 10.0f;
        for (int i = 0; i < this.tagNames.length; ++i) {
            this.moveRect(this.contentByte, this.x - this.firstColumnFontSize * 7.0f, y1 - 5.0f, this.x - 1.5f, y1 - colHeihgt - 5.0f, i == this.tagNames.length - 1 ? 0xFFFFFF : this.firstColumnBackgroundColor, new boolean[0]);
            this.drawMulRowText(colHeihgt, this.firstColumnFontSize * 7.0f, this.tagNames[i], this.x - this.firstColumnFontSize * 7.0f, i == this.tagNames.length - 1 ? y1 + 10.0f - (colHeihgt - this.fontSize) / 2.0f : y1 + 5.0f - (colHeihgt - this.fontSize) / 2.0f);
            y1 -= colHeihgt + 1.0f;
        }
        float rowY = this.y - colHeihgt * (float)(this.dataAreas.size() + 1) - 10.0f;
        float widthX = this.fontSize;
        float sepWidth = this.width / (float)(this.percentageLevels[this.percentageLevels.length - 1] - this.percentageLevels[0]);
        for (int i = 0; i < columnWidth.length; ++i) {
            this.moveText(this.contentByte, this.levels[i] + "", this.x + widthX, rowY - 14.0f - this.fontSize, 2, 0.0f);
            widthX += sepWidth * (Float.parseFloat(columnWidth[i]) - (float)this.percentageLevels[0]);
        }
        this.moveText(this.contentByte, this.levels[this.levels.length - 1] + "", this.x + widthX, rowY - 14.0f - this.fontSize, 2, 0.0f);
    }

    private void drawPercentage() throws Exception {
        this.contentByte.setFontAndSize(this.baseFont, this.firstColumnFontSize);
        this.moveText(this.contentByte, this.percentageName, this.x - this.firstColumnFontSize * 3.0f, this.y, 2, 0.0f);
        this.moveLine(this.contentByte, this.x, this.y - 5.0f, this.width + this.x, this.y - 5.0f);
        float sepWidth = this.width / (float)(this.percentageLevels[this.percentageLevels.length - 1] - this.percentageLevels[0]);
        int length = this.percentageLevels.length;
        for (int i = 0; i < length; ++i) {
            this.moveText(this.contentByte, this.percentageLevels[i] + "%", this.x + sepWidth * (float)(this.percentageLevels[i] - this.percentageLevels[0]), this.y, 1, 0.0f);
            this.moveLine(this.contentByte, this.x + sepWidth * (float)(this.percentageLevels[i] - this.percentageLevels[0]), this.y - 5.0f, this.x + sepWidth * (float)(this.percentageLevels[i] - this.percentageLevels[0]), this.y - 10.0f);
        }
        BalloonGraph balloonGraph = new BalloonGraph(this.writer, this.contentByte, this.document);
        balloonGraph.setBaseChart(this);
        balloonGraph.setY(this.y + this.firstColumnFontSize + 2.0f).setX(this.x + sepWidth * (this.curScore - (float)this.percentageLevels[0]) - 1.5f);
        balloonGraph.chart();
    }

    public TableGradeDistributionChart setX(float x) {
        this.x = x;
        return this;
    }

    public TableGradeDistributionChart setWidth(float width) {
        this.width = width;
        return this;
    }

    public TableGradeDistributionChart setY(float y) {
        this.y = y;
        return this;
    }

    public TableGradeDistributionChart setLevels(float[] levels) {
        this.levels = levels;
        return this;
    }

    public TableGradeDistributionChart setTagNames(String[] tagNames) {
        this.tagNames = tagNames;
        return this;
    }

    public TableGradeDistributionChart setGradeNames(String[] gradeNames) {
        this.gradeNames = gradeNames;
        return this;
    }

    public TableGradeDistributionChart setDataAreas(List<String[]> dataAreas) {
        this.dataAreas = dataAreas;
        return this;
    }

    public TableGradeDistributionChart setGradeBackgroundColors(int[] gradeBackgroundColors) {
        this.gradeBackgroundColors = gradeBackgroundColors;
        return this;
    }

    public TableGradeDistributionChart setCurScore(float curScore) {
        this.curScore = curScore;
        return this;
    }

    public TableGradeDistributionChart setPercentageLevels(int[] percentageLevels) {
        this.percentageLevels = percentageLevels;
        return this;
    }

    public TableGradeDistributionChart setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public TableGradeDistributionChart setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public TableGradeDistributionChart setPercentageName(String percentageName) {
        this.percentageName = percentageName;
        return this;
    }

    public TableGradeDistributionChart setAutoAddPercentageSymbolIndex(int autoAddPercentageSymbolIndex) {
        this.autoAddPercentageSymbolIndex = autoAddPercentageSymbolIndex;
        return this;
    }

    public TableGradeDistributionChart setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public TableGradeDistributionChart setFirstColumnFontSize(float firstColumnFontSize) {
        this.firstColumnFontSize = firstColumnFontSize;
        return this;
    }

    public TableGradeDistributionChart setFirstColumnBackgroundColor(int firstColumnBackgroundColor) {
        this.firstColumnBackgroundColor = firstColumnBackgroundColor;
        return this;
    }

    public float getPositionY() {
        this.positionY = this.y - this.positionY - 10.0f;
        return this.positionY;
    }
}

