/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.chart;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import org.apache.commons.lang3.ObjectUtils;

public class TableHistogramChart
extends AbstractChart {
    private float x;
    private float y;
    private float height = 120.0f;
    private float width = 450.0f;
    private float fontSize = 10.0f;
    private int[] levels;
    private String[] gradeNames;
    private float[] scores;
    private String[] scoreRanges;
    private String[] peopleNumbers;
    private int[] histogramBackgroundColors;
    private int levelFontColor = 5146053;
    private int fontColor = 0;
    private int borderColor = 0xAAAAAA;
    private int levelBorderColor = 0xCCCCCC;
    private int cellBackgroundColor = 0xEEEEEE;
    private String tagName = "\u4eba\u6570";
    private float positionY;

    public TableHistogramChart() {
    }

    public TableHistogramChart(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        this.positionY = 0.0f;
        if (ObjectUtils.equals(null, (Object)this.peopleNumbers) || this.peopleNumbers.length < 1 || ObjectUtils.equals(null, (Object)this.scores) || this.scores.length < 1) {
            throw new RuntimeException("\u8bf7\u68c0\u6d4bitemNames\u3001scores\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (ObjectUtils.equals(null, (Object)this.levels)) {
            this.levels = new int[]{5, 15, 25, 35, 45, 55};
        }
        if (ObjectUtils.equals(null, (Object)this.gradeNames)) {
            this.gradeNames = new String[]{"\u4f18\u79c0", "\u826f\u597d", "\u5408\u683c", "\u5f85\u53d1\u5c55"};
        }
        if (ObjectUtils.equals(null, (Object)this.scoreRanges)) {
            this.scoreRanges = new String[]{"1.1-1.2", "1.0-1.1", "0.9-1.0", "0.8-0.9"};
        }
        if (ObjectUtils.equals(null, (Object)this.histogramBackgroundColors)) {
            this.histogramBackgroundColors = new int[]{6149040, 9621584, 0xFFC000, 16552507};
        }
        try {
            BaseColor fontColor_ = new BaseColor(this.fontColor);
            BaseColor borderColor_ = new BaseColor(this.borderColor);
            BaseColor levelFontColor_ = new BaseColor(this.levelFontColor);
            BaseColor levelBorderColor_ = new BaseColor(this.levelBorderColor);
            this.contentByte.setLineWidth(1.0f);
            this.contentByte.setColorStroke(borderColor_);
            this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
            this.contentByte.setColorFill(levelFontColor_);
            this.drawFrame(levelBorderColor_);
            this.contentByte.setColorFill(fontColor_);
            this.drawScores();
            this.setLine(7, 11.55f, this.document);
            this.drawTable(levelBorderColor_);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawTable(BaseColor cellBackgroudColor) throws Exception {
        float y0 = this.y - 2.0f;
        float x0 = this.x;
        float sepWidth = this.width / (float)this.gradeNames.length - 1.0f;
        float cellHeight = 40.0f;
        float temp = 0.0f;
        this.positionY += cellHeight;
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < this.gradeNames.length; ++i) {
                this.moveRect(this.contentByte, x0, y0, x0 + sepWidth, y0 - cellHeight, this.cellBackgroundColor, new boolean[0]);
                switch (j) {
                    case 0: {
                        temp = (sepWidth - (float)this.gradeNames[i].length() * this.fontSize) / 2.0f;
                        this.moveText(this.contentByte, this.gradeNames[i], x0 + temp + 0.1f, y0 - (cellHeight - this.fontSize) / 2.0f, 0, 0.0f);
                        this.moveText(this.contentByte, this.gradeNames[i], x0 + temp - 0.1f, y0 - (cellHeight - this.fontSize) / 2.0f, 0, 0.0f);
                        this.moveText(this.contentByte, this.gradeNames[i], x0 + temp, y0 - (cellHeight - this.fontSize) / 2.0f + 0.1f, 0, 0.0f);
                        this.moveText(this.contentByte, this.gradeNames[i], x0 + temp, y0 - (cellHeight - this.fontSize) / 2.0f - 0.1f, 0, 0.0f);
                        temp = (sepWidth - (float)this.scoreRanges[i].length() * this.fontSize / 2.0f) / 2.0f;
                        this.moveText(this.contentByte, this.scoreRanges[i], x0 + temp + 0.1f, y0 - cellHeight + (cellHeight - this.fontSize) / 2.0f - 2.0f, 0, 0.0f);
                        this.moveText(this.contentByte, this.scoreRanges[i], x0 + temp - 0.1f, y0 - cellHeight + (cellHeight - this.fontSize) / 2.0f - 2.0f, 0, 0.0f);
                        this.moveText(this.contentByte, this.scoreRanges[i], x0 + temp, y0 - cellHeight + (cellHeight - this.fontSize) / 2.0f - 2.0f + 0.1f + 0.1f, 0, 0.0f);
                        this.moveText(this.contentByte, this.scoreRanges[i], x0 + temp, y0 - cellHeight + (cellHeight - this.fontSize) / 2.0f - 2.0f - 0.1f, 0, 0.0f);
                        break;
                    }
                    case 1: {
                        temp = (sepWidth - (float)this.peopleNumbers[i].length() * this.fontSize / 2.0f) / 2.0f;
                        this.moveText(this.contentByte, this.peopleNumbers[i], x0 + temp, y0 - cellHeight + (cellHeight - this.fontSize) / 2.0f, 0, 0.0f);
                        break;
                    }
                }
                x0 += sepWidth + 1.0f;
            }
            y0 -= cellHeight + 1.0f;
            x0 = this.x;
            cellHeight = 20.0f;
            this.positionY += cellHeight;
        }
        temp = (float)this.tagName.length() * this.fontSize * 3.0f;
        this.moveRect(this.contentByte, this.x - temp, y0 + cellHeight, this.x - 1.0f, y0 + 1.0f, this.cellBackgroundColor, new boolean[0]);
        temp = this.x - temp + (temp - (float)this.tagName.length() * this.fontSize) / 2.0f;
        this.moveText(this.contentByte, this.tagName, temp, y0 + 1.0f + (cellHeight - this.fontSize) / 2.0f, 0, 0.0f);
    }

    private void drawFrame(BaseColor levelBorderColor) {
        this.moveLine(this.contentByte, this.x, this.y, this.x + this.width, this.y);
        this.moveLine(this.contentByte, this.x, this.y, this.x, this.y + this.height);
        this.contentByte.setColorStroke(levelBorderColor);
        float x1 = this.x;
        float y1 = 0.0f;
        float kHeight = this.height / (float)(this.levels[0] - this.levels[this.levels.length - 1]);
        for (int i = 0; i < this.levels.length; ++i) {
            y1 = this.y + kHeight * (float)(this.levels[0] - this.levels[i]);
            this.contentByte.setLineDash(1.0f);
            this.moveLine(this.contentByte, x1, y1, this.x - 2.0f, y1);
            this.moveText(this.contentByte, this.levels[i] + "%", x1 - 6.0f, y1 - 3.0f, 2, 0.0f);
            this.contentByte.setLineDash(1.0f, 2.0f, 0.0f);
            this.moveLine(this.contentByte, x1, y1, x1 + this.width, y1);
        }
    }

    private void drawScores() {
        float kHeight = this.height / (float)(this.levels[this.levels.length - 1] - this.levels[0]);
        float x1 = this.x;
        float y1 = this.y + 0.8f;
        float kWidth = this.width / (float)this.scores.length;
        int color = 0;
        for (int i = 0; i < this.scores.length; ++i) {
            float h = kHeight * (this.scores[i] - (float)this.levels[0]);
            color = this.histogramBackgroundColors[i % this.histogramBackgroundColors.length];
            this.contentByte.setLineDash(1.0f);
            this.moveRect(this.contentByte, (x1 += kWidth) - 3.0f * kWidth / 4.0f, y1, x1 - kWidth / 4.0f, y1 + h - 0.8f, color, new boolean[0]);
            this.moveText(this.contentByte, this.scores[i] + "%", x1 - kWidth / 2.0f, y1 + h + 2.0f, 1, 0.0f);
        }
    }

    public TableHistogramChart setX(float x) {
        this.x = x;
        return this;
    }

    public TableHistogramChart setY(float y) {
        this.y = y;
        return this;
    }

    public TableHistogramChart setHeight(float height) {
        this.height = height;
        return this;
    }

    public TableHistogramChart setWidth(float width) {
        this.width = width;
        return this;
    }

    public TableHistogramChart setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public TableHistogramChart setLevels(int[] levels) {
        this.levels = levels;
        return this;
    }

    public TableHistogramChart setGradeNames(String[] gradeNames) {
        this.gradeNames = gradeNames;
        return this;
    }

    public TableHistogramChart setScores(float[] scores) {
        this.scores = scores;
        return this;
    }

    public TableHistogramChart setScoreRanges(String[] scoreRanges) {
        this.scoreRanges = scoreRanges;
        return this;
    }

    public TableHistogramChart setPeopleNumbers(String[] peopleNumbers) {
        this.peopleNumbers = peopleNumbers;
        return this;
    }

    public TableHistogramChart setHistogramBackgroundColors(int[] histogramBackgroundColors) {
        this.histogramBackgroundColors = histogramBackgroundColors;
        return this;
    }

    public TableHistogramChart setLevelFontColor(int levelFontColor) {
        this.levelFontColor = levelFontColor;
        return this;
    }

    public TableHistogramChart setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public TableHistogramChart setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public TableHistogramChart setLevelBorderColor(int levelBorderColor) {
        this.levelBorderColor = levelBorderColor;
        return this;
    }

    public TableHistogramChart setTagName(String tagName) {
        this.tagName = tagName;
        return this;
    }

    public float getPositionY() {
        this.positionY = this.y - this.positionY + 10.0f;
        return this.positionY;
    }
}

